/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.util;

import com.tridium.sys.Nre;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.baja.file.BIFile;
import javax.baja.file.FilePath;
import javax.baja.license.Feature;
import javax.baja.license.FeatureNotLicensedException;
import javax.baja.naming.BLocalHost;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdTarget;
import javax.baja.naming.UnresolvedException;
import javax.baja.nre.platform.RuntimeProfile;
import javax.baja.nre.util.TextUtil;
import javax.baja.sys.BObject;
import javax.baja.sys.Sys;

public class ModuleDev {
    private File moduleDevFile;
    private Properties moduleDevProperties;
    private Boolean licenseOk;
    private Set<String> supportedExtensions = new HashSet<String>();
    private List<String> moduleDevSrcList = new ArrayList<String>();
    private final AtomicBoolean initialized = new AtomicBoolean(false);
    private static final Pattern MODULE_NAME_TOKEN_REGEX = Pattern.compile("\\{\\{moduleName\\}\\}");
    private static final Pattern RUNTIME_PROFILE_REGEX = Pattern.compile("(-rt\\.|-wb\\.|-ux\\.|-se\\.|-doc\\.)");
    private static final String defaultExtensions = "js,css,vm,htm,html,hbs,jpg,gif,png,less,map,lexicon";
    private static final String moduleDevExtensionsPropName = "niagara.module.dev.supportedExtensions";
    private static final String moduleDevFileName = "moduledev.properties";
    private static final String moduleDevPropName = "niagara.module.dev";
    private static final String moduleDevWbPropName = "niagara.module.dev.wb";
    private static final Logger moduleDevLog = Logger.getLogger("niagara.module.dev");
    private static final boolean moduleDevRequested = ModuleDev.isModuleDevRequested();
    private static final boolean prioritizeBuildDirectory = AccessController.doPrivileged(() -> !"false".equals(System.getProperty("niagara.module.dev.prioritizeBuildDirectory")));

    public ModuleDev() {
        this.moduleDevFile = new File(Nre.getNiagaraHome(), "etc/moduledev.properties");
    }

    public ModuleDev(Properties properties) {
        this.moduleDevProperties = properties;
    }

    public boolean isEnabled() {
        return moduleDevRequested && this.isLicensed();
    }

    public Optional<OrdTarget> makeModuleDevOrdTarget(FilePath path) {
        ModuleDevEntry moduleDevEntry = this.readModuleDevEntry(path);
        if (moduleDevEntry != null) {
            String moduleName = moduleDevEntry.moduleName;
            String moduleDir = moduleDevEntry.moduleDir;
            String ordPath = path.getBody().substring(moduleName.length() + 2);
            for (String subDir : this.moduleDevSrcList) {
                OrdTarget ordTarget;
                String subSrcDir = MODULE_NAME_TOKEN_REGEX.matcher(subDir).replaceFirst(moduleName);
                FilePath filePath = new FilePath(String.format("/%s%s%s", moduleDir, subSrcDir, ordPath));
                if (path.toString().contains(moduleName + "/" + moduleName) && path.toString().endsWith(".lexicon")) {
                    if (!ModuleDev.sameModulePart(ordPath, subSrcDir)) continue;
                    String body = filePath.getBody();
                    body = RUNTIME_PROFILE_REGEX.matcher(body).replaceAll(".");
                    body = TextUtil.replace((String)body, (String)(moduleName + ".lexicon"), (String)"module.lexicon");
                    filePath = new FilePath(body);
                }
                if ((ordTarget = this.resolveLocalFile(filePath)) == null) continue;
                moduleDevLog.info(String.format("Module Dev (%s) -> %s", subSrcDir, filePath));
                return Optional.of(ordTarget);
            }
            throw new UnresolvedException(Objects.toString(path));
        }
        if (moduleDevLog.isLoggable(Level.FINE)) {
            moduleDevLog.fine(String.format("Module Dev entry not found for %s (%s)", path.getAuthority(), path));
        }
        return Optional.empty();
    }

    private static boolean sameModulePart(String ordPath, String subSrcDir) {
        try {
            int dashOrd = ordPath.indexOf(45);
            int srcOrd = subSrcDir.indexOf(45);
            if (dashOrd > -1 && srcOrd > -1) {
                return ordPath.substring(dashOrd, dashOrd + 2).equals(subSrcDir.substring(srcOrd, srcOrd + 2));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return true;
    }

    private ModuleDevEntry readModuleDevEntry(FilePath path) {
        Properties props = this.readModuleDevProperties(path);
        if (props == null) {
            return null;
        }
        String moduleName = path.getAuthority();
        String entry = props.getProperty(moduleName);
        if (entry == null && moduleName.endsWith("Test")) {
            moduleName = moduleName.substring(0, moduleName.length() - 4);
            entry = props.getProperty(moduleName);
        }
        return entry == null ? null : new ModuleDevEntry(moduleName, entry);
    }

    private Properties readModuleDevProperties(FilePath path) {
        if (this.moduleDevProperties != null) {
            return this.moduleDevProperties;
        }
        if (!this.isModuleDevSupported(path)) {
            return null;
        }
        return AccessController.doPrivileged(() -> {
            try (FileInputStream in = new FileInputStream(this.moduleDevFile);){
                Properties props = new Properties();
                props.load(in);
                Properties properties = props;
                return properties;
            }
            catch (IOException e) {
                moduleDevLog.log(Level.SEVERE, String.format("Error accessing moduledev file: %s", path), e);
                return null;
            }
        });
    }

    private boolean isModuleDevSupported(FilePath path) {
        return this.isEnabled() && this.supportedExtensions.contains(ModuleDev.getFileExtension(path));
    }

    public OrdTarget resolveLocalFile(FilePath filePath) {
        try {
            BIFile file = (BIFile)((Object)BOrd.make(filePath).get());
            OrdTarget base = BLocalHost.INSTANCE.getNavOrd().resolve();
            return new OrdTarget(base, (BObject)((Object)file));
        }
        catch (UnresolvedException e) {
            if (moduleDevLog.isLoggable(Level.FINE)) {
                moduleDevLog.fine(String.format("Unable to resolve local file %s", Objects.toString(filePath)));
            }
            return null;
        }
    }

    private static String getFileExtension(FilePath filePath) {
        String path = filePath.toString().toLowerCase();
        int index = path.lastIndexOf(46);
        return index >= 0 ? path.substring(index + 1) : path;
    }

    private boolean isLicensed() {
        if (this.licenseOk == null) {
            this.licenseOk = ModuleDev.isLicenseManagerInstalled() && ModuleDev.isModuleDevFeatureLicensed();
            if (this.licenseOk.booleanValue()) {
                this.initialize();
            }
        }
        return this.licenseOk;
    }

    private static boolean isLicenseManagerInstalled() {
        return Sys.getLicenseManager() != null || !Nre.bootEnv.isRemote();
    }

    private static boolean isModuleDevFeatureLicensed() {
        if (Sys.getLicenseManager() == null && Nre.bootEnv.isRemote()) {
            return false;
        }
        try {
            Feature feature = Sys.getLicenseManager().checkFeature("tridium", "developer");
            boolean hasModuleDev = feature.getb("moduleDev", false);
            if (!hasModuleDev) {
                moduleDevLog.warning("Module Dev mode requested but could not be enabled: missing attribute \"moduleDev\" on \"developer\" feature.");
            }
            return hasModuleDev;
        }
        catch (FeatureNotLicensedException e) {
            moduleDevLog.warning("Module Dev mode requested but could not be enabled: missing license feature: " + e.getMessage());
            return false;
        }
    }

    private void initialize() {
        if (this.initialized.getAndSet(true)) {
            return;
        }
        moduleDevLog.severe("*** Module Dev Mode Enabled: this should NOT be enabled for a release/production environment! ***");
        this.supportedExtensions = ModuleDev.getSupportedExtensions();
        RuntimeProfile[] values = RuntimeProfile.values();
        Arrays.sort(values, (v1, v2) -> v1 == RuntimeProfile.ux ? -1 : v1.compareTo((Enum)v2));
        ArrayList<String> srcList = new ArrayList<String>();
        for (RuntimeProfile profile : values) {
            String prefix = String.format("{{moduleName}}-%s/", profile.name());
            ModuleDev.addSrcLists(srcList, prefix);
        }
        ModuleDev.addSrcLists(srcList, "");
        this.moduleDevSrcList = srcList;
    }

    private static void addSrcLists(List<String> srcList, String prefix) {
        if (prioritizeBuildDirectory) {
            srcList.add("/" + prefix + "build/src");
            srcList.add("/" + prefix + "build/srcTest");
            srcList.add("/" + prefix + "src");
            srcList.add("/" + prefix + "srcTest");
        } else {
            srcList.add("/" + prefix + "src");
            srcList.add("/" + prefix + "build/src");
            srcList.add("/" + prefix + "srcTest");
            srcList.add("/" + prefix + "build/srcTest");
        }
        if (!prefix.isEmpty()) {
            srcList.add("/" + prefix.substring(0, prefix.length() - 1));
        } else {
            srcList.add("");
        }
    }

    private static String[] getModuleDevExtensionList() {
        String extensions = AccessController.doPrivileged(() -> System.getProperty(moduleDevExtensionsPropName));
        extensions = extensions == null ? defaultExtensions : "js,css,vm,htm,html,hbs,jpg,gif,png,less,map,lexicon," + extensions;
        return extensions.split(",");
    }

    private static boolean isModuleDevRequested() {
        return AccessController.doPrivileged(() -> Boolean.getBoolean(moduleDevPropName) && Sys.getStationHome() != null || Boolean.getBoolean(moduleDevWbPropName));
    }

    private static Set<String> getSupportedExtensions() {
        return Arrays.stream(ModuleDev.getModuleDevExtensionList()).map(s -> s.trim().toLowerCase()).filter(s -> !s.isEmpty()).collect(Collectors.toSet());
    }

    private static class ModuleDevEntry {
        String moduleName;
        String moduleDir;

        private ModuleDevEntry(String moduleName, String moduleDir) {
            this.moduleName = moduleName;
            this.moduleDir = moduleDir;
        }
    }
}

