/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.util;

import javax.baja.naming.BOrd;
import javax.baja.naming.SlotPath;
import javax.baja.nre.util.TextUtil;
import javax.baja.space.BComponentSpace;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BLink;
import javax.baja.sys.BRelation;
import javax.baja.sys.Context;
import javax.baja.sys.Knob;
import javax.baja.sys.RelationKnob;
import javax.baja.util.LexiconModule;

public class LinkUtil {
    private static final LexiconModule BAJA_LEX = LexiconModule.make("baja");

    public static boolean isCompositeLink(BLink link) {
        if (link == null) {
            return false;
        }
        BComplex parent = link.getParent();
        int flags = parent.getFlags(link.getPropertyInParent());
        return (flags & 0x1000) != 0;
    }

    public static boolean isCompositeKnob(Knob knob) {
        if (knob == null) {
            return false;
        }
        BLink link = knob.getLink();
        if (link != null) {
            return LinkUtil.isCompositeLink(link);
        }
        return LinkUtil.isKnobAndLinkComposite(knob);
    }

    private static boolean isKnobAndLinkComposite(Knob knob) {
        BLink[] linksToTargetSlot;
        BComponent sourceComponent = knob.getSourceComponent();
        BComponent targetComponent = knob.getTargetOrd().get(sourceComponent).asComponent();
        targetComponent.lease();
        String targetSlotName = knob.getTargetSlotName();
        for (BLink linkToTargetSlot : linksToTargetSlot = targetComponent.getLinks(targetComponent.getSlot(targetSlotName))) {
            if (sourceComponent != linkToTargetSlot.getSourceOrd().get(sourceComponent) || !knob.getSourceSlotName().equals(linkToTargetSlot.getSourceSlotName())) continue;
            int flags = targetComponent.getFlags(linkToTargetSlot.getPropertyInParent());
            return (flags & 0x1000) != 0;
        }
        return false;
    }

    public static String toDisplay(BRelation relation) {
        try {
            if (relation instanceof BLink) {
                return LinkUtil.linkText(LinkUtil.toDisplaySource(relation), LinkUtil.toDisplayTarget(relation), null);
            }
            return LinkUtil.relationText(LinkUtil.toDisplaySource(relation), relation.getRelationId(), LinkUtil.toDisplayTarget(relation), null);
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            return "err";
        }
    }

    public static String toDisplaySource(BRelation relation) {
        try {
            BComponentSpace space = LinkUtil.toSpace(relation);
            if (relation instanceof BLink) {
                BLink link = (BLink)relation;
                return LinkUtil.toPath(space, link.getSourceOrd()) + "." + LinkUtil.toSlot(link.getSourceSlotName());
            }
            return LinkUtil.toPath(relation.getRelationComponent());
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            return "err";
        }
    }

    public static String toDisplayTarget(BRelation relation) {
        try {
            if (relation instanceof BLink) {
                BLink link = (BLink)relation;
                return LinkUtil.toPath(link.getTargetComponent()) + "." + LinkUtil.toSlot(link.getTargetSlotName());
            }
            BComponentSpace space = LinkUtil.toSpace(relation);
            return LinkUtil.toPath(space, relation.getEndpointOrd());
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            return "err";
        }
    }

    public static String toDisplay(Knob knob) {
        try {
            return LinkUtil.linkText(LinkUtil.toDisplaySource(knob), LinkUtil.toDisplayTarget(knob), null);
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            return "err";
        }
    }

    public static String toDisplaySource(Knob knob) {
        try {
            return LinkUtil.toPath(knob.getSourceComponent()) + "." + LinkUtil.toSlot(knob.getSourceSlotName());
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            return "err";
        }
    }

    public static String toDisplayTarget(Knob knob) {
        try {
            BComponentSpace space = LinkUtil.toSpace(knob);
            return LinkUtil.toPath(space, knob.getTargetOrd()) + "." + LinkUtil.toSlot(knob.getTargetSlotName());
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            return "err";
        }
    }

    public static String toDisplay(RelationKnob knob) {
        try {
            return LinkUtil.relationText(LinkUtil.toDisplaySource(knob), knob.getRelationId(), LinkUtil.toDisplayTarget(knob), null);
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            return "err";
        }
    }

    public static String toDisplayTarget(RelationKnob knob) {
        try {
            return LinkUtil.toPath(knob.getEndpointComponent());
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            return "err";
        }
    }

    public static String toDisplaySource(RelationKnob knob) {
        try {
            BComponentSpace space = LinkUtil.toSpace(knob);
            return LinkUtil.toPath(space, knob.getRelationOrd());
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            return "err";
        }
    }

    public static BComponentSpace toSpace(BRelation link) {
        return link.getRelationComponent().getComponentSpace();
    }

    public static BComponentSpace toSpace(Knob knob) {
        return knob.getSourceComponent().getComponentSpace();
    }

    public static BComponentSpace toSpace(RelationKnob knob) {
        return knob.getEndpointComponent().getComponentSpace();
    }

    public static String toPath(BComponent component) {
        return LinkUtil.toPath(component.getSlotPath());
    }

    public static String toPath(BComponentSpace space, BOrd ord) {
        String ordStr = ord.toString();
        if (!ordStr.startsWith("h:")) {
            return ordStr;
        }
        String handle = ordStr.substring(2);
        SlotPath path = space.handleToSlotPath(handle);
        if (path == null) {
            return ordStr;
        }
        return LinkUtil.toPath(path);
    }

    public static String toPath(SlotPath path) {
        return path.toDisplayString();
    }

    public static String toSlot(String name) {
        return TextUtil.toFriendly((String)name);
    }

    public static String linkText(String sourceText, String targetText, Context cx) {
        return BAJA_LEX.getText("linkcheck.linkDirection", cx, sourceText, targetText);
    }

    public static String relationText(String sourceText, String relationId, String targetText, Context cx) {
        return BAJA_LEX.getText("relationcheck.relationDirection", cx, sourceText, relationId, targetText);
    }
}

