/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.util;

import java.util.Objects;
import java.util.function.Consumer;
import javax.baja.job.BJob;
import javax.baja.job.BJobLogSequence;
import javax.baja.job.JobLogItem;
import javax.baja.naming.BOrd;
import javax.baja.space.BComponentSpace;
import javax.baja.sys.BComponent;
import javax.baja.sys.BLong;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.Subscriber;

public class JobProgressMonitor {
    private final BOrd jobOrd;
    private final BComponent base;
    private final Consumer<JobLogItem> jobLogItemConsumer;
    private static final int JOB_CHECK_SLEEP_TIME = 20;
    private static final int JOB_LOG_CHECK_TIME = 1000;

    public JobProgressMonitor(BOrd jobOrd, BComponent base, Consumer<JobLogItem> jobLogItemConsumer) {
        this.jobOrd = jobOrd;
        this.base = base;
        this.jobLogItemConsumer = jobLogItemConsumer;
    }

    public BJob waitAndReadLog() throws InterruptedException {
        Subscriber subscriber = Subscriber.make(event -> {});
        try {
            BComponentSpace componentSpace = this.base.getComponentSpace();
            if (componentSpace == null) {
                throw new IllegalStateException();
            }
            componentSpace.sync();
            BJob job = (BJob)this.jobOrd.relativizeToSession().get(this.base);
            subscriber.subscribe(job);
            int jobLogCheckTime = 0;
            long lastJobLogSequenceNumber = -1L;
            while (!job.getJobState().isComplete()) {
                Thread.sleep(20L);
                if ((jobLogCheckTime += 20) < 1000) continue;
                lastJobLogSequenceNumber = this.readJobLog(job, lastJobLogSequenceNumber);
                jobLogCheckTime = 0;
            }
            this.readJobLog(job, lastJobLogSequenceNumber);
            BJob bJob = job;
            return bJob;
        }
        catch (InterruptedException | RuntimeException error) {
            throw error;
        }
        catch (Exception error) {
            throw new BajaRuntimeException(error);
        }
        finally {
            subscriber.unsubscribeAll();
        }
    }

    private long readJobLog(BJob job, long lastJobLogSequenceNumber) throws Exception {
        BJobLogSequence jobLogSequence = job.readLogFrom(BLong.make(lastJobLogSequenceNumber + 1L));
        if (jobLogSequence.getLastSequenceNumber() > lastJobLogSequenceNumber) {
            lastJobLogSequenceNumber = jobLogSequence.getLastSequenceNumber();
        }
        for (JobLogItem item : jobLogSequence.getLogItems()) {
            this.jobLogItemConsumer.accept(item);
        }
        return lastJobLogSequenceNumber;
    }

    public static Consumer<JobLogItem> makeJobLogItemMessageConsumer(Consumer<String> messageConsumer, Context cx) {
        return item -> {
            messageConsumer.accept(item.getMessage(cx));
            String details = Objects.toString(item.getDetails(cx), "");
            if (!details.isEmpty()) {
                messageConsumer.accept(details);
            }
        };
    }
}

