/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.util;

import java.util.Locale;
import javax.baja.nre.util.TextUtil;
import org.owasp.encoder.Encode;

public final class HtmlUtils {
    private HtmlUtils() {
    }

    public static String getLimitedHtml(String str) {
        if (str == null || str.isEmpty()) {
            return str;
        }
        str = Encode.forHtml((String)str);
        str = HtmlUtils.unescapeElement(str, "b");
        str = HtmlUtils.unescapeElement(str, "code");
        str = HtmlUtils.unescapeElement(str, "i");
        str = HtmlUtils.unescapeElement(str, "li");
        str = HtmlUtils.unescapeElement(str, "p");
        str = HtmlUtils.unescapeElement(str, "ul");
        return str;
    }

    private static String unescapeElement(String str, String elementName) {
        String startingElement = '<' + elementName + '>';
        String endingElement = "</" + elementName + '>';
        str = TextUtil.replace((String)str, (String)Encode.forHtml((String)startingElement), (String)startingElement);
        str = TextUtil.replace((String)str, (String)Encode.forHtml((String)endingElement), (String)endingElement);
        startingElement = '<' + elementName.toUpperCase(Locale.ENGLISH) + '>';
        endingElement = "</" + elementName.toUpperCase(Locale.ENGLISH) + '>';
        str = TextUtil.replace((String)str, (String)Encode.forHtml((String)startingElement), (String)startingElement);
        str = TextUtil.replace((String)str, (String)Encode.forHtml((String)endingElement), (String)endingElement);
        return str;
    }
}

