/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.util;

import com.tridium.sys.Nre;
import com.tridium.sys.engine.EngineManager;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BajaRuntimeException;

public final class EngineCycleUtil {
    private static final String ENGINE_THREAD_NAME = "Nre:Engine";
    private static final Logger LOG = Logger.getLogger("baja");
    private static final String MAX_WAIT_PROPERTY = "com.tridium.engineUtil.maxWaitMillis";
    private static final BRelTime DEFAULT_MAX_WAIT = BRelTime.make(System.getProperty("com.tridium.engineUtil.maxWaitMillis") != null ? (long)Integer.parseInt(System.getProperty("com.tridium.engineUtil.maxWaitMillis")) : 1000L);

    private EngineCycleUtil() {
    }

    public static void runOnFutureEngineCycle(Runnable task) throws Exception {
        EngineCycleUtil.runOnFutureEngineCycle(task, 1, DEFAULT_MAX_WAIT);
    }

    public static void runOnFutureEngineCycle(Runnable task, int minEngineCyclesToWait, BRelTime maxWait) throws Exception {
        EngineCycleUtil.callOnFutureEngineCycle(() -> {
            task.run();
            return null;
        }, minEngineCyclesToWait, maxWait);
    }

    public static <T> T callOnFutureEngineCycle(Callable<T> task) throws Exception {
        return EngineCycleUtil.callOnFutureEngineCycle(task, 1, DEFAULT_MAX_WAIT);
    }

    public static <T> T callOnFutureEngineCycle(Callable<T> task, int minEngineCyclesToWait, BRelTime maxWait) throws Exception {
        EngineCycleUtil.waitForEngineCycles(minEngineCyclesToWait, maxWait);
        return task.call();
    }

    public static void waitForEngineCycles(int minEngineCyclesToWait, BRelTime maxWait) {
        if (ENGINE_THREAD_NAME.equals(Thread.currentThread().getName())) {
            BajaRuntimeException bre = new BajaRuntimeException("waitForEngine Cycles Accessed from Nre:Engine");
            LOG.log(Level.WARNING, "waitForEngineCycles called from Nre:Engine thread", bre);
            throw bre;
        }
        int engineCyclesBefore = EngineCycleUtil.getCurrentCycles();
        BAbsTime start = BAbsTime.now();
        while (EngineCycleUtil.getCurrentCycles() - engineCyclesBefore < minEngineCyclesToWait && BAbsTime.now().isBefore(start.add(maxWait))) {
            try {
                Thread.sleep(EngineManager.engineSleepPeriod);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new BajaRuntimeException("Engine cycle wait interrupted", e);
            }
        }
    }

    public static int getCurrentCycles() {
        return Nre.getEngineManager().getCycles();
    }
}

