/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.util;

import java.util.Stack;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.CursorException;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Topic;
import javax.baja.sys.Type;

public class ComponentTreeCursor
implements SlotCursor<Slot> {
    public static final int ALL = Integer.MAX_VALUE;
    private boolean init = true;
    private boolean atRoot = false;
    private BComponent root;
    private int depth;
    private Type[] leafTypes;
    private SlotCursor<Property> current;
    private int currentDepth = 0;
    private Stack<SlotCursor<Property>> nodeStack;
    private Context context;
    private volatile boolean closed;

    public ComponentTreeCursor(BComponent root, Context context) {
        this(root, Integer.MAX_VALUE, context);
    }

    public ComponentTreeCursor(BComponent root, int depth, Context context) {
        this.root = root;
        this.depth = depth;
        this.context = context;
    }

    public ComponentTreeCursor(BComponent root, Type leafType, Context context) {
        this(root, new Type[]{leafType}, context);
    }

    public ComponentTreeCursor(BComponent root, Type[] leafTypes, Context context) {
        this.root = root;
        this.depth = Integer.MAX_VALUE;
        this.leafTypes = leafTypes;
        this.context = context;
    }

    @Override
    public void close() {
        this.closed = true;
    }

    @Override
    public Context getContext() {
        return this.context;
    }

    public BComponent root() {
        return this.root;
    }

    public void reset() {
        this.init = true;
        this.atRoot = false;
        this.current = null;
        this.currentDepth = 0;
        this.nodeStack = null;
        this.closed = false;
    }

    @Override
    public BObject target() {
        return this.current.target();
    }

    public boolean isLeafType(Type type) {
        if (this.leafTypes == null) {
            return false;
        }
        for (int i = 0; i < this.leafTypes.length; ++i) {
            if (!type.is(this.leafTypes[i])) continue;
            return true;
        }
        return false;
    }

    public boolean isLeafType(BObject o) {
        if (this.leafTypes == null) {
            return false;
        }
        return this.isLeafType(o.getType());
    }

    @Override
    public boolean next() {
        boolean goInto;
        if (this.root == null || this.closed) {
            return false;
        }
        if (this.init) {
            this.atRoot = true;
            this.init = false;
            return true;
        }
        if (this.atRoot && this.depth == 0) {
            return false;
        }
        if (this.atRoot) {
            this.atRoot = false;
            this.current = this.root.getProperties();
            return this.current.nextComponent();
        }
        BComponent newRoot = null;
        SlotCursor<Property> newRootChildren = null;
        boolean hasChildren = false;
        boolean bl = goInto = this.currentDepth + 1 < this.depth && !this.isLeafType(this.current.target());
        if (goInto && (newRootChildren = (newRoot = (BComponent)this.current.get()).getProperties()).nextComponent()) {
            hasChildren = true;
        }
        if (hasChildren) {
            ++this.currentDepth;
            if (this.nodeStack == null) {
                this.nodeStack = new Stack();
            }
            this.nodeStack.push(this.current);
            this.current = newRootChildren;
            return true;
        }
        while (!this.current.nextComponent()) {
            if (this.nodeStack == null || this.nodeStack.empty()) {
                return false;
            }
            this.current = this.nodeStack.pop();
            --this.currentDepth;
        }
        return true;
    }

    @Override
    public boolean nextObject() {
        return this.nextComponent();
    }

    @Override
    public boolean nextComponent() {
        return this.next();
    }

    @Override
    public boolean next(Class<?> cls) {
        while (this.next()) {
            BValue o = this.get();
            if (!cls.isInstance(o)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Slot slot() {
        return this.current.slot();
    }

    @Override
    public Property property() {
        return this.current.property();
    }

    @Override
    public int getTypeAccess() {
        return this.current.getTypeAccess();
    }

    @Override
    public BValue get() {
        if (this.closed) {
            throw new CursorException("cursor was closed");
        }
        if (this.atRoot) {
            return this.root;
        }
        return this.current.get();
    }

    @Override
    public boolean getBoolean() {
        throw new ClassCastException();
    }

    @Override
    public int getInt() {
        throw new ClassCastException();
    }

    @Override
    public long getLong() {
        throw new ClassCastException();
    }

    @Override
    public float getFloat() {
        throw new ClassCastException();
    }

    @Override
    public double getDouble() {
        throw new ClassCastException();
    }

    @Override
    public String getString() {
        throw new ClassCastException();
    }

    @Override
    public Action action() {
        throw new CursorException("not action");
    }

    @Override
    public Topic topic() {
        throw new CursorException("not topic");
    }
}

