/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.util;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.baja.naming.SlotPath;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.IllegalChildException;
import javax.baja.sys.Property;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BIRestrictedComponent;

public class CompUtil {
    public static synchronized <T> T[] getDescendants(BComponent root, Class<T> cls) {
        ArrayList a = new ArrayList();
        CompUtil.getDescendants(a, root, cls);
        Object[] arrayLocal = (Object[])Array.newInstance(cls, a.size());
        return a.toArray(arrayLocal);
    }

    public static boolean hasDescendant(BComponent root, String typespec) {
        Type type = null;
        try {
            type = Sys.getType(typespec);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return type != null && CompUtil.hasDescendant((BComplex)root, type);
    }

    public static synchronized boolean hasDescendant(BComponent root, Type type) {
        return CompUtil.hasDescendant((BComplex)root, type);
    }

    public static Optional<SlotPath> slotPathFromAncestor(BComplex ancestor, BComplex descendant) {
        BComplex c;
        if (ancestor == null) {
            throw new IllegalArgumentException("ancestor required");
        }
        if (descendant == null) {
            throw new IllegalArgumentException("descendant required");
        }
        ArrayList<Property> properties = new ArrayList<Property>();
        for (c = descendant; c != null && c != ancestor; c = c.getParent()) {
            properties.add(c.getPropertyInParent());
        }
        if (c != ancestor) {
            return Optional.empty();
        }
        CharSequence[] propNames = new String[properties.size()];
        int len = properties.size();
        for (int i = 0; i < len; ++i) {
            propNames[len - i - 1] = ((Property)properties.get(i)).getName();
        }
        return Optional.of(new SlotPath(String.join((CharSequence)"/", propNames)));
    }

    public static <T extends BComplex> Optional<T> closestAncestor(BComplex comp, Class<T> clazz) {
        BComplex c;
        if (clazz == null) {
            throw new IllegalArgumentException("type required");
        }
        for (c = comp; c != null && !clazz.isAssignableFrom(c.getClass()); c = c.getParent()) {
        }
        return Optional.ofNullable(c);
    }

    private static <T> void getDescendants(List<T> a, BComplex c, Class<?> cls) {
        SlotCursor<Property> sc = c.getProperties();
        while (sc.next()) {
            BValue o = sc.get();
            if (cls.isInstance(o)) {
                BValue localObject = o;
                a.add(localObject);
            }
            if (!(o instanceof BComplex)) continue;
            CompUtil.getDescendants(a, (BComplex)o, cls);
        }
    }

    public static Property setOrAdd(BComponent c, String name, BValue value, int flags, BFacets facets, Context context) {
        Property p = c.getProperty(name);
        if (p != null) {
            c.set(p, value, context);
        } else {
            p = c.add(name, value, flags, facets, context);
        }
        return p;
    }

    public static Property setOrAdd(BComponent c, String name, BValue value, Context context) {
        return CompUtil.setOrAdd(c, name, value, 0, null, context);
    }

    public static void removeIfPresent(BComponent parent, String slotName) {
        Property prop = parent.getProperty(slotName);
        if (prop != null) {
            parent.remove(prop);
        }
    }

    public static void copyProperties(BComponent dest, BComponent src, Context context) {
        Property[] props = src.getPropertiesArray();
        for (int i = 0; i < props.length; ++i) {
            String propName = props[i].getName();
            CompUtil.setOrAdd(dest, propName, src.get(propName).newCopy(), context);
        }
    }

    public static void checkForDuplicateRestrictedComponent(SlotCursor<?> cursor, BComponent parent, BIRestrictedComponent child, boolean allowNonExactTypes, String lexiconModule, String errorLexicon) {
        while (cursor.next()) {
            BValue value = cursor.get();
            if (value == child || !value.getType().is(BIRestrictedComponent.TYPE) || !(allowNonExactTypes ? child.getType().equals(value.getType()) : value.getType().is(child.getType()) || child.getType().is(value.getType()))) continue;
            throw new IllegalChildException(lexiconModule, errorLexicon, new Object[]{parent.getType(), child.getType()});
        }
    }

    private static synchronized boolean hasDescendant(BComplex c, Type type) {
        Objects.requireNonNull(c);
        Objects.requireNonNull(type);
        boolean found = false;
        SlotCursor<Property> sc = c.getProperties();
        while (sc.next() && !found) {
            BValue o = sc.get();
            found = ((BObject)o).getType().is(type);
            if (!(o instanceof BComplex) || found) continue;
            found = CompUtil.hasDescendant((BComplex)o, type);
        }
        return found;
    }
}

