/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.util;

import com.tridium.util.StringTable;
import javax.baja.nre.util.TextUtil;

public class CaseInsensitiveStringTable
extends StringTable {
    String[] origKeys = EMPTY;

    public CaseInsensitiveStringTable() {
    }

    public CaseInsensitiveStringTable(int capacity) {
        this.keys = new String[capacity];
        this.origKeys = new String[capacity];
        this.values = new Object[capacity];
    }

    public CaseInsensitiveStringTable(String[] keys, Object[] values) {
        this.init(keys, values);
    }

    @Override
    public synchronized void init(String[] keys, Object[] values) {
        if (keys.length != values.length) {
            throw new IllegalArgumentException();
        }
        int n = this.count = keys.length;
        this.keys = new String[n];
        String[] k = this.keys;
        this.origKeys = new String[n];
        String[] o = this.origKeys;
        this.values = new Object[n];
        Object[] v = this.values;
        System.arraycopy(keys, 0, this.keys, 0, n);
        System.arraycopy(keys, 0, this.origKeys, 0, n);
        System.arraycopy(values, 0, this.values, 0, n);
        for (int i = 0; i < n; ++i) {
            k[i] = TextUtil.toLowerCase((String)k[i]);
        }
        for (int incr = n / 2; incr >= 1; incr /= 2) {
            for (int i = incr; i < n; ++i) {
                String tempKey = k[i];
                String tempOrig = o[i];
                Object tempValue = v[i];
                for (int j = i; j >= incr && tempKey.compareTo(k[j - incr]) < 0; j -= incr) {
                    k[j] = k[j - incr];
                    o[j] = o[j - incr];
                    v[j] = v[j - incr];
                }
                k[j] = tempKey;
                o[j] = tempOrig;
                v[j] = tempValue;
            }
        }
    }

    @Override
    public synchronized Object get(String key) {
        key = TextUtil.toLowerCase((String)key);
        String[] k = this.keys;
        int lo = -1;
        int hi = this.count;
        while (hi - lo > 1) {
            int i = (hi + lo) / 2;
            int cmp = key.compareTo(k[i]);
            if (cmp < 0) {
                hi = i;
                continue;
            }
            if (cmp > 0) {
                lo = i;
                continue;
            }
            return this.values[i];
        }
        return null;
    }

    @Override
    public synchronized Object put(String key, Object value) {
        String origKey = key;
        key = TextUtil.toLowerCase((String)key);
        if (this.keys.length >= this.count) {
            this.ensureCapacity(Math.max(8, this.count * 2));
        }
        String[] k = this.keys;
        if (this.count == 0) {
            Object old = this.values[0];
            k[0] = key;
            this.origKeys[0] = origKey;
            this.values[0] = value;
            ++this.count;
            return old;
        }
        if (this.count == 1) {
            int c = key.compareTo(k[0]);
            if (c == 0) {
                Object old = this.values[0];
                this.origKeys[0] = origKey;
                this.values[0] = value;
                return old;
            }
            if (c < 0) {
                k[1] = k[0];
                this.origKeys[1] = this.origKeys[0];
                this.values[1] = this.values[0];
                k[0] = key;
                this.origKeys[0] = origKey;
                this.values[0] = value;
                ++this.count;
            } else {
                k[1] = key;
                this.origKeys[1] = origKey;
                this.values[1] = value;
                ++this.count;
            }
            return null;
        }
        int first = 0;
        int last = this.count - 1;
        int i = (last - first) / 2;
        while (first <= last) {
            int c = key.compareTo(k[i]);
            if (c == 0) {
                Object old = this.values[i];
                this.origKeys[i] = origKey;
                this.values[i] = value;
                return old;
            }
            if (c < 0) {
                c = key.compareTo(k[first]);
                if (c == 0) {
                    Object old = this.values[first];
                    this.origKeys[first] = origKey;
                    this.values[first] = value;
                    return old;
                }
                if (c < 0) {
                    i = first;
                    break;
                }
                last = i - 1;
            } else {
                c = key.compareTo(k[last]);
                if (c == 0) {
                    Object old = this.values[last];
                    this.origKeys[last] = origKey;
                    this.values[last] = value;
                    return old;
                }
                if (c > 0) {
                    i = last + 1;
                    break;
                }
                first = i + 1;
            }
            i = first + (last - first) / 2;
        }
        System.arraycopy(k, i, k, i + 1, this.count - i);
        k[i] = key;
        System.arraycopy(this.origKeys, i, this.origKeys, i + 1, this.count - i);
        this.origKeys[i] = origKey;
        System.arraycopy(this.values, i, this.values, i + 1, this.count - i);
        this.values[i] = value;
        ++this.count;
        return null;
    }

    @Override
    public synchronized Object remove(String key) {
        key = TextUtil.toLowerCase((String)key);
        String[] k = this.keys;
        int lo = -1;
        int hi = this.count;
        while (hi - lo > 1) {
            int i = (hi + lo) / 2;
            int cmp = key.compareTo(k[i]);
            if (cmp < 0) {
                hi = i;
                continue;
            }
            if (cmp > 0) {
                lo = i;
                continue;
            }
            Object old = this.values[i];
            System.arraycopy(this.keys, i + 1, this.keys, i, this.count - i - 1);
            System.arraycopy(this.origKeys, i + 1, this.origKeys, i, this.count - i - 1);
            System.arraycopy(this.values, i + 1, this.values, i, this.count - i - 1);
            this.keys[this.count - 1] = null;
            this.origKeys[this.count - 1] = null;
            this.values[this.count - 1] = null;
            --this.count;
            return old;
        }
        return null;
    }

    @Override
    public synchronized String[] keyArray() {
        String[] copy = new String[this.count];
        System.arraycopy(this.origKeys, 0, copy, 0, this.count);
        return copy;
    }

    public synchronized String[] normalizedKeyArray() {
        String[] copy = new String[this.count];
        System.arraycopy(this.keys, 0, copy, 0, this.count);
        return copy;
    }

    @Override
    public synchronized void ensureCapacity(int capacity) {
        if (this.keys.length < capacity) {
            String[] tempKeys = new String[capacity];
            String[] tempOrigKeys = new String[capacity];
            Object[] tempValues = new Object[capacity];
            System.arraycopy(this.keys, 0, tempKeys, 0, this.count);
            System.arraycopy(this.origKeys, 0, tempOrigKeys, 0, this.count);
            System.arraycopy(this.values, 0, tempValues, 0, this.count);
            this.keys = tempKeys;
            this.origKeys = tempOrigKeys;
            this.values = tempValues;
        }
    }

    @Override
    public synchronized void clear() {
        this.keys = EMPTY;
        this.origKeys = EMPTY;
        this.values = EMPTY;
        this.count = 0;
    }

    @Override
    public synchronized void dump() {
        for (int i = 0; i < this.count; ++i) {
            System.out.println("  " + this.keys[i] + " (" + this.origKeys[i] + ") = " + this.values[i]);
        }
    }
}

