/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.util;

import java.util.Optional;
import java.util.StringJoiner;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.naming.BOrd;
import javax.baja.naming.BOrdScheme;
import javax.baja.naming.OrdQuery;
import javax.baja.naming.OrdTarget;
import javax.baja.naming.ViewQuery;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BInterface;
import javax.baja.sys.Context;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.virtual.BVirtualComponent;

@NiagaraType
public interface BISubstitutableOrdScheme
extends BInterface {
    @Generated
    public static final Type TYPE = Sys.loadType(BISubstitutableOrdScheme.class);
    public static final String SUBSTITUTE_NAV_ORD_FACET_KEY = "substituteNavOrd";
    public static final BFacets SUBSTITUTE_NAV_ORD_FACET = BFacets.make("substituteNavOrd", true);

    default public BOrd convertToSubstituteOrd(BOrd ord, OrdTarget result, Context cx) {
        return BISubstitutableOrdScheme.convertToSubstituteComponentOrd(ord, result, cx);
    }

    public static BOrd convertToSubstituteComponentOrd(BOrd ord, OrdTarget result, Context cx) {
        try {
            BComponent component;
            BComponent bComponent = component = result != null ? result.getComponent() : null;
            if (component != null) {
                ViewQuery viewQuery;
                Slot slot;
                BOrd substituteOrd = component instanceof BVirtualComponent || cx != null && BBoolean.TRUE == cx.getFacet(SUBSTITUTE_NAV_ORD_FACET_KEY) ? component.getNavOrd() : component.getAbsoluteOrd();
                if (substituteOrd == null) {
                    return ord;
                }
                Slot[] slots = result.getPropertyPathInComponent();
                if (slots == null && (slot = result.getSlotInComponent()) != null) {
                    slots = new Slot[]{slot};
                }
                boolean substituteOrdNeedsNormalize = false;
                if (slots != null && slots.length > 0) {
                    StringJoiner sj = new StringJoiner("/", "slot:", "");
                    for (Slot slot2 : slots) {
                        sj.add(slot2.getName());
                    }
                    substituteOrd = BOrd.make(substituteOrd, sj.toString());
                    substituteOrdNeedsNormalize = true;
                }
                if ((viewQuery = result.getViewQuery()) != null) {
                    substituteOrd = BOrd.make(substituteOrd, viewQuery);
                }
                BOrd originalNormalizedOrd = ord.normalize();
                String originalOrdStr = originalNormalizedOrd.encodeToString();
                if (originalNormalizedOrd.relativizeToHost().encodeToString().equals(originalOrdStr)) {
                    substituteOrd = substituteOrd.relativizeToHost();
                    substituteOrdNeedsNormalize = false;
                }
                if (originalNormalizedOrd.relativizeToSession().encodeToString().equals(originalOrdStr)) {
                    substituteOrd = substituteOrd.relativizeToSession();
                    substituteOrdNeedsNormalize = false;
                }
                if (substituteOrdNeedsNormalize) {
                    substituteOrd = substituteOrd.normalize();
                }
                return substituteOrd;
            }
        }
        catch (Exception e) {
            Logger.getLogger("ord.substitution").log(Level.WARNING, "Unexpected error while computing substitute ORD for " + ord, e);
        }
        return ord;
    }

    public static Optional<BISubstitutableOrdScheme> findSubstitutableOrdScheme(BOrd ord) {
        block4: {
            try {
                if (ord != null && !ord.isNull()) {
                    OrdQuery[] queries;
                    for (OrdQuery ordQuery : queries = ord.parse()) {
                        Optional<BOrdScheme> ordScheme = BOrdScheme.find(ordQuery.getScheme());
                        if (!(ordScheme.orElse(null) instanceof BISubstitutableOrdScheme)) continue;
                        return ordScheme.map(scheme -> (BISubstitutableOrdScheme)((Object)scheme));
                    }
                }
            }
            catch (Exception e) {
                Logger logger = Logger.getLogger("ord.substitution");
                if (!logger.isLoggable(Level.FINE)) break block4;
                logger.log(Level.FINE, "Unexpected error while checking for substitutable ORD schemes in " + ord, e);
            }
        }
        return Optional.empty();
    }
}

