/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.util;

import java.util.ListIterator;
import java.util.NoSuchElementException;

public class ArrayIterator
implements ListIterator<Object> {
    private Object[] array;
    private int first = 0;
    private int size = 0;
    private int carat = 0;

    public ArrayIterator(Object[] objects) {
        this(objects, 0, objects.length);
    }

    public ArrayIterator(Object[] objects, int first, int size) {
        if (objects == null) {
            throw new NullPointerException();
        }
        if (first < 0 || size > objects.length) {
            throw new IllegalArgumentException();
        }
        this.array = objects;
        this.first = first;
        this.size = size;
        this.carat = first;
    }

    @Override
    public void add(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean hasNext() {
        return this.carat < this.first + this.size;
    }

    @Override
    public boolean hasPrevious() {
        return this.carat > this.first;
    }

    @Override
    public Object next() throws NoSuchElementException {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        return this.array[this.carat++];
    }

    @Override
    public int nextIndex() {
        return this.carat - this.first;
    }

    @Override
    public Object previous() throws NoSuchElementException {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException();
        }
        return this.array[--this.carat];
    }

    @Override
    public int previousIndex() {
        if (this.carat == this.first) {
            return -1;
        }
        return Math.min(this.first + this.size - 1, this.carat - this.first - 1);
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void set(Object o) {
        throw new UnsupportedOperationException();
    }
}

