/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.sys.transfer;

import com.tridium.sys.transfer.TransferResult;
import com.tridium.sys.transfer.TransferStrategy;
import javax.baja.naming.BHost;
import javax.baja.nav.BINavContainer;
import javax.baja.nav.BINavNode;
import javax.baja.nav.BNavContainer;
import javax.baja.nav.BNavFolder;
import javax.baja.sys.BObject;
import javax.baja.util.LexiconModule;

public class ToNavFolder
extends TransferStrategy {
    BINavNode[] sources;
    BINavNode targetParent;
    private static final LexiconModule LEX = LexiconModule.make("baja");

    @Override
    public TransferResult transfer() throws Exception {
        this.init();
        this.move();
        return null;
    }

    protected void init() throws Exception {
        this.targetParent = (BNavContainer)this.target;
        BObject[] values = this.mark.getValues();
        this.sources = new BINavNode[values.length];
        BINavNode[] existingChildren = this.targetParent.getNavChildren();
        for (int i = 0; i < values.length; ++i) {
            BINavNode src = (BINavNode)((Object)values[i]);
            if (src.getNavParent() == null) {
                throw new IllegalArgumentException(LEX.getText("ToNavFolder.error.noParent", this.getContext(), src.getNavName()));
            }
            if (!(src.getNavParent() instanceof BINavContainer)) {
                throw new IllegalArgumentException(LEX.getText("ToNavFolder.error.sourceRequiresNavContainerParent", this.getContext(), src.getNavOrd()));
            }
            if (!(src instanceof BHost) && !(src instanceof BNavFolder)) {
                throw new IllegalArgumentException(LEX.getText("ToNavFolder.error.unexpectedType", this.getContext(), src.getType()));
            }
            this.sources[i] = src;
            if (src == this.targetParent) {
                throw new IllegalArgumentException(LEX.getText("ToNavFolder.error.sameAsSource", this.getContext(), this.targetParent.getNavOrd()));
            }
            for (BINavNode existing : existingChildren) {
                if (!existing.getNavName().equals(src.getNavName())) continue;
                throw new IllegalArgumentException(LEX.getText("ToNavFolder.error.duplicateName", this.getContext(), src.getNavName()));
            }
        }
    }

    protected void move() throws Exception {
        for (BINavNode source : this.sources) {
            this.move(source, this.targetParent);
        }
    }

    private void move(BINavNode src, BINavNode destFolder) {
        if (src instanceof BNavFolder) {
            this.moveFolder((BNavFolder)src, destFolder);
        } else if (src instanceof BHost) {
            this.moveHost((BHost)src, destFolder);
        }
    }

    private void moveFolder(BNavFolder srcDir, BINavNode destDir) {
        BINavContainer container = (BINavContainer)((Object)destDir);
        ((BINavContainer)((Object)srcDir.getNavParent())).removeNavChild(srcDir);
        container.addNavChild(srcDir);
    }

    private void moveHost(BHost src, BINavNode destDir) {
        BINavContainer container = (BINavContainer)((Object)destDir);
        ((BINavContainer)((Object)src.getNavParent())).removeNavChild(src);
        container.addNavChild(src);
    }
}

