/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.sys.transfer;

import com.tridium.sys.transfer.TransferResult;
import com.tridium.sys.transfer.TransferStrategy;
import java.util.logging.Logger;
import javax.baja.file.BDirectory;
import javax.baja.file.BIDeployable;
import javax.baja.file.FilePath;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdQuery;
import javax.baja.naming.UnresolvedException;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.util.Lexicon;

public class DeployToComp
extends TransferStrategy {
    private static Lexicon lex = Lexicon.make("template");
    public static Context NoPostConfigEdit = new BasicContext();
    public static Context NoPostLink = new BasicContext();
    Logger deployLog = Logger.getLogger("template.deploy");
    BIDeployable deployable;
    BIDeployable.Step[] steps;

    public boolean getSteps(Object owner) {
        if (!this.target.isComponent()) {
            return false;
        }
        this.deployable = (BIDeployable)((Object)this.mark.getValue(0));
        if (this.deployable.getFileName().endsWith(".ntpl")) {
            if (this.params == null) {
                this.params = new BComponent();
                this.params.add("exact", BBoolean.TRUE);
            } else {
                BValue exact = this.params.get("exact");
                if (exact == null) {
                    this.params.add("exact", BBoolean.TRUE);
                } else {
                    this.params.set("exact", (BValue)BBoolean.TRUE);
                }
            }
        }
        if (!this.deployable.isDeployable(this.target.asComponent())) {
            return false;
        }
        try {
            BIDeployable.Step[] steps = this.deployable.getSteps(owner, this.target.asComponent(), this.mark.getNames()[0]);
            if (steps == null || steps.length == 0) {
                return false;
            }
            this.steps = steps;
        }
        catch (Throwable e) {
            return false;
        }
        return true;
    }

    @Override
    public TransferResult transfer() throws Exception {
        if (this.steps == null) {
            this.getSteps(null);
        }
        if (this.steps == null) {
            return null;
        }
        String[] names = this.mark.getNames();
        TransferResult[][] tres = new TransferResult[names.length][this.steps.length];
        int totalFiles = this.steps.length + names.length - 1;
        int transferCount = 1;
        for (int j = 0; j < names.length; ++j) {
            int maxSteps = j == 0 ? this.steps.length : 1;
            for (int i = 0; i < maxSteps; ++i) {
                this.updateStatus(lex.getText("deploy.transfer", transferCount++, totalFiles, this.steps[i].mark.getName(0)));
                BObject tgt = this.getTarget(this.steps[i].destination, this.target);
                long ticks = Clock.ticks();
                tres[j][i] = this.steps[i].mark.copyTo(tgt, this.params, this.context);
                long copyTime = Clock.ticks() - ticks;
                this.deployLog.fine("Deploy " + this.steps[i].mark.getName(0) + " took (ms) " + copyTime);
            }
        }
        for (int i = 0; i < names.length; ++i) {
            names[i] = tres[i][0].getInsertNames()[0];
        }
        TransferResult transferResult = this.makeResult((BComponent)this.target, names);
        this.deployable.postDeploy(new TransferResult[]{transferResult}, this, this.context);
        return transferResult;
    }

    public TransferResult makeResult(BComponent target, String[] insertNames) {
        return new DeployTransferResult(target, insertNames){

            @Override
            public void undo() {
                throw new UnsupportedOperationException();
            }
        };
    }

    private BObject getTarget(BOrd ord, BObject target) throws Exception {
        BObject obj;
        try {
            obj = ord.resolve(target).get();
        }
        catch (UnresolvedException e) {
            OrdQuery[] oqs = ord.parse();
            for (int i = 0; i < oqs.length; ++i) {
                if (!(oqs[i] instanceof FilePath)) continue;
                FilePath fp = (FilePath)oqs[i];
                BDirectory rootDir = (BDirectory)BOrd.make("file:^").resolve(target).get();
                rootDir.getFileSpace().makeDir(fp);
            }
            obj = ord.resolve(target).get();
        }
        return obj;
    }

    public void setContext(Context cx) {
        this.context = cx;
    }

    public class DeployTransferResult
    extends TransferResult {
        public BComponent target;
        public String[] insertNames;

        public DeployTransferResult(BComponent target, String[] insertNames) {
            super(insertNames);
            this.target = target;
            this.insertNames = insertNames;
        }

        @Override
        public void undo() {
            throw new UnsupportedOperationException();
        }
    }
}

