/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.sys.transfer;

import com.tridium.sys.transfer.TransferResult;
import com.tridium.sys.transfer.TransferStrategy;
import javax.baja.space.Mark;
import javax.baja.sync.Transaction;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.BVector;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.util.BNameMap;

public class CompTransferResult
extends TransferResult {
    public final int action;
    public final BComponent origParent;
    public final String[] origNames;
    public final BComponent target;
    public final String[] insertNames;
    public final BNameMap origDisplayNames;
    private final Context cx;

    @Deprecated
    public CompTransferResult(int action, BComponent origParent, String[] origNames, BComponent target, String[] insertNames) {
        this(action, origParent, origNames, target, insertNames, null, null);
    }

    public CompTransferResult(int action, BComponent origParent, String[] origNames, BComponent target, String[] insertNames, BNameMap origDisplayNames, Context cx) {
        super(insertNames);
        this.action = action;
        this.origParent = origParent;
        this.origNames = origNames;
        this.target = target;
        this.insertNames = insertNames;
        this.origDisplayNames = origDisplayNames;
        this.cx = cx;
    }

    @Override
    public void undo() throws Exception {
        if (this.action == 16) {
            this.undoCopy();
        } else {
            this.undoMove();
        }
    }

    protected BComponent makeParams() {
        return new BVector();
    }

    private void undoCopy() throws Exception {
        String[] props = this.getInsertNames();
        Context tx = Transaction.start(this.target, this.cx);
        for (int i = 0; i < props.length; ++i) {
            Property prop = this.target.getProperty(props[i]);
            if (prop == null) continue;
            this.target.remove(prop, tx);
        }
        if (this.origDisplayNames != null) {
            BValue nameMap = this.target.get("displayNames");
            if (nameMap == null) {
                if (!this.origDisplayNames.isNull()) {
                    this.target.add("displayNames", this.origDisplayNames);
                }
            } else if (nameMap instanceof BNameMap) {
                if (this.origDisplayNames.isNull()) {
                    this.target.remove("displayNames");
                } else {
                    this.target.set("displayNames", (BValue)this.origDisplayNames);
                }
            }
        }
        Transaction.end(this.target, tx);
    }

    public void undoMove() throws Exception {
        Mark restoreMark = CompTransferResult.rebuildMark(this.target, this.insertNames, this.origNames);
        TransferStrategy strategy = TransferStrategy.make(32, restoreMark, this.origParent, this.makeParams(), this.cx);
        strategy.transfer();
    }

    static Mark rebuildMark(BComponent comp, String[] actual, String[] desired) throws Exception {
        comp.loadSlots();
        BObject[] values = new BObject[actual.length];
        for (int i = 0; i < values.length; ++i) {
            values[i] = comp.get(actual[i]);
        }
        return new Mark(values, desired);
    }
}

