/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.sys.tag;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.baja.data.BIDataValue;
import javax.baja.naming.SlotPath;
import javax.baja.sys.BComponent;
import javax.baja.sys.BValue;
import javax.baja.sys.Flags;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Type;
import javax.baja.tag.Id;
import javax.baja.tag.Tag;
import javax.baja.tag.Tags;
import javax.baja.util.BDataSet;

public class ComponentTags
implements Tags {
    private final BComponent owner;
    private static final String ESCAPED_COLON = SlotPath.escape(":");

    public ComponentTags(BComponent owner) {
        Objects.requireNonNull(owner);
        this.owner = owner;
    }

    @Override
    public boolean isMulti(Id id) {
        return this.owner.get(ComponentTags.idToSlotName(id)) instanceof BDataSet;
    }

    @Override
    public Optional<BIDataValue> get(Id id) {
        BValue v = this.owner.get(ComponentTags.idToSlotName(id));
        if (v instanceof BIDataValue) {
            return Optional.of((BIDataValue)((Object)v));
        }
        return Optional.empty();
    }

    @Override
    public boolean set(Tag tag) {
        BValue currentValue;
        Objects.requireNonNull(tag);
        Id id = tag.getId();
        BValue newValue = tag.getValue().as(BValue.class);
        Optional<Property> maybeProp = this.idToTaggableProperty(id);
        if (!maybeProp.isPresent()) {
            this.owner.add(ComponentTags.idToSlotName(id), newValue, 16384);
            return true;
        }
        Property p = maybeProp.get();
        if (ComponentTags.isDataSet(p)) {
            ComponentTags.throwExistingPropertyException("Cannot call set on a multi-value tag", p, id);
        }
        if (newValue.equals(currentValue = this.owner.get(p))) {
            return false;
        }
        if (!currentValue.getClass().isAssignableFrom(newValue.getClass())) {
            ComponentTags.throwExistingPropertyException(String.format("Incompatible types: Existing tag value has type %s, but new value has type %s", currentValue.getType(), newValue.getType()), p, id);
        }
        this.owner.set(p, newValue);
        return true;
    }

    @Override
    public boolean setMulti(Id id, Collection<? extends BIDataValue> values) {
        return this.updateMulti(id, values, true);
    }

    @Override
    public boolean addMulti(Id id, Collection<? extends BIDataValue> values) {
        return this.updateMulti(id, values, false);
    }

    private boolean updateMulti(Id id, Collection<? extends BIDataValue> values, boolean overwrite) {
        BDataSet newData;
        BValue currentValue;
        BDataSet currentData;
        Objects.requireNonNull(id);
        Objects.requireNonNull(values);
        if (values.isEmpty()) {
            if (overwrite) {
                return this.removeAll(id);
            }
            return false;
        }
        Optional<Property> maybeProp = this.idToTaggableProperty(id);
        if (!maybeProp.isPresent()) {
            this.owner.add(ComponentTags.idToSlotName(id), (BValue)BDataSet.make(values), 16384);
            return true;
        }
        Property p = maybeProp.get();
        if (!ComponentTags.isDataSet(p)) {
            ComponentTags.throwExistingPropertyException("Cannot add multiple values to an existing property that is not a BDataSet", p, id);
        }
        if ((currentData = (currentValue = this.owner.get(p)).as(BDataSet.class)).equals(newData = BDataSet.make(values))) {
            return false;
        }
        this.owner.set(p, (BValue)(overwrite ? newData : this.owner.get(p).as(BDataSet.class).add(newData)));
        return true;
    }

    private static void throwExistingPropertyException(String cause, Property p, Id id) {
        throw new IllegalArgumentException(String.format("%s maps to existing property %s that cannot be updated. %s", id, p, cause));
    }

    @Override
    public boolean remove(Id id, BIDataValue value) {
        Optional<Property> maybeProp = this.idToTaggableProperty(id);
        if (!maybeProp.isPresent()) {
            return false;
        }
        Property p = maybeProp.get();
        BValue currentValue = this.owner.get(p).asValue();
        if (ComponentTags.isDataSet(p)) {
            BDataSet currentDataSet = currentValue.as(BDataSet.class);
            if (!currentDataSet.contains(value)) {
                return false;
            }
            BDataSet newValue = currentDataSet.remove(value);
            if (newValue.isEmpty() && !p.isFrozen()) {
                this.owner.remove(p);
            } else {
                this.owner.set(p, (BValue)newValue);
            }
            return true;
        }
        if (p.isFrozen()) {
            return false;
        }
        this.owner.remove(p);
        return true;
    }

    @Override
    public Collection<Tag> filter(Predicate<Tag> f) {
        ArrayList<Tag> tags = new ArrayList<Tag>();
        Consumer<Tag> applyFilter = tag -> {
            if (f.test((Tag)tag)) {
                tags.add((Tag)tag);
            }
        };
        try (SlotCursor<Property> cursor = this.owner.getProperties();){
            while (cursor.next()) {
                Property p = cursor.property();
                if (!this.isTaggableSlot(p)) continue;
                BValue bValue = this.owner.get(p);
                Type bValueType = bValue.getType();
                if (!bValueType.is(BIDataValue.TYPE) && !bValueType.is(BDataSet.TYPE)) {
                    bValue = (BValue)((Object)bValue.toDataValue());
                }
                Id id = ComponentTags.slotToId(p);
                if (ComponentTags.isDataSet(p)) {
                    bValue.as(BDataSet.class).asImmutableSet().stream().map(v -> new Tag(id, (BIDataValue)v)).forEach(applyFilter);
                    continue;
                }
                applyFilter.accept(new Tag(id, bValue.as(BIDataValue.class)));
            }
        }
        return tags;
    }

    private Optional<Slot> idToSlot(Id id) {
        String slotName = ComponentTags.idToSlotName(id);
        return Optional.ofNullable(this.owner.getSlot(slotName));
    }

    private Optional<Property> idToTaggableProperty(Id id) {
        Optional<Slot> maybeSlot = this.idToSlot(id);
        if (!maybeSlot.isPresent()) {
            return Optional.empty();
        }
        Slot slot = maybeSlot.get();
        if (!slot.isProperty()) {
            throw new IllegalArgumentException(String.format("%s maps to untaggable slot type %s. Only property slots can be tagged.", id, slot.getClass()));
        }
        if (Flags.isTransient(this.owner, slot)) {
            throw new IllegalArgumentException(String.format("Transient properties cannot be tagged. %s", id));
        }
        if (!slot.asProperty().getType().is(BIDataValue.TYPE) && !slot.asProperty().getType().is(BDataSet.TYPE)) {
            throw new IllegalArgumentException(String.format("Only properties with type BIDataValue or BDataSet can be tagged. %s is a %s", id, slot.asProperty().getType()));
        }
        return Optional.of(slot.asProperty());
    }

    private boolean isTaggableSlot(Slot slot) {
        boolean valid;
        boolean bl = valid = slot != null && slot.isProperty() && !Flags.isTransient(this.owner, slot) && !slot.asProperty().getType().is(BComponent.TYPE) && Flags.isMetadata(this.owner, slot);
        if (!valid) {
            return false;
        }
        int colon = slot.getName().indexOf(ESCAPED_COLON);
        if (colon == -1) {
            return true;
        }
        return slot.getName().indexOf(ESCAPED_COLON, colon + 1) == -1;
    }

    private static String idToSlotName(Id id) {
        return SlotPath.escape(id.getQName());
    }

    private static Id slotToId(Slot s) {
        return Id.newId(SlotPath.unescape(s.getName()));
    }

    private static boolean isDataSet(Property p) {
        return p.getType().is(BDataSet.TYPE);
    }
}

