/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.sys.tag;

import com.tridium.sys.engine.NRelationKnob;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.baja.naming.BOrd;
import javax.baja.sys.BComponent;
import javax.baja.sys.BLink;
import javax.baja.sys.BRelation;
import javax.baja.sys.BValue;
import javax.baja.sys.Flags;
import javax.baja.sys.Property;
import javax.baja.sys.RelationKnob;
import javax.baja.sys.Slot;
import javax.baja.sys.SlotCursor;
import javax.baja.tag.BasicRelation;
import javax.baja.tag.Entity;
import javax.baja.tag.Id;
import javax.baja.tag.Relation;
import javax.baja.tag.Relations;
import javax.baja.tag.util.ImpliedRelations;

public class ComponentRelations
implements Relations {
    private final BComponent owner;

    public ComponentRelations(BComponent owner) {
        Objects.requireNonNull(owner);
        this.owner = owner;
    }

    @Override
    public Optional<Relation> get(Id id) {
        BRelation relation;
        SlotCursor<Property> cursor = this.owner.getProperties();
        while (cursor.next()) {
            BRelation bRelation;
            Property p = cursor.property();
            if (!this.isRelationSlot(p) || !(bRelation = (BRelation)this.owner.get(p)).getId().equals(id)) continue;
            return Optional.of(bRelation);
        }
        RelationKnob relationKnob = this.owner.getRelationKnob(id);
        if (relationKnob != null && (relation = relationKnob.getRelation()) != null) {
            return Optional.of(new BasicRelation(relation.getId(), relation.getRelationComponent(), relation.tags(), !relation.isInbound()));
        }
        return Optional.empty();
    }

    @Override
    public Collection<Relation> set(Id id, Collection<? extends Entity> endpoints) {
        return null;
    }

    @Override
    public Collection<Relation> set(Id id, Collection<? extends Entity> endpoints, boolean isInbound) {
        return null;
    }

    @Override
    public Relation add(Id id, Entity endpoint, boolean isInbound) {
        return this.add(new BRelation(id, (BComponent)endpoint, isInbound));
    }

    @Override
    public Relation add(Relation relation) {
        if (!(relation instanceof BRelation)) {
            throw new IllegalArgumentException(String.format("%s is not a BRelation type, cannot be added.", relation));
        }
        BRelation bRelation = (BRelation)relation;
        if (relation.isOutbound()) {
            Property p = this.owner.add("r?", bRelation);
            if (p == null) {
                return null;
            }
            return (Relation)((Object)this.owner.get(p));
        }
        Entity endpoint = relation.getEndpoint();
        if (endpoint instanceof BComponent) {
            BComponent otherComp = (BComponent)endpoint;
            BRelation revRelation = new BRelation(bRelation.getId(), this.owner);
            Property p = otherComp.add("r?", revRelation);
            return (Relation)((Object)otherComp.get(p));
        }
        return null;
    }

    @Override
    public boolean remove(Id id, Entity endpoint) {
        return this.remove(new BRelation(id, (BComponent)endpoint));
    }

    @Override
    public boolean remove(Relation relation) {
        Optional<Property> maybeProp = this.relationToProperty(relation);
        if (!maybeProp.isPresent()) {
            return false;
        }
        Property p = maybeProp.get();
        if (p.isFrozen()) {
            return false;
        }
        this.owner.remove(p);
        return true;
    }

    @Override
    public Collection<Relation> filter(Predicate<Relation> condition, int direction) {
        ArrayList<Relation> relations = new ArrayList<Relation>();
        Consumer<Relation> applyFilter = relation -> {
            if (condition.test((Relation)relation) && ImpliedRelations.isMatchingDirection(relation, direction)) {
                relations.add((Relation)relation);
            }
        };
        RelationKnob[] relationKnobArray = null;
        try (SlotCursor<Property> cursor = this.owner.getProperties();){
            while (cursor.next()) {
                Property p = cursor.property();
                if (!this.isRelationSlot(p)) continue;
                Id id = ((Relation)((Object)this.owner.get(p))).getId();
                BRelation relation2 = (BRelation)this.owner.get(p);
                if (!relation2.isDirect() && relation2.getEndpointOrd().equals(BOrd.NULL)) continue;
                applyFilter.accept(new BasicRelation(id, relation2.getEndpoint(), relation2.tags(), false));
            }
        }
        catch (Throwable object) {
            relationKnobArray = object;
            throw object;
        }
        BRelation relation3 = null;
        for (RelationKnob knob : this.owner.getRelationKnobs()) {
            if (((NRelationKnob)knob).isProxy()) {
                BComponent relationParent = (BComponent)knob.getRelationOrd().resolve(this.owner.getComponentSpace()).get();
                for (BRelation bRelation : relationParent.getComponentRelations()) {
                    if (!bRelation.getId().getQName().equals(knob.getRelationId())) continue;
                    relation3 = bRelation;
                    break;
                }
                if (relation3 == null) {
                    continue;
                }
            } else {
                relation3 = knob.getRelation();
            }
            boolean inbound = true;
            if (relation3 == null || relation3.getEndpoint() == null) continue;
            applyFilter.accept(new BasicRelation(relation3.getId(), relation3.getRelationComponent(), relation3.tags(), inbound));
        }
        return relations;
    }

    private Optional<Property> relationToProperty(Relation value) {
        if (!(value instanceof BRelation)) {
            throw new IllegalArgumentException(String.format("%s isn't a BRelation type, cannot be mapped to property.", value));
        }
        SlotCursor<Property> cursor = this.owner.getProperties();
        while (cursor.next()) {
            BRelation relation;
            BValue bValue = cursor.get();
            if (!(bValue instanceof BRelation) || !(relation = (BRelation)bValue).getRelationId().equals(((BRelation)value).getRelationId())) continue;
            return Optional.of(cursor.property());
        }
        return Optional.empty();
    }

    private boolean isRelationSlot(Slot slot) {
        boolean valid = slot != null && slot.isProperty() && !Flags.isTransient(this.owner, slot) && slot.asProperty().getType().is(BRelation.TYPE) && !slot.asProperty().getType().is(BLink.TYPE);
        return valid;
    }
}

