/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.sys.stdout;

import java.io.PrintStream;
import java.io.Writer;
import javax.baja.spy.Spy;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.Clock;
import javax.baja.sys.Sys;
import org.owasp.encoder.Encode;

public class StdoutManager
extends PrintStream {
    public int x = 10;
    public final PrintStream out;
    private byte[] buffer = new byte[8192];
    private int pos;

    public StdoutManager() {
        super(System.err);
        this.out = System.err;
        System.setOut(this);
        System.setErr(this);
    }

    @Override
    public final void flush() {
        this.out.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void write(int b) {
        this.out.write(b);
        byte[] byArray = this.buffer;
        synchronized (this.buffer) {
            this.buffer[this.pos] = (byte)(b & 0xFF);
            this.pos = (this.pos + 1) % this.buffer.length;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    @Override
    public final void write(byte[] b) {
        this.write(b, 0, b.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void write(byte[] b, int off, int len) {
        this.out.write(b, off, len);
        byte[] byArray = this.buffer;
        synchronized (this.buffer) {
            int n;
            if (len > this.buffer.length) {
                off = off + len - this.buffer.length;
                len = this.buffer.length;
            }
            if ((n = Math.min(len, this.buffer.length - this.pos)) == len) {
                System.arraycopy(b, off, this.buffer, this.pos, n);
                this.pos = (this.pos + len) % this.buffer.length;
            } else {
                int r = len - n;
                System.arraycopy(b, off, this.buffer, this.pos, n);
                System.arraycopy(b, off + n, this.buffer, 0, r);
                this.pos = r;
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return;
        }
    }

    public void directPrintln(String msg) {
        this.out.println(msg);
    }

    public void directPrint(String msg) {
        this.out.print(msg);
    }

    public void directFlush() {
        this.out.flush();
    }

    public void postInit() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getBuffer() {
        byte[] byArray = this.buffer;
        synchronized (this.buffer) {
            byte[] copy = new byte[this.buffer.length];
            System.arraycopy(this.buffer, this.pos, copy, 0, this.buffer.length - this.pos);
            System.arraycopy(this.buffer, 0, copy, this.buffer.length - this.pos, this.pos);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return copy;
        }
    }

    public class SpyPage
    extends Spy {
        @Override
        public void write(SpyWriter out) throws Exception {
            if (Sys.getStation() != null) {
                out.w("<b>Station</b> ").w(Sys.getStation().getStationName()).w(" | ");
            }
            out.w("<b>Time</b> ").w(Clock.time());
            out.w("<hr>\n");
            out.w("<pre>\n");
            byte[] buf = StdoutManager.this.getBuffer();
            StringBuilder sOut = new StringBuilder();
            for (int i = 0; i < buf.length; ++i) {
                byte b = buf[i];
                if (b == 0) continue;
                sOut.append((char)b);
            }
            Encode.forHtml((Writer)out, (String)sOut.toString());
            out.w("</pre>\n");
        }
    }
}

