/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.sys.schema;

import com.tridium.sys.schema.DynamicTable;
import com.tridium.sys.schema.NTopic;
import javax.baja.sys.Action;
import javax.baja.sys.BComplex;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.CursorException;
import javax.baja.sys.Property;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Topic;

final class TopicCursor
implements SlotCursor<Topic> {
    private int index = -1;
    private volatile boolean closed;
    private BComplex object;
    private NTopic[] frozen;
    private DynamicTable dynamic;

    TopicCursor(BComplex o, NTopic[] f, DynamicTable d) {
        this.object = o;
        this.frozen = f;
        this.dynamic = d;
    }

    @Override
    public void close() {
        this.closed = true;
    }

    @Override
    public BObject target() {
        return this.object;
    }

    @Override
    public Context getContext() {
        return null;
    }

    @Override
    public boolean next() {
        if (this.closed) {
            return false;
        }
        if (++this.index < this.frozen.length) {
            return true;
        }
        if (this.dynamic == null) {
            return false;
        }
        while (this.index - this.frozen.length < this.dynamic.count) {
            if (this.dynamic.slots[this.index - this.frozen.length].isTopic()) {
                return true;
            }
            ++this.index;
        }
        return false;
    }

    @Override
    public boolean nextObject() {
        throw new CursorException("Only for iterating through properties");
    }

    @Override
    public boolean nextComponent() {
        throw new CursorException("Only for iterating through properties");
    }

    @Override
    public boolean next(Class<?> cls) {
        throw new CursorException("Only for iterating through properties");
    }

    @Override
    public Topic slot() {
        if (this.closed) {
            throw new CursorException("cursor was closed");
        }
        if (this.index < this.frozen.length) {
            return this.frozen[this.index];
        }
        if (this.index - this.frozen.length < this.dynamic.count) {
            return (Topic)((Object)this.dynamic.slots[this.index - this.frozen.length]);
        }
        throw new CursorException("No more elements");
    }

    @Override
    public Topic topic() {
        return this.slot().asTopic();
    }

    @Override
    public Property property() {
        throw new CursorException("not property");
    }

    @Override
    public int getTypeAccess() {
        throw new CursorException("not property");
    }

    @Override
    public BValue get() {
        throw new CursorException("not property");
    }

    @Override
    public boolean getBoolean() {
        throw new CursorException("not property");
    }

    @Override
    public int getInt() {
        throw new CursorException("not property");
    }

    @Override
    public long getLong() {
        throw new CursorException("not property");
    }

    @Override
    public float getFloat() {
        throw new CursorException("not property");
    }

    @Override
    public double getDouble() {
        throw new CursorException("not property");
    }

    @Override
    public String getString() {
        throw new CursorException("not property");
    }

    @Override
    public Action action() {
        throw new CursorException("not action");
    }
}

