/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.sys.schema;

import com.tridium.asm.Assembler;
import com.tridium.asm.AttributeInfo;
import com.tridium.asm.Buffer;
import com.tridium.asm.Code;
import com.tridium.asm.FieldInfo;
import com.tridium.asm.Jvm;
import com.tridium.asm.MethodInfo;
import java.io.DataInput;
import java.io.DataOutput;
import javax.baja.agent.AgentList;
import javax.baja.naming.BOrd;
import javax.baja.naming.BOrdList;
import javax.baja.nre.util.ByteBuffer;
import javax.baja.registry.Registry;
import javax.baja.registry.TypeInfo;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFrozenEnum;
import javax.baja.sys.BIService;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BTypeSpec;

public class SyntheticCompiler {
    public static final BComponent COMPONENT = new BComponent();

    public static Buffer compile(BTypeSpec typeSpec, TypeInfo superClassInfo, TypeInfo[] interfacesInfo, boolean isAbstract, boolean isFinal, boolean isTransientType) {
        if (typeSpec == null) {
            throw new IllegalArgumentException("Synthetic TypeSpec is null.");
        }
        return SyntheticCompiler.compile(typeSpec.getTypeInfo().getTypeClassName(), superClassInfo, interfacesInfo, isAbstract, isFinal, isTransientType, null);
    }

    public static Buffer compile(String className, TypeInfo superClassInfo, TypeInfo[] interfacesInfo, boolean isAbstract, boolean isFinal, boolean isTransientType, byte[] def) {
        String classDotName = className.replace('.', '/');
        if (superClassInfo == null) {
            throw new IllegalArgumentException("Superclass is null.");
        }
        if (superClassInfo.isFinal()) {
            throw new IllegalArgumentException("Superclass is final: " + superClassInfo.getTypeName());
        }
        if (superClassInfo.isInterface()) {
            throw new IllegalArgumentException("Superclass is an interface: " + superClassInfo.getTypeName());
        }
        String superClass = superClassInfo.getTypeClassName().replace('.', '/');
        String[] interfaces = null;
        if (interfacesInfo != null && interfacesInfo.length != 0) {
            interfaces = new String[interfacesInfo.length];
            for (int i = 0; i < interfacesInfo.length; ++i) {
                if (!interfacesInfo[i].isInterface()) {
                    throw new IllegalArgumentException("Class is not an interface: " + interfacesInfo[i].getTypeName());
                }
                interfaces[i] = interfacesInfo[i].getTypeClassName().replace('.', '/');
            }
        }
        if (isAbstract && isFinal) {
            throw new IllegalArgumentException("Illegal to declare class both final and abstract.");
        }
        int flags = 1;
        if (isAbstract) {
            flags |= 0x400;
        }
        if (isFinal) {
            flags |= 0x10;
        }
        Assembler asm = new Assembler(classDotName, superClass, flags, interfaces);
        asm.addAttribute(new AttributeInfo(asm, "SourceFile", "AutoGenerated"));
        asm.addAttribute(new AttributeInfo(asm, "Synthetic", new byte[0]));
        FieldInfo typeField = new FieldInfo(asm, "TYPE", Jvm.fieldDescriptor(Type.class), 25);
        asm.addField(typeField);
        FieldInfo introspectorField = new FieldInfo(asm, "INTROSPECTOR", Jvm.fieldDescriptor(Class.class), 25);
        asm.addField(introspectorField);
        FieldInfo valueField = null;
        FieldInfo defaultField = null;
        if (superClassInfo.is(BSimple.TYPE) && !superClassInfo.is(BFrozenEnum.TYPE) && !isAbstract) {
            valueField = new FieldInfo(asm, "value", Jvm.fieldDescriptor(String.class), 18);
            asm.addField(valueField);
            if (def == null) {
                throw new IllegalArgumentException("Default must be specified for simple types.");
            }
            defaultField = new FieldInfo(asm, "DEFAULT", "L" + classDotName + ";", 25);
            asm.addField(defaultField);
        }
        Code c = new Code(asm);
        if (superClassInfo.is(BComplex.TYPE)) {
            c.add(18, asm.cp.string("com.tridium.sys.schema.SyntheticComplexIntrospector"));
        } else if (superClassInfo.is(BFrozenEnum.TYPE)) {
            c.add(18, asm.cp.string("com.tridium.sys.schema.SyntheticEnumIntrospector"));
        } else if (superClassInfo.is(BSimple.TYPE)) {
            c.add(18, asm.cp.string("com.tridium.sys.schema.SyntheticSimpleIntrospector"));
            superClassInfo = BSimple.TYPE.getTypeInfo();
        } else {
            throw new IllegalArgumentException("Specified super class '" + superClassInfo + "' can not be used to create a synthetic type.");
        }
        c.add(184, asm.cp.method(asm.cp.cls(Class.class), "forName", Jvm.methodDescriptor(new Class[]{String.class}, Class.class)));
        c.add(179, asm.cp.field(introspectorField));
        if (defaultField != null) {
            c.add(187, asm.thisClass);
            c.add(89);
            c.add(18, asm.cp.string(new String(def)));
            c.add(183, c.cp.method(asm.thisClass, asm.cp.utf("<init>"), Jvm.methodDescriptor(new Class[]{String.class}, Void.TYPE)));
            c.add(179, asm.cp.field(defaultField));
        }
        c.add(18, asm.cp.string(className));
        c.add(184, asm.cp.method(asm.cp.cls(Class.class), "forName", Jvm.methodDescriptor(new Class[]{String.class}, Class.class)));
        c.add(184, asm.cp.method(asm.cp.cls(Sys.class), asm.cp.nt("loadType", Jvm.methodDescriptor(new Class[]{Class.class}, Type.class))));
        c.add(179, asm.cp.field(typeField));
        c.add(177);
        asm.addMethod(new MethodInfo(asm, asm.cp.utf("<clinit>"), Jvm.methodDescriptor(new Class[0], Void.TYPE), 1, c));
        c = new Code(asm);
        c.add(42);
        c.add(178, asm.cp.field(typeField));
        c.add(176);
        asm.addMethod(new MethodInfo(asm, "getType", Jvm.methodDescriptor(new Class[0], Type.class), 1, c));
        if (isTransientType) {
            c = new Code(asm);
            c.add(42);
            c.add(183, c.cp.method(asm.superClass, asm.cp.utf("getIcon"), Jvm.methodDescriptor(new Class[0], BIcon.class)));
            c.add(182, c.cp.method(asm.cp.cls(BIcon.class), asm.cp.utf("getOrdList"), Jvm.methodDescriptor(new Class[0], BOrdList.class)));
            c.add(18, asm.cp.string("module://icons/x16/badges/beaker.png"));
            c.add(184, c.cp.method(asm.cp.cls(BOrd.class), asm.cp.utf("make"), Jvm.methodDescriptor(new Class[]{String.class}, BOrd.class)));
            c.add(184, c.cp.method(asm.cp.cls(BOrdList.class), asm.cp.utf("add"), Jvm.methodDescriptor(new Class[]{BOrdList.class, BOrd.class}, BOrdList.class)));
            c.add(184, c.cp.method(asm.cp.cls(BIcon.class), asm.cp.utf("make"), Jvm.methodDescriptor(new Class[]{BOrdList.class}, BIcon.class)));
            c.add(176);
            asm.addMethod(new MethodInfo(asm, "getIcon", Jvm.methodDescriptor(new Class[0], BIcon.class), 1, c));
            c = new Code(asm);
            if (superClassInfo.is(BComponent.TYPE)) {
                c.add(178, c.cp.field(c.cp.cls(SyntheticCompiler.class), c.cp.utf("COMPONENT"), Jvm.fieldDescriptor(BComponent.class)));
                c.add(43);
                c.add(182, c.cp.method(c.cp.cls(BComponent.class), "getAgents", Jvm.methodDescriptor(new Class[]{Context.class}, AgentList.class)));
                c.add(176);
            } else if (superClassInfo.is(BComplex.TYPE)) {
                c.add(184, c.cp.method(asm.cp.cls(Sys.class), asm.cp.utf("getRegistry"), Jvm.methodDescriptor(new Class[0], Registry.class)));
                c.add(178, c.cp.field(c.cp.cls(BComplex.class), c.cp.utf("TYPE"), Jvm.fieldDescriptor(Type.class)));
                c.invokeInterface(c.cp.iface(c.cp.cls(Type.class), c.cp.nt(c.cp.utf("getTypeInfo"), Jvm.methodDescriptor(new Class[0], TypeInfo.class))), 1);
                c.invokeInterface(c.cp.iface(c.cp.cls(Registry.class), c.cp.nt(c.cp.utf("getAgents"), Jvm.methodDescriptor(new Class[]{TypeInfo.class}, AgentList.class))), 2);
                c.add(176);
            } else if (superClassInfo.is(BFrozenEnum.TYPE)) {
                c.add(184, c.cp.method(asm.cp.cls(Sys.class), asm.cp.utf("getRegistry"), Jvm.methodDescriptor(new Class[0], Registry.class)));
                c.add(178, c.cp.field(c.cp.cls(BFrozenEnum.class), c.cp.utf("TYPE"), Jvm.fieldDescriptor(Type.class)));
                c.invokeInterface(c.cp.iface(c.cp.cls(Type.class), c.cp.nt(c.cp.utf("getTypeInfo"), Jvm.methodDescriptor(new Class[0], TypeInfo.class))), 1);
                c.invokeInterface(c.cp.iface(c.cp.cls(Registry.class), c.cp.nt(c.cp.utf("getAgents"), Jvm.methodDescriptor(new Class[]{TypeInfo.class}, AgentList.class))), 2);
                c.add(176);
            } else if (superClassInfo.is(BSimple.TYPE)) {
                c.add(184, c.cp.method(asm.cp.cls(Sys.class), asm.cp.utf("getRegistry"), Jvm.methodDescriptor(new Class[0], Registry.class)));
                c.add(178, c.cp.field(c.cp.cls(BSimple.class), c.cp.utf("TYPE"), Jvm.fieldDescriptor(Type.class)));
                c.invokeInterface(c.cp.iface(c.cp.cls(Type.class), c.cp.nt(c.cp.utf("getTypeInfo"), Jvm.methodDescriptor(new Class[0], TypeInfo.class))), 1);
                c.invokeInterface(c.cp.iface(c.cp.cls(Registry.class), c.cp.nt(c.cp.utf("getAgents"), Jvm.methodDescriptor(new Class[]{TypeInfo.class}, AgentList.class))), 2);
                c.add(176);
            } else {
                throw new IllegalArgumentException("Specified super class '" + superClassInfo + "' can not be used to create a synthetic type.");
            }
            asm.addMethod(new MethodInfo(asm, "getAgents", Jvm.methodDescriptor(new Class[]{Context.class}, AgentList.class), 1, c));
        }
        if (superClassInfo.is(BIService.TYPE)) {
            c = new Code(asm);
            c.add(4);
            c.add(189, c.cp.cls(Type.class));
            c.add(89);
            c.add(3);
            c.add(178, asm.cp.field(typeField));
            c.add(83);
            c.add(176);
            asm.addMethod(new MethodInfo(asm, "getServiceTypes", Jvm.methodDescriptor(new Class[0], Type[].class), 1, c));
        }
        if (superClassInfo.is(BComplex.TYPE)) {
            c = new Code(asm);
            c.add(42);
            c.add(183, c.cp.method(asm.superClass, asm.cp.utf("<init>"), Jvm.methodDescriptor(new Class[0], Void.TYPE)));
            c.add(177);
            asm.addMethod(new MethodInfo(asm, asm.cp.utf("<init>"), Jvm.methodDescriptor(new Class[0], Void.TYPE), 1, c));
        } else if (superClassInfo.is(BFrozenEnum.TYPE)) {
            c = new Code(asm);
            c.add(42);
            c.add(27);
            c.add(183, c.cp.method(asm.superClass, asm.cp.utf("<init>"), Jvm.methodDescriptor(new Class[]{Integer.TYPE}, Void.TYPE)));
            c.add(177);
            asm.addMethod(new MethodInfo(asm, asm.cp.utf("<init>"), Jvm.methodDescriptor(new Class[]{Integer.TYPE}, Void.TYPE), 1, c));
        } else if (superClassInfo.is(BSimple.TYPE)) {
            c = new Code(asm);
            c.add(42);
            c.add(89);
            c.add(183, c.cp.method(asm.superClass, asm.cp.utf("<init>"), Jvm.methodDescriptor(new Class[0], Void.TYPE)));
            if (!isAbstract) {
                c.add(43);
                c.add(181, asm.cp.field(valueField));
                c.add(177);
                asm.addMethod(new MethodInfo(asm, asm.cp.utf("<init>"), Jvm.methodDescriptor(new Class[]{String.class}, Void.TYPE), 1, c));
            } else {
                c.add(177);
                asm.addMethod(new MethodInfo(asm, asm.cp.utf("<init>"), Jvm.methodDescriptor(new Class[0], Void.TYPE), 1, c));
            }
            if (!isAbstract) {
                c = new Code(asm);
                c.add(42);
                c.add(180, asm.cp.field(valueField));
                c.add(182, c.cp.method(c.cp.cls(String.class), "hashCode", Jvm.methodDescriptor(new Class[0], Integer.TYPE)));
                c.add(172);
                asm.addMethod(new MethodInfo(asm, "hashCode", Jvm.methodDescriptor(new Class[0], Integer.TYPE), 1, c));
                c = new Code(asm);
                c.add(43);
                c.add(193, asm.thisClass);
                c.code.u1(153);
                c.code.u2(18);
                c.add(42);
                c.add(180, asm.cp.field(valueField));
                c.add(43);
                c.add(192, asm.thisClass);
                c.add(180, asm.cp.field(valueField));
                c.add(182, c.cp.method(c.cp.cls(String.class), "equals", Jvm.methodDescriptor(new Class[]{Object.class}, Boolean.TYPE)));
                c.add(172);
                c.add(3);
                c.add(172);
                asm.addMethod(new MethodInfo(asm, "equals", Jvm.methodDescriptor(new Class[]{Object.class}, Boolean.TYPE), 1, c));
                c = new Code(asm);
                c.add(42);
                c.add(180, asm.cp.field(valueField));
                c.add(176);
                asm.addMethod(new MethodInfo(asm, "toString", Jvm.methodDescriptor(new Class[]{Context.class}, String.class), 1, c));
                c = new Code(asm);
                c.add(43);
                c.add(42);
                c.add(180, asm.cp.field(valueField));
                c.add(182, c.cp.method(c.cp.cls(String.class), "getBytes", Jvm.methodDescriptor(new Class[0], byte[].class)));
                c.invokeInterface(c.cp.iface(c.cp.cls(DataOutput.class), c.cp.nt(c.cp.utf("write"), Jvm.methodDescriptor(new Class[]{byte[].class}, Void.TYPE))), 2);
                c.add(177);
                asm.addMethod(new MethodInfo(asm, "encode", Jvm.methodDescriptor(new Class[]{DataOutput.class}, Void.TYPE), 1, c));
                c = new Code(asm);
                c.add(187, asm.cp.cls(ByteBuffer.class));
                c.add(89);
                c.add(183, c.cp.method(c.cp.cls(ByteBuffer.class), asm.cp.utf("<init>"), Jvm.methodDescriptor(new Class[0], Void.TYPE)));
                c.add(77);
                c.add(44);
                c.add(43);
                c.invokeInterface(c.cp.iface(c.cp.cls(DataInput.class), c.cp.nt(c.cp.utf("readByte"), Jvm.methodDescriptor(new Class[0], Byte.TYPE))), 1);
                c.add(182, c.cp.method(c.cp.cls(ByteBuffer.class), "writeByte", Jvm.methodDescriptor(new Class[]{Integer.TYPE}, Void.TYPE)));
                c.code.u1(167);
                c.code.u2(-10);
                c.add(87);
                c.add(187, asm.thisClass);
                c.add(89);
                c.add(187, c.cp.cls(String.class));
                c.add(89);
                c.add(44);
                c.add(182, c.cp.method(c.cp.cls(ByteBuffer.class), "toByteArray", Jvm.methodDescriptor(new Class[0], byte[].class)));
                c.add(183, c.cp.method(c.cp.cls(String.class), asm.cp.utf("<init>"), Jvm.methodDescriptor(new Class[]{byte[].class}, Void.TYPE)));
                c.add(183, c.cp.method(asm.thisClass, asm.cp.utf("<init>"), Jvm.methodDescriptor(new Class[]{String.class}, Void.TYPE)));
                c.add(176);
                asm.addMethod(new MethodInfo(asm, "decode", Jvm.methodDescriptor(new Class[]{DataInput.class}, BObject.class), 1, c));
                c = new Code(asm);
                c.add(42);
                c.add(180, asm.cp.field(valueField));
                c.add(176);
                asm.addMethod(new MethodInfo(asm, "encodeToString", Jvm.methodDescriptor(new Class[0], String.class), 1, c));
                c = new Code(asm);
                c.add(187, asm.thisClass);
                c.add(89);
                c.add(43);
                c.add(183, c.cp.method(asm.thisClass, asm.cp.utf("<init>"), Jvm.methodDescriptor(new Class[]{String.class}, Void.TYPE)));
                c.add(176);
                asm.addMethod(new MethodInfo(asm, "decodeFromString", Jvm.methodDescriptor(new Class[]{String.class}, BObject.class), 1, c));
            }
        }
        Buffer buffer = asm.compile();
        return buffer;
    }
}

