/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.sys.schema;

import com.tridium.sys.Nre;
import com.tridium.sys.schema.Introspector;
import com.tridium.sys.schema.SimpleType;
import com.tridium.util.ArrayUtil;
import com.tridium.util.EscUtil;
import java.lang.ref.SoftReference;
import java.lang.reflect.Array;
import java.security.AccessController;
import java.util.Arrays;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.spy.Spy;
import javax.baja.spy.SpyDir;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.BSimple;
import javax.baja.sys.BValue;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.sys.TypeIntrospectionException;
import javax.baja.sys.TypeNotFoundException;
import javax.baja.util.BTypeSpec;

public class SchemaManager {
    Type booleanType;
    Type integerType;
    Type longType;
    Type floatType;
    Type doubleType;
    Type stringType;
    static Logger log = Logger.getLogger("sys.schema");
    private int nextId;
    private Type[] types = new Type[256];
    private final Map<String, Type> byClass = new Hashtable<String, Type>();
    private static final boolean verbose = true;

    public synchronized Type getType(int id) {
        Type type = null;
        try {
            type = this.types[id];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        if (type == null) {
            throw new TypeNotFoundException(String.valueOf(id));
        }
        return type;
    }

    public synchronized Type getType(Class<?> cls) {
        Type type = this.byClass.get(cls.getName());
        if (type != null) {
            return type;
        }
        if (cls == Boolean.TYPE) {
            return this.getBooleanType();
        }
        if (cls == Integer.TYPE) {
            return this.getIntegerType();
        }
        if (cls == Long.TYPE) {
            return this.getLongType();
        }
        if (cls == Float.TYPE) {
            return this.getFloatType();
        }
        if (cls == Double.TYPE) {
            return this.getDoubleType();
        }
        if (cls == String.class) {
            return this.getStringType();
        }
        try {
            cls.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        type = this.byClass.get(cls.getName());
        if (type != null) {
            return type;
        }
        try {
            cls.getField("TYPE").get(null);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        type = this.byClass.get(cls.getName());
        if (type != null) {
            return type;
        }
        throw new TypeNotFoundException(cls.getName());
    }

    public synchronized Type[] getTypes() {
        Type[] copy = new Type[this.nextId];
        System.arraycopy(this.types, 0, copy, 0, copy.length);
        return copy;
    }

    public synchronized Type load(Class<?> cls) {
        int id = this.nextId++;
        Type type = this.load(id, cls);
        String typeSpec = type.toString();
        int len = Math.min(this.nextId, this.types.length);
        for (int i = 0; i < len; ++i) {
            if (this.types[i] == null || !this.types[i].toString().equals(typeSpec)) continue;
            this.types[i] = type;
            this.byClass.put(cls.getName(), type);
            --this.nextId;
            return type;
        }
        if (id >= this.types.length) {
            int len2 = Math.max(this.types.length * 2, id + 10);
            Type[] temp = new Type[len2];
            System.arraycopy(this.types, 0, temp, 0, this.types.length);
            this.types = temp;
        }
        this.byClass.put(type.getTypeClass().getName(), type);
        this.types[id] = type;
        return this.types[id];
    }

    public synchronized boolean isTypeLoaded(String typeSpec) {
        return Arrays.stream(this.types).filter(t -> t != null && typeSpec.equals(t.getTypeSpec().toString())).findAny().isPresent();
    }

    public synchronized boolean unload(Class<?> cls) {
        Type type = this.byClass.get(cls.getName());
        if (type != null) {
            this.types = ArrayUtil.removeOne(this.types, type);
            --this.nextId;
            this.byClass.remove(cls.getName());
            return true;
        }
        return false;
    }

    public synchronized boolean unload(Collection<Class<?>> classes) {
        Type[] newTypes = (Type[])Arrays.stream(this.types).filter(t -> {
            if (t == null) {
                return true;
            }
            Class<?> c = t.getTypeClass();
            if (classes.contains(c)) {
                this.byClass.remove(c.getName());
                --this.nextId;
                return false;
            }
            return true;
        }).toArray(Type[]::new);
        if (newTypes.length < this.types.length) {
            this.types = newTypes;
            return true;
        }
        return false;
    }

    private Type load(int id, Class<?> cls) {
        return AccessController.doPrivileged(() -> this.loadPrivileged(id, cls));
    }

    private Type loadPrivileged(int id, Class<?> cls) {
        long t1 = System.currentTimeMillis();
        try {
            Type type = Introspector.create(id, cls).introspect();
            return type;
        }
        catch (TypeIntrospectionException e) {
            log.severe("Cannot load type for \"" + cls.getName() + "\"");
            throw e;
        }
        catch (Throwable e) {
            e.printStackTrace();
            log.log(Level.SEVERE, "ERROR: Cannot load type for \"" + cls.getName() + "\"", e);
            throw new TypeIntrospectionException(cls, e.toString());
        }
        finally {
            long t2 = System.currentTimeMillis();
            if (log.isLoggable(Level.FINE)) {
                log.fine("Loaded \"" + cls.getName() + "\" [" + (t2 - t1) + "ms]");
            }
        }
    }

    public void postInit() {
        Nre.spySysManagers.add("schemaManager", new Page());
    }

    final Type getBooleanType() {
        if (this.booleanType == null) {
            this.booleanType = Sys.getType("baja:Boolean");
        }
        return this.booleanType;
    }

    final Type getIntegerType() {
        if (this.integerType == null) {
            this.integerType = Sys.getType("baja:Integer");
        }
        return this.integerType;
    }

    final Type getLongType() {
        if (this.longType == null) {
            this.longType = Sys.getType("baja:Long");
        }
        return this.longType;
    }

    final Type getFloatType() {
        if (this.floatType == null) {
            this.floatType = Sys.getType("baja:Float");
        }
        return this.floatType;
    }

    final Type getDoubleType() {
        if (this.doubleType == null) {
            this.doubleType = Sys.getType("baja:Double");
        }
        return this.doubleType;
    }

    final Type getStringType() {
        if (this.stringType == null) {
            this.stringType = Sys.getType("baja:String");
        }
        return this.stringType;
    }

    class CachePage
    extends SpyDir {
        BTypeSpec typeSpec;

        CachePage(BTypeSpec typeSpec) {
            this.typeSpec = typeSpec;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Spy find(String name) {
            Type type;
            if (SpyWriter.verifyNameAndCsrfToken(name, "clear") && (type = this.typeSpec.getResolvedType()) instanceof SimpleType) {
                WeakHashMap<BSimple, SoftReference<BSimple>> weakHashMap = ((SimpleType)type).internMap;
                synchronized (weakHashMap) {
                    ((SimpleType)type).internMap.clear();
                    ((SimpleType)type).reuseCounter = 0L;
                }
            }
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void write(SpyWriter out) throws Exception {
            int size = 0;
            WeakHashMap<BSimple, SoftReference<BSimple>> cache = null;
            Type type = this.typeSpec.getResolvedType();
            if (type instanceof SimpleType) {
                cache = ((SimpleType)type).internMap;
            }
            if (cache != null) {
                size = cache.size();
            }
            out.startTable(true);
            boolean showTimesReused = SimpleType.internDebug;
            int columnCount = showTimesReused ? 2 : 1;
            String title = size + " Interned Instances of " + this.typeSpec + " (Reuse count = " + ((SimpleType)type).reuseCounter + ")";
            if (size > 0) {
                title = title + SpyWriter.createMutatorButton("clear", "Clear Intern Cache");
            }
            out.unsafe().trTitle(title, columnCount);
            if (showTimesReused) {
                out.w("<tr><th>Reuse Count</th><th>toString()</th></tr>\n");
            } else {
                out.w("<tr><th>toString()</th></tr>\n");
            }
            if (cache != null) {
                SoftReference[] values = null;
                WeakHashMap<BSimple, SoftReference<BSimple>> weakHashMap = cache;
                synchronized (weakHashMap) {
                    SoftReference[] temp;
                    values = temp = cache.values().toArray((SoftReference[])Array.newInstance(SoftReference.class, cache.size()));
                }
                if (values != null) {
                    for (int i = 0; i < values.length; ++i) {
                        SoftReference ref = values[i];
                        BValue val = null;
                        if (ref != null) {
                            val = (BValue)ref.get();
                        }
                        if (val == null) continue;
                        if (showTimesReused) {
                            Integer reuseCount = ((SimpleType)type).counterMap.get(val);
                            String count = "0";
                            if (reuseCount != null) {
                                count = "" + reuseCount;
                            }
                            out.tr(count, val.toString());
                            continue;
                        }
                        out.tr(val.toString());
                    }
                }
            }
            out.endTable();
        }
    }

    public class Page
    extends SpyDir {
        @Override
        public Spy find(String name) {
            return new CachePage(BTypeSpec.make(EscUtil.slot.unescape(name)));
        }

        @Override
        public void write(SpyWriter out) throws Exception {
            out.startTable(true);
            String title = "Loaded Types";
            if (SimpleType.internDebug) {
                title = title + " (Max Intern Ticks = " + SimpleType.maxInternTicks + ")";
                if (SimpleType.maxCacheSize != Integer.MAX_VALUE) {
                    title = title + " - Intern Max Cache Size = " + SimpleType.maxCacheSize;
                }
            }
            out.trTitle(title, 4);
            for (Type type : SchemaManager.this.types) {
                if (type == null) continue;
                WeakHashMap<BSimple, SoftReference<BSimple>> cache = null;
                if (type instanceof SimpleType) {
                    cache = ((SimpleType)type).internMap;
                }
                out.tr().td(type.getId()).td(type.getModule().getModuleName()).td(type.getTypeName()).td().w(this.hyperlink(out, type, cache)).endTd().endTr();
            }
            out.endTable();
        }

        String hyperlink(SpyWriter out, Type type, WeakHashMap<BSimple, SoftReference<BSimple>> cache) {
            if (cache != null && !cache.isEmpty()) {
                String desc = "Intern Size = " + cache.size() + " (Reuse count = " + ((SimpleType)type).reuseCounter + ")";
                BTypeSpec typeSpec = type.getTypeSpec();
                try {
                    return out.createLink(EscUtil.slot.escape(typeSpec.encodeToString()), desc);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else if (type instanceof SimpleType && !((SimpleType)type).interningEnabled()) {
                return "Interning disabled";
            }
            return "";
        }
    }
}

