/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.sys.schema;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.baja.nre.util.TextUtil;

class MethodMap {
    static final Class<?>[] noParams = new Class[0];
    static final Class<?> wildcard = MethodMap.class;
    private Map<String, Object> map;
    private Class<?>[] oneParam = new Class[1];

    MethodMap(Class<?> cls) {
        Method[] methods = cls.getMethods();
        int len = methods.length;
        this.map = new HashMap<String, Object>(len * 3);
        for (int i = 0; i < len; ++i) {
            Method m = methods[i];
            String name = m.getName();
            Object dup = this.map.get(name);
            if (dup == null) {
                this.map.put(name, m);
                continue;
            }
            if (dup instanceof Method) {
                ArrayList<Method> list = new ArrayList<Method>(5);
                list.add((Method)dup);
                list.add(m);
                this.map.put(name, list);
                continue;
            }
            ((List)dup).add(m);
        }
    }

    Method getMethod(String name, Class<?> param) {
        this.oneParam[0] = param;
        return this.getMethod(name, this.oneParam);
    }

    Method getMethod(String name, Class<?>[] params) {
        Object x = this.map.get(name);
        if (x != null) {
            if (x instanceof Method) {
                Method m = (Method)x;
                if (this.isMatch(m, params)) {
                    return m;
                }
            } else {
                List list = (List)x;
                for (int i = 0; i < list.size(); ++i) {
                    Method m = (Method)list.get(i);
                    if (!this.isMatch(m, params)) continue;
                    return m;
                }
            }
        }
        return null;
    }

    boolean isMatch(Method m, Class<?>[] params) {
        Class<?>[] actual = m.getParameterTypes();
        if (actual.length != params.length) {
            return false;
        }
        for (int i = 0; i < actual.length; ++i) {
            Class<?> expected = params[i];
            if (expected == wildcard || expected == actual[i]) continue;
            return false;
        }
        return true;
    }

    String toString(Class<?>[] params) {
        StringBuilder s = new StringBuilder();
        s.append('(');
        for (int i = 0; i < params.length; ++i) {
            if (i > 0) {
                s.append(',');
            }
            s.append(TextUtil.getClassName(params[i]));
        }
        s.append(')');
        return s.toString();
    }
}

