/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.sys.schema;

import com.tridium.sys.Nre;
import com.tridium.sys.module.ModuleClassLoader;
import com.tridium.sys.module.NModule;
import com.tridium.sys.schema.ComplexIntrospector;
import com.tridium.sys.schema.EnumIntrospector;
import com.tridium.sys.schema.InterfaceIntrospector;
import com.tridium.sys.schema.NType;
import com.tridium.sys.schema.ObjectIntrospector;
import com.tridium.sys.schema.SchemaManager;
import com.tridium.sys.schema.SimpleIntrospector;
import com.tridium.sys.schema.SingletonIntrospector;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Modifier;
import java.util.logging.Level;
import javax.baja.sys.Action;
import javax.baja.sys.BComplex;
import javax.baja.sys.BFrozenEnum;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.BSingleton;
import javax.baja.sys.Property;
import javax.baja.sys.Topic;
import javax.baja.sys.Type;
import javax.baja.sys.TypeIntrospectionException;

public abstract class Introspector {
    static Class<?> propertyClass = Property.class;
    static Class<?> actionClass = Action.class;
    static Class<?> topicClass = Topic.class;
    Class<?> cls;
    int id;
    boolean isAbstract;
    boolean isFinal;
    NModule module;
    String typeName;
    String facetsPath;

    static Introspector create(int id, Class<?> cls) {
        if (cls.isInterface()) {
            return new InterfaceIntrospector(id, cls);
        }
        Introspector custom = Introspector.getCustomIntrospector(id, cls);
        if (custom != null) {
            return custom;
        }
        if (BComplex.class.isAssignableFrom(cls)) {
            return new ComplexIntrospector(id, cls);
        }
        if (BFrozenEnum.class.isAssignableFrom(cls)) {
            return new EnumIntrospector(id, cls);
        }
        if (BSimple.class.isAssignableFrom(cls)) {
            return new SimpleIntrospector(id, cls);
        }
        if (BSingleton.class.isAssignableFrom(cls)) {
            return new SingletonIntrospector(id, cls);
        }
        return new ObjectIntrospector(id, cls);
    }

    static Introspector getCustomIntrospector(int id, Class<?> cls) {
        try {
            Field field = Introspector.getField("INTROSPECTOR", cls);
            if (field == null) {
                return null;
            }
            if (!Class.class.isAssignableFrom(field.getType())) {
                return null;
            }
            Class iclass = (Class)field.get(null);
            if (!Introspector.class.isAssignableFrom(iclass)) {
                return null;
            }
            Constructor ctor = iclass.getConstructor(Integer.TYPE, Class.class);
            return (Introspector)ctor.newInstance(id, cls);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    static Field getField(String name, Class<?> cls) {
        for (Class<?> declaring = cls; declaring != BObject.class; declaring = declaring.getSuperclass()) {
            Field f = null;
            try {
                f = declaring.getDeclaredField(name);
                f.setAccessible(true);
                return f;
            }
            catch (Exception ex) {
                continue;
            }
        }
        return null;
    }

    protected Introspector(int id, Class<?> cls) {
        this.id = id;
        this.cls = cls;
        this.typeName = NType.getTypeName(cls.getName());
        this.module = this.getModule();
        this.facetsPath = '/' + cls.getName().replace('.', '/') + ".facets";
        this.isAbstract = Modifier.isAbstract(cls.getModifiers());
        this.isFinal = Modifier.isFinal(cls.getModifiers());
    }

    abstract Type introspect() throws Exception;

    BObject getConstantFieldObject(String fieldName) throws Exception {
        try {
            if (this.isAbstract) {
                return null;
            }
            Field field = this.cls.getField(fieldName);
            this.checkPublicStaticFinal(field);
            if (field.getType() != this.cls) {
                throw this.err(fieldName + " field is wrong type");
            }
            BObject value = (BObject)field.get(null);
            if (value == null) {
                throw this.err(fieldName + " field is null; insure getType() comes last");
            }
            return value;
        }
        catch (TypeIntrospectionException e) {
            throw e;
        }
        catch (Exception e) {
            throw this.err("Missing or invalid " + fieldName + " field");
        }
    }

    NModule getModule() {
        return Introspector.getModule(this.cls, this.typeName);
    }

    static NModule getModule(Class<?> cls, String typeName) {
        ClassLoader loader = cls.getClassLoader();
        if (loader instanceof ModuleClassLoader) {
            NModule m = ((ModuleClassLoader)loader).module;
            String className = m.getTypeClassName(typeName);
            if (cls.getEnclosingClass() == null) {
                if (className == null) {
                    throw Introspector.err(cls, "Module does not declare type '" + typeName + "' in 'module.xml'");
                }
                if (!className.equals(cls.getName())) {
                    throw Introspector.err(cls, "Type '" + typeName + "' should be '" + className + "'");
                }
            }
            return m;
        }
        NModule[] mods = Nre.getModuleManager().getModules();
        for (int i = 0; i < mods.length; ++i) {
            String className;
            if (!mods[i].isSystemJar() || (className = mods[i].getTypeClassName(typeName)) == null || !className.equals(cls.getName())) continue;
            return mods[i];
        }
        throw Introspector.err(cls, "Cannot resolve class to module (check 'module.xml')");
    }

    boolean isPublic(Member member) {
        return Modifier.isPublic(member.getModifiers());
    }

    boolean isStatic(Member member) {
        return Modifier.isStatic(member.getModifiers());
    }

    boolean isPublicStaticFinal(Field field) {
        int mods = field.getModifiers();
        return Modifier.isPublic(mods) && Modifier.isStatic(mods) && Modifier.isFinal(mods);
    }

    void checkPublicStaticFinal(Field field) {
        if (!this.isPublicStaticFinal(field)) {
            throw this.err("Field must be public static final", field.getName());
        }
    }

    public TypeIntrospectionException err(String msg) {
        return Introspector.err(this.cls, msg);
    }

    public static TypeIntrospectionException err(Class<?> cls, String msg) {
        return Introspector.err(cls, msg, null);
    }

    public TypeIntrospectionException err(String msg, String name) {
        return Introspector.err(this.cls, msg, name);
    }

    public static TypeIntrospectionException err(Class<?> cls, String msg, String name) {
        String s = name == null ? msg : msg + " (" + name + ")";
        String pre = Introspector.getLogPrefix(cls);
        SchemaManager.log.severe(pre + ": " + s);
        return new TypeIntrospectionException(cls, s);
    }

    protected void log(Level level, String msg, String name) {
        Introspector.log(level, this.cls, msg, name);
    }

    protected static void log(Level level, Class<?> cls, String msg, String name) {
        if (SchemaManager.log.isLoggable(level)) {
            String s = name == null ? msg : msg + " (" + name + ")";
            String pre = Introspector.getLogPrefix(cls);
            SchemaManager.log.log(level, pre + ": " + s);
        }
    }

    private static String getLogPrefix(Class<?> cls) {
        String pre = cls.getName();
        if (cls.getClassLoader() instanceof ModuleClassLoader) {
            NModule m = ((ModuleClassLoader)cls.getClassLoader()).module;
            pre = m.getModuleName() + ":" + pre;
        }
        return pre;
    }
}

