/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.sys.schema;

import com.tridium.asm.Buffer;
import com.tridium.sys.module.AutoClassLoader;
import com.tridium.sys.schema.Compiler;
import com.tridium.sys.schema.ComplexSlotMap;
import com.tridium.sys.schema.ComplexType;
import com.tridium.sys.schema.Introspector;
import com.tridium.sys.schema.MethodMap;
import com.tridium.sys.schema.NAction;
import com.tridium.sys.schema.NProperty;
import com.tridium.sys.schema.NSlot;
import com.tridium.sys.schema.NTopic;
import com.tridium.sys.schema.Utils;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.baja.nre.util.TextUtil;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDouble;
import javax.baja.sys.BFloat;
import javax.baja.sys.BInteger;
import javax.baja.sys.BLong;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Slot;
import javax.baja.sys.Type;

public class ComplexIntrospector
extends Introspector {
    MethodMap methods;
    NSlot[] slots;
    NProperty[] properties;
    NAction[] actions;
    NTopic[] topics;
    ComplexSlotMap slotMap;
    boolean isComponent;
    Map<String, List<Slot>> superSlotsToFix;

    public ComplexIntrospector(int id, Class<?> cls) {
        super(id, cls);
        this.methods = new MethodMap(cls);
        this.isComponent = BComponent.class.isAssignableFrom(cls);
    }

    @Override
    Type introspect() throws Exception {
        this.mapSlots();
        this.generateSlotMapClass();
        return this.makeType();
    }

    protected Type makeType() {
        return new ComplexType(this);
    }

    protected void mapSlots() throws Exception {
        ArrayList<NProperty> slotList = new ArrayList<NProperty>();
        ArrayList<NProperty> propertyList = new ArrayList<NProperty>();
        ArrayList<NAction> actionList = new ArrayList<NAction>();
        ArrayList<NTopic> topicList = new ArrayList<NTopic>();
        Field[] fields = this.resolveFields();
        for (int i = 0; i < fields.length; ++i) {
            Field field = fields[i];
            if (field == null) continue;
            Class<?> type = field.getType();
            NSlot slot = null;
            try {
                if (type == propertyClass) {
                    NProperty prop = this.mapProperty((NProperty)this.getSlotField(field));
                    propertyList.add(prop);
                    slot = prop;
                } else if (type == actionClass) {
                    NAction action = this.mapAction((NAction)this.getSlotField(field));
                    actionList.add(action);
                    slot = action;
                } else if (type == topicClass) {
                    NTopic topic = this.mapTopic((NTopic)this.getSlotField(field));
                    topicList.add(topic);
                    slot = topic;
                }
            }
            catch (Exception e) {
                this.err("" + field);
                throw e;
            }
            if (slot == null) continue;
            slot.index = slotList.size();
            slotList.add((NProperty)slot);
        }
        this.slots = slotList.toArray(new NSlot[0]);
        this.properties = propertyList.toArray(new NProperty[0]);
        this.actions = actionList.toArray(new NAction[0]);
        this.topics = topicList.toArray(new NTopic[0]);
        if (this.superSlotsToFix != null) {
            this.fixSuperSlots();
        }
    }

    protected Field[] resolveFields() {
        ArrayList classes = new ArrayList();
        for (Class c = this.cls; c != BObject.class && c != null; c = c.getSuperclass()) {
            classes.add(c);
        }
        ArrayList<Field> fields = new ArrayList<Field>();
        HashMap<String, Integer> table = new HashMap<String, Integer>();
        for (int i = classes.size() - 1; i >= 0; --i) {
            Field[] declared = ((Class)classes.get(i)).getDeclaredFields();
            for (int j = 0; j < declared.length; ++j) {
                Field f = declared[j];
                Class<?> t = f.getType();
                if (!this.isPublicStaticFinal(f) || t != propertyClass && t != actionClass && t != topicClass) continue;
                Integer dup = (Integer)table.get(f.getName());
                if (dup != null) {
                    int index = dup;
                    this.checkSuperSlotInitialized((Field)fields.get(index));
                    fields.set(index, f);
                    continue;
                }
                table.put(f.getName(), fields.size());
                fields.add(f);
            }
        }
        return fields.toArray(new Field[0]);
    }

    protected Slot getSlotField(Field field) throws Exception {
        NSlot slot = null;
        try {
            slot = (NSlot)field.get(null);
        }
        catch (Exception e) {
            throw this.err("Cannot access slot field \"" + field + "\": " + e);
        }
        if (slot == null) {
            throw this.err("Slot field is null (insure loadType is last)", field.getName());
        }
        slot.name = field.getName();
        slot.displayName = TextUtil.toFriendly((String)slot.name);
        return slot;
    }

    protected NProperty mapProperty(NProperty property) {
        TypeSpec type;
        String name = property.name;
        String capName = TextUtil.capitalize((String)name);
        boolean debug = name.equals("ruleCondition");
        Method g = this.methods.getMethod("get" + capName, MethodMap.noParams);
        if (g == null && (g = this.methods.getMethod("is" + capName, MethodMap.noParams)) != null && g.getReturnType() != Boolean.TYPE) {
            throw this.err("Only boolean properties may support 'is' getter", name);
        }
        if (g == null) {
            throw this.err("No getter for property", name);
        }
        if (g.getParameterTypes().length != 0) {
            throw this.err("Parameters not allowed on getter", name);
        }
        if (debug) {
            System.out.println("### getter return type = " + g.getReturnType());
            Class<?> retCls = g.getReturnType();
            Class<?>[] classes = retCls.getClasses();
            for (int i = 0; i < classes.length; ++i) {
                System.out.println(i + ": " + classes[i].getName());
            }
        }
        if ((type = new TypeSpec(g.getReturnType())).isError()) {
            throw this.err("Unsupported type for property", name);
        }
        if (!this.isComponent && type.isPotentialComponent()) {
            throw this.err("Structs may not contain potential component types", name);
        }
        if (type.isBWrapper()) {
            throw this.err("Use primitive, not BObject wrapper for " + name);
        }
        Method s = this.methods.getMethod("set" + capName, type.cls);
        if (s == null) {
            throw this.err("No setter for property", name);
        }
        if (s.getReturnType() != Void.TYPE) {
            throw this.err("Setter must have void return type", name);
        }
        property.typeClass = type.cls;
        property.typeAccess = type.typeAccess;
        Class desired = null;
        switch (property.typeAccess) {
            case 0: {
                desired = BBoolean.class;
                break;
            }
            case 2: {
                desired = BInteger.class;
                break;
            }
            case 3: {
                desired = BLong.class;
                if (!(property.value instanceof BInteger)) break;
                property.value = BLong.make(((BInteger)property.value).getInt());
                break;
            }
            case 4: {
                desired = BFloat.class;
                if (!(property.value instanceof BInteger)) break;
                property.value = BFloat.make(((BInteger)property.value).getInt());
                break;
            }
            case 5: {
                desired = BDouble.class;
                if (!(property.value instanceof BInteger)) break;
                property.value = BDouble.make(((BInteger)property.value).getInt());
                break;
            }
            case 6: {
                desired = BString.class;
                break;
            }
            case 7: {
                desired = property.typeClass;
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        Class<?> actual = property.value.getClass();
        if (!desired.isAssignableFrom(actual)) {
            throw this.err("Property default value is of wrong type " + actual.getName() + " != " + desired.getName(), name);
        }
        property.init();
        return property;
    }

    protected NTopic mapTopic(NTopic topic) throws Exception {
        String name = topic.name;
        String capName = TextUtil.capitalize((String)name);
        Method method = this.methods.getMethod("fire" + capName, MethodMap.wildcard);
        if (method == null) {
            throw this.err("Missing fire method: fire" + capName, name);
        }
        if (method.getReturnType() != Void.TYPE) {
            throw this.err("Fire method must have void return type", name);
        }
        Class<?>[] params = method.getParameterTypes();
        if (params.length != 1) {
            throw this.err("Fire method must have exactly one parameter", name);
        }
        topic.eventClass = params[0];
        return topic;
    }

    protected NAction mapAction(NAction action) throws Exception {
        Method doMethod;
        String name = action.name;
        String capName = TextUtil.capitalize((String)name);
        Method method = this.methods.getMethod(name, MethodMap.noParams);
        if (method == null) {
            method = this.methods.getMethod(name, MethodMap.wildcard);
        }
        if (method == null) {
            throw this.err("Missing action method", name);
        }
        if (!this.isPublic(method)) {
            throw this.err("Action method must be public", name);
        }
        if (this.isStatic(method)) {
            throw this.err("Action method must be not be static", name);
        }
        Class<?> retType = method.getReturnType();
        if (retType == Void.TYPE) {
            action.returnClass = null;
        } else {
            if (!BValue.class.isAssignableFrom(retType)) {
                throw this.err("Action return type must be BValue", name);
            }
            action.returnClass = retType;
        }
        Class<?>[] params = method.getParameterTypes();
        if (params.length > 1) {
            throw this.err("Action must specify zero or one parameter", name);
        }
        if (params.length == 0) {
            if (action.parameterDefault != null) {
                throw this.err("Action has parameter default, but no parameter", name);
            }
        } else {
            if (action.parameterDefault == null) {
                throw this.err("Action has parameter, but no parameter default", name);
            }
            if (!BValue.class.isAssignableFrom(params[0])) {
                throw this.err("Action parameter type must be BValue", name);
            }
            if (!params[0].isAssignableFrom(action.parameterDefault.getClass())) {
                throw this.err("Action parameter default has invalid type", name);
            }
            action.parameterClass = params[0];
        }
        if ((doMethod = params.length == 0 ? this.methods.getMethod("do" + capName, MethodMap.noParams) : this.methods.getMethod("do" + capName, params[0])) == null) {
            doMethod = params.length == 0 ? this.methods.getMethod("do" + capName, new Class[]{Context.class}) : this.methods.getMethod("do" + capName, new Class[]{params[0], Context.class});
            if (doMethod == null) {
                throw this.err("Missing action do method", "do" + capName);
            }
            action.doTakesContext = true;
        }
        if (!this.isPublic(doMethod)) {
            throw this.err("Do action method must be public", capName);
        }
        if (this.isStatic(doMethod)) {
            throw this.err("Do action method must be not be static", capName);
        }
        if (retType != doMethod.getReturnType()) {
            throw this.err("Action method and do method have mismatched signature", action.name);
        }
        return action;
    }

    protected void checkSuperSlotInitialized(Field f) {
        try {
            NSlot slot = (NSlot)f.get(null);
            if (slot.name == null) {
                List<Slot> list;
                if (this.superSlotsToFix == null) {
                    this.superSlotsToFix = new HashMap<String, List<Slot>>();
                }
                if ((list = this.superSlotsToFix.get(f.getName())) == null) {
                    list = new ArrayList<Slot>();
                    this.superSlotsToFix.put(f.getName(), list);
                }
                list.add(slot);
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    protected void fixSuperSlots() {
        for (String name : this.superSlotsToFix.keySet()) {
            List<Slot> list = this.superSlotsToFix.get(name);
            block1: for (int i = 0; i < list.size(); ++i) {
                NSlot slot = (NSlot)list.get(i);
                for (int j = 0; j < this.slots.length; ++j) {
                    NSlot master = this.slots[j];
                    if (!master.name.equals(name)) continue;
                    slot.copyFrom(master);
                    continue block1;
                }
            }
        }
    }

    protected void generateSlotMapClass() throws Exception {
        String baseName = this.cls.getName().replace('.', '_');
        String dotName = "auto." + baseName;
        String className = "auto/" + baseName;
        String superClass = this.isComponent ? "com/tridium/sys/schema/ComponentSlotMap" : "com/tridium/sys/schema/ComplexSlotMap";
        Buffer buffer = new Compiler(superClass, className, this.cls, this.slots).compile();
        Class<?> slotMapClass = AutoClassLoader.load(this.cls, dotName, buffer);
        this.slotMap = (ComplexSlotMap)slotMapClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
    }

    static class TypeSpec {
        final Class<?> cls;
        final int typeAccess;

        TypeSpec(Class<?> cls) {
            this.cls = cls;
            this.typeAccess = Utils.getTypeAccess(cls);
        }

        boolean isError() {
            return this.typeAccess == -1;
        }

        boolean isBWrapper() {
            String name = this.cls.getName();
            if (name.startsWith("javax.baja.sys.B")) {
                return (name = name.substring(15)).equals("BBoolean") || name.equals("BInteger") || name.equals("BLong") || name.equals("BFloat") || name.equals("BDouble") || name.equals("BString");
            }
            return false;
        }

        boolean isPotentialComponent() {
            return BComponent.class.isAssignableFrom(this.cls) || this.cls == BObject.class || this.cls == BValue.class || this.cls == BComplex.class;
        }

        public String toString() {
            return this.cls.getName();
        }
    }
}

