/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.sys.registry;

import com.tridium.util.graph.Digraph;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.baja.registry.DependencyInfo;
import javax.baja.registry.ModuleInfo;
import javax.baja.sys.Sys;

class TopologicalSort {
    TopologicalSort() {
    }

    public static List<String> getSortedDependents(ModuleInfo info) {
        Digraph<String> graph = new Digraph<String>();
        graph.addVertex(info.getModulePartName());
        for (Dependents d : TopologicalSort.getAllDependents(info)) {
            for (Dependents deps : d.dependents) {
                graph.addEdge(d.modulePartName, deps.modulePartName);
            }
        }
        return graph.topologicalSortList();
    }

    private static Collection<Dependents> getAllDependents(ModuleInfo module) {
        HashMap<String, Dependents> modules = new HashMap<String, Dependents>();
        for (ModuleInfo info : Sys.getRegistry().getModules()) {
            Dependents dep = TopologicalSort.getDep(modules, info);
            for (DependencyInfo depInfo : info.getDependencies()) {
                TopologicalSort.getDep(modules, depInfo).dependents.add(dep);
            }
        }
        HashSet<Dependents> deps = new HashSet<Dependents>();
        TopologicalSort.addDependentModules(deps, modules, TopologicalSort.getDep(modules, module));
        return deps;
    }

    private static void addDependentModules(Collection<Dependents> deps, Map<String, Dependents> modules, Dependents module) {
        Dependents dep = modules.get(module.modulePartName);
        deps.add(dep);
        for (Dependents dependent : dep.dependents) {
            TopologicalSort.addDependentModules(deps, modules, dependent);
        }
    }

    private static Dependents getDep(Map<String, Dependents> modules, String partName) {
        Dependents dep = modules.get(partName);
        if (dep == null) {
            dep = new Dependents(partName);
            modules.put(partName, dep);
        }
        return dep;
    }

    private static Dependents getDep(Map<String, Dependents> modules, ModuleInfo info) {
        return TopologicalSort.getDep(modules, info.getModulePartName());
    }

    private static Dependents getDep(Map<String, Dependents> modules, DependencyInfo info) {
        return TopologicalSort.getDep(modules, info.getModulePartName());
    }

    private static class Dependents {
        private Set<Dependents> dependents = new HashSet<Dependents>();
        private String modulePartName;

        private Dependents(String modulePartName) {
            this.modulePartName = modulePartName;
        }

        public String toString() {
            return this.modulePartName;
        }
    }
}

