/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.sys.registry;

import com.tridium.sys.registry.NAgentInfo;
import com.tridium.sys.registry.NAgentList;
import com.tridium.sys.registry.RegistryDatabase;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.lang.reflect.Modifier;
import javax.baja.agent.AgentInfo;
import javax.baja.agent.AgentList;
import javax.baja.agent.BIAgent;
import javax.baja.nre.platform.RuntimeProfile;
import javax.baja.nre.util.TextUtil;
import javax.baja.registry.RegistryException;
import javax.baja.registry.TypeInfo;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BTypeSpec;
import javax.baja.util.Lexicon;

public class NTypeInfo
implements TypeInfo {
    static final NTypeInfo[] noTypes = new NTypeInfo[0];
    static final NAgentOnInfo[] noAgents = new NAgentOnInfo[0];
    int id;
    BTypeSpec typeSpec;
    int modifiers = 0;
    String className = null;
    boolean isTransientType = false;
    NAgentInfo agentInfo = null;
    NTypeInfo superType = null;
    NTypeInfo[] interfaces = noTypes;
    NAgentOnInfo[] agents = noAgents;
    NTypeInfo[] is = noTypes;
    NTypeInfo[] agentOn = noTypes;
    Lexicon lexicon;
    String friendlyTypeName;
    RuntimeProfile profile;

    public NTypeInfo(int id, BTypeSpec typeSpec, RuntimeProfile profile) {
        this.id = id;
        this.typeSpec = typeSpec;
        this.profile = profile;
    }

    @Override
    public final RuntimeProfile getRuntimeProfile() {
        return this.profile;
    }

    @Override
    public final String getModuleName() {
        return this.typeSpec.getModuleName();
    }

    @Override
    public final String getTypeName() {
        return this.typeSpec.getTypeName();
    }

    @Override
    public final BTypeSpec getTypeSpec() {
        return this.typeSpec;
    }

    @Override
    public final BObject getInstance() {
        return this.typeSpec.getInstance();
    }

    @Override
    public final TypeInfo getSuperType() {
        return this.superType;
    }

    @Override
    public final TypeInfo[] getInterfaces() {
        return (TypeInfo[])this.interfaces.clone();
    }

    @Override
    public final boolean isAbstract() {
        return Modifier.isAbstract(this.modifiers);
    }

    @Override
    public final boolean isFinal() {
        return Modifier.isFinal(this.modifiers);
    }

    @Override
    public final boolean isInterface() {
        return Modifier.isInterface(this.modifiers);
    }

    @Override
    public final boolean isTransient() {
        return this.isTransientType;
    }

    @Override
    public final String getTypeClassName() {
        return this.className;
    }

    @Override
    public final AgentInfo getAgentInfo() {
        if (this.agentInfo == null) {
            if (this.is(BIAgent.TYPE)) {
                this.agentInfo = new NAgentInfo(this);
            } else {
                throw new RegistryException("Type \"" + this + "\" is not baja:Agent");
            }
        }
        return this.agentInfo;
    }

    @Override
    public final AgentList getAgents() {
        NAgentList list = new NAgentList();
        for (int i = this.is.length - 1; i >= 0; --i) {
            NTypeInfo x = this.is[i];
            for (NAgentOnInfo xa : x.agents) {
                list.add(xa.on.getAgentInfo());
            }
        }
        return list;
    }

    @Override
    public final boolean is(TypeInfo typeInfo) {
        for (NTypeInfo isInfo : this.is) {
            if (!((Object)isInfo).equals(typeInfo)) continue;
            return true;
        }
        return false;
    }

    @Override
    public final boolean is(Type type) {
        return this.is(type.getTypeInfo());
    }

    public final int hashCode() {
        return this.toString().hashCode();
    }

    public final boolean equals(Object obj) {
        return obj instanceof NTypeInfo && this.typeSpec.equals(((NTypeInfo)obj).typeSpec);
    }

    @Override
    public final String toString() {
        return this.typeSpec.toString(null);
    }

    @Override
    public Lexicon getLexicon(Context cx) {
        if (cx == null) {
            if (this.lexicon == null || !this.lexicon.language.equals(Sys.getLanguage())) {
                this.lexicon = Lexicon.make(this.getModuleName());
            }
            return this.lexicon;
        }
        return Lexicon.make(this.getModuleName(), cx);
    }

    @Override
    public String getDisplayName(Context cx) {
        String n = this.getLexicon(cx).get(this.getTypeName() + ".displayName");
        if (n != null) {
            return n;
        }
        if (this.friendlyTypeName == null) {
            this.friendlyTypeName = TextUtil.toFriendly((String)this.getTypeName());
        }
        return this.friendlyTypeName;
    }

    @Override
    public BIcon getIcon(Context cx) {
        String ordList = this.getLexicon(cx).get(this.getTypeName() + ".icon");
        if (ordList != null) {
            return BIcon.make(ordList);
        }
        TypeInfo superType = this.getSuperType();
        if (superType != null) {
            return superType.getIcon(cx);
        }
        return null;
    }

    void read(RegistryDatabase db, DataInputStream in) throws Exception {
        this.typeSpec = BTypeSpec.make(in.readUTF());
        this.modifiers = in.readUnsignedShort();
        this.className = in.readUTF();
        this.superType = NTypeInfo.readType(db, in);
        this.interfaces = NTypeInfo.readTypes(db, in);
        this.agents = NTypeInfo.readAgentTypes(db, in);
        this.is = NTypeInfo.readTypes(db, in);
        if (in.readBoolean()) {
            this.agentInfo = new NAgentInfo(this);
            this.agentInfo.read(db, in);
        }
        this.profile = RuntimeProfile.valueOf((String)in.readUTF());
    }

    void write(RegistryDatabase db, DataOutputStream out) throws Exception {
        out.writeUTF(this.typeSpec.encodeToString());
        out.writeShort(this.modifiers);
        out.writeUTF(this.className);
        NTypeInfo.writeType(db, out, this.superType);
        NTypeInfo.writeTypes(db, out, this.interfaces);
        NTypeInfo.writeAgentTypes(db, out, this.agents);
        NTypeInfo.writeTypes(db, out, this.is);
        if (this.agentInfo == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            this.agentInfo.write(db, out);
        }
        out.writeUTF(this.profile.name());
    }

    static NTypeInfo readType(RegistryDatabase db, DataInputStream in) throws Exception {
        short id = in.readShort();
        if (id < 0) {
            return null;
        }
        return db.types[id];
    }

    static void writeType(RegistryDatabase db, DataOutputStream out, NTypeInfo type) throws Exception {
        if (type == null) {
            out.writeShort(-1);
        } else {
            out.writeShort(type.id);
        }
    }

    static NTypeInfo[] readTypes(RegistryDatabase db, DataInputStream in) throws Exception {
        int len = in.readUnsignedShort();
        if (len == 0) {
            return noTypes;
        }
        NTypeInfo[] types = new NTypeInfo[len];
        for (int i = 0; i < len; ++i) {
            types[i] = db.types[in.readShort()];
        }
        return types;
    }

    static void writeTypes(RegistryDatabase db, DataOutputStream out, NTypeInfo[] types) throws Exception {
        int len = types.length;
        out.writeShort(len);
        for (NTypeInfo type : types) {
            out.writeShort(type.id);
        }
    }

    static NAgentOnInfo[] readAgentTypes(RegistryDatabase db, DataInputStream in) throws Exception {
        int len = in.readUnsignedShort();
        if (len == 0) {
            return noAgents;
        }
        NAgentOnInfo[] types = new NAgentOnInfo[len];
        for (int i = 0; i < len; ++i) {
            types[i] = new NAgentOnInfo();
            types[i].on = db.types[in.readShort()];
            if (!in.readBoolean()) continue;
            types[i].match = in.readUTF();
        }
        return types;
    }

    static void writeAgentTypes(RegistryDatabase db, DataOutputStream out, NAgentOnInfo[] types) throws Exception {
        int len = types.length;
        out.writeShort(len);
        for (NAgentOnInfo type : types) {
            out.writeShort(type.on.id);
            out.writeBoolean(!type.match.isEmpty());
            if (type.match.isEmpty()) continue;
            out.writeUTF(type.match);
        }
    }

    static class NAgentOnInfo {
        NTypeInfo on;
        String match;

        public NAgentOnInfo() {
        }

        public NAgentOnInfo(NTypeInfo on, String match) {
            this.on = on;
            this.match = match;
        }

        public boolean hasMatch() {
            return this.match != null && !this.match.isEmpty();
        }
    }
}

