/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.sys.registry;

import com.tridium.sys.Nre;
import com.tridium.sys.module.DefaultModulesFileManager;
import com.tridium.sys.module.ManagedModuleFile;
import com.tridium.sys.registry.Builder;
import com.tridium.sys.registry.Debug;
import com.tridium.sys.registry.NModuleInfo;
import com.tridium.sys.registry.NTypeInfo;
import com.tridium.sys.registry.RegistryChecksum;
import com.tridium.sys.registry.RegistryDatabase;
import com.tridium.util.MapUtil;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.PrintWriter;
import java.security.AccessController;
import java.util.Arrays;
import java.util.Date;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.baja.agent.AgentInfo;
import javax.baja.agent.AgentList;
import javax.baja.agent.BIAgent;
import javax.baja.io.ValueDocDecoder;
import javax.baja.nre.platform.RuntimeProfile;
import javax.baja.registry.LexiconInfo;
import javax.baja.registry.ModuleInfo;
import javax.baja.registry.Registry;
import javax.baja.registry.RegistryException;
import javax.baja.registry.TypeInfo;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComplex;
import javax.baja.sys.BModule;
import javax.baja.sys.BObject;
import javax.baja.sys.ModuleNotFoundException;
import javax.baja.sys.Type;
import javax.baja.sys.TypeNotFoundException;
import javax.baja.util.BTypeSpec;
import javax.baja.util.Version;
import javax.baja.xml.XException;

public final class NRegistry
implements Registry {
    public static final Logger log = Logger.getLogger("sys.registry");
    public static boolean forceRebuild = false;
    RegistryDatabase db;
    public final ValueDocDecoder.ITypeResolver typeResolver = new NRegistryTypeResolver();
    private String[] invalidModules = null;

    @Override
    public BAbsTime getLastBuildTime() {
        return AccessController.doPrivileged(() -> BAbsTime.make(this.dbFile().lastModified()));
    }

    @Override
    public ModuleInfo[] getModules() {
        return this.db().getModules();
    }

    @Override
    public ModuleInfo moduleForDependency(String modulePartName) {
        return this.db().moduleForDependency(modulePartName);
    }

    @Override
    public ModuleInfo getModule(String moduleName, RuntimeProfile profile) {
        return this.db().getModule(moduleName, profile);
    }

    @Override
    public ModuleInfo[] getModules(String moduleName) {
        return this.db().getModules(moduleName);
    }

    @Override
    public TypeInfo[] getTypes() {
        return this.db().getTypes();
    }

    @Override
    public TypeInfo[] getTypes(TypeInfo t) {
        return this.db().getTypes(t, false);
    }

    @Override
    public TypeInfo[] getConcreteTypes(TypeInfo t) {
        return this.db().getTypes(t, true);
    }

    @Override
    public TypeInfo getType(String typeSpec) {
        return this.db().getType(typeSpec);
    }

    @Override
    public String[] getDefs() {
        return this.db().getDefs();
    }

    @Override
    public String[] getDefs(String name) {
        return this.db().getDefs(name);
    }

    @Override
    public String getDef(String name) {
        return this.db().getDef(name, null);
    }

    @Override
    public String getDef(String name, String fallback) {
        return this.db().getDef(name, fallback);
    }

    @Override
    public AgentList getAgents(TypeInfo t) {
        return this.db().getAgents(t);
    }

    @Override
    public AgentList getSpecificAgents(TypeInfo t) {
        return this.db().getSpecificAgents(t);
    }

    @Override
    public boolean isAgent(TypeInfo a, TypeInfo t) {
        return this.db().isAgent(a, t);
    }

    @Override
    public boolean isSpecificAgent(TypeInfo a, TypeInfo t) {
        return this.db().isSpecificAgent(a, t);
    }

    @Override
    public TypeInfo[] getAdapters(TypeInfo from, TypeInfo to) {
        return this.db().getAdapters(from, to);
    }

    @Override
    public String[] getFileExtensions() {
        return this.db().getFileExtensions();
    }

    @Override
    public String[] getFileExtensions(TypeInfo t) {
        return this.db().getFileExtensions(t);
    }

    @Override
    public TypeInfo getFileTypeForExtension(String ext) {
        return this.db().getFileTypeForExtension(ext);
    }

    @Override
    public String[] getOrdSchemes() {
        return this.db().getOrdSchemes();
    }

    @Override
    public TypeInfo getOrdScheme(String schemeId) {
        return this.db().getOrdScheme(schemeId);
    }

    @Override
    public TypeInfo findOrdScheme(String schemeId) {
        return this.db().findOrdScheme(schemeId);
    }

    @Override
    public boolean isOrdScheme(String schemeId) {
        return this.db().isOrdScheme(schemeId);
    }

    @Override
    public LexiconInfo[] getLexicons() {
        return this.db().getLexicons();
    }

    @Override
    public LexiconInfo[] getLexicons(String moduleName) {
        return this.db().getLexicons(moduleName);
    }

    @Override
    public LexiconInfo[] getLexicons(String moduleName, String language) {
        return this.db().getLexicons(moduleName, language);
    }

    @Override
    public LexiconInfo getLexicon(String moduleName, String language, String container, String containerProfile) {
        return this.db().getLexicon(moduleName, language, container, containerProfile);
    }

    @Override
    public Type synthesizeType(BTypeSpec typeSpec, String className, TypeInfo superType, TypeInfo[] interfaceTypes, AgentInfo[] agentOnTypes, boolean isAbstract, boolean isFinal) {
        return this.db().synthesizeType(typeSpec, className, superType, interfaceTypes, agentOnTypes, isAbstract, isFinal);
    }

    @Override
    public BModule synthesizeModule(String moduleName, Version bajaVersion, String vendor, Version vendorVersion, String description) {
        return this.db().synthesizeModule(moduleName, bajaVersion, vendor, vendorVersion, description);
    }

    RegistryDatabase db() {
        if (this.db == null) {
            try {
                long t1 = System.currentTimeMillis();
                this.db = new RegistryDatabase();
                InputStream in = Nre.bootEnv.isRemote() ? Nre.bootEnv.read(this.dbRemote()) : new BufferedInputStream(new FileInputStream(this.dbFile()));
                this.db.read(in);
                long t2 = System.currentTimeMillis();
                log.info("Loaded [" + (t2 - t1) + "ms]");
            }
            catch (Throwable e) {
                throw new RegistryException("Cannot load registry", e);
            }
        }
        return this.db;
    }

    public boolean isRegistryUpToDate() {
        if (Nre.bootEnv.isRemote()) {
            return true;
        }
        if (forceRebuild) {
            log.info("Force rebuild");
            return false;
        }
        if (this.dummyFile().exists()) {
            log.info("*** No Rebuild ***");
            return true;
        }
        long t1 = System.currentTimeMillis();
        try {
            File file = this.chkFile();
            if (!file.exists()) {
                throw new RegistryException("Missing \"" + file + '\"');
            }
            RegistryChecksum chk = new RegistryChecksum();
            chk.read(file);
            if (!MapUtil.compare(chk.enabledRuntimeProfiles, Arrays.stream(Nre.getSupportedProfiles()).sorted().collect(Collectors.toList())).matchesExactly()) {
                throw new RegistryException("Enabled runtime profiles have changed");
            }
            DefaultModulesFileManager.ModuleFileSet moduleFiles = DefaultModulesFileManager.get().get().init(false);
            for (ManagedModuleFile jar : moduleFiles) {
                if (!Nre.supportsProfile(jar.getRuntimeProfile())) continue;
                chk.checkUpToDate(jar.getFile());
            }
            if (!chk.modules.isEmpty()) {
                String name = ((RegistryChecksum.ModuleSnapshot)chk.modules.values().toArray()[0]).name;
                throw new RegistryException("Module removed \"" + name + '\"');
            }
        }
        catch (RegistryException e) {
            log.info("Out-of-date: " + e.getMessage());
            return false;
        }
        catch (Throwable e) {
            log.log(Level.SEVERE, "Out-of-date", e);
            return false;
        }
        long t2 = System.currentTimeMillis();
        log.info("Up-to-date [" + (t2 - t1) + "ms]");
        return true;
    }

    public void rebuild() {
        try {
            log.info("Rebuilding registry...");
            long t1 = System.currentTimeMillis();
            File dummy = this.dummyFile();
            boolean dummyExists = dummy.exists();
            int numTypes = Builder.rebuild(this);
            for (TypeInfo typeInfo : this.getConcreteTypes(BObject.TYPE.getTypeInfo())) {
                NTypeInfo type = (NTypeInfo)typeInfo;
                if (type.agentOn.length <= 0 || type.is(BIAgent.TYPE)) continue;
                log.warning(type.getTypeSpec() + " declares itself as an agent, but does not implement BIAgent.");
            }
            if (dummyExists) {
                PrintWriter out = new PrintWriter(new FileWriter(dummy));
                out.write("no-rebuild.dummy " + new Date());
                out.close();
            }
            long t2 = System.currentTimeMillis();
            log.info("Rebuilt: " + numTypes + " types [" + (t2 - t1) + "ms]");
        }
        catch (Throwable e) {
            log.log(Level.SEVERE, "Cannot rebuild", e);
        }
    }

    public void syncModules() {
        if (Nre.bootEnv.isRemote()) {
            return;
        }
        if (this.db == null) {
            throw new IllegalStateException("Can't syncModules() on uninitialized registry");
        }
        Builder.syncFiles(this);
    }

    public void loadModule(String moduleName) throws Exception {
        for (ModuleInfo info : this.getModules(moduleName)) {
            this.loadModule(moduleName, info.getRuntimeProfile());
        }
    }

    public void loadModule(String moduleName, RuntimeProfile profile) throws Exception {
        if (Nre.bootEnv.isRemote()) {
            return;
        }
        if (this.db == null) {
            throw new IllegalStateException(String.format("Can't loadModule(%s) on uninitialized registry", moduleName));
        }
        Map<RuntimeProfile, NModuleInfo> map = this.db.moduleMapByModuleName.get(moduleName);
        if (map != null && map.containsKey(profile)) {
            Builder.loadModule(this, map.get(profile));
        }
    }

    public void unloadModule(String moduleName) throws Exception {
        for (ModuleInfo info : this.getModules(moduleName)) {
            this.unloadModule(moduleName, info.getRuntimeProfile());
        }
    }

    public void unloadModule(String moduleName, RuntimeProfile profile) throws Exception {
        if (Nre.bootEnv.isRemote()) {
            return;
        }
        if (this.db == null) {
            throw new IllegalStateException(String.format("Can't unloadModule(%s) on uninitialized registry", moduleName));
        }
        Map<RuntimeProfile, NModuleInfo> map = this.db.moduleMapByModuleName.get(moduleName);
        if (map != null && map.containsKey(profile)) {
            Builder.unloadModule(this, map.get(profile));
        }
    }

    public void reloadModule(String moduleName) throws Exception {
        for (ModuleInfo info : this.getModules(moduleName)) {
            this.reloadModule(moduleName, info.getRuntimeProfile());
        }
    }

    public void reloadModule(String moduleName, RuntimeProfile profile) throws Exception {
        if (Nre.bootEnv.isRemote()) {
            return;
        }
        if (this.db == null) {
            throw new IllegalStateException(String.format("Can't reloadModule(%s) on uninitialized registry", moduleName));
        }
        Builder.reloadModule(this, moduleName, profile);
    }

    public boolean postInit() {
        boolean rebuilt = false;
        if (!this.isRegistryUpToDate()) {
            this.rebuild();
            rebuilt = true;
        }
        try {
            this.checkNSedona();
            this.invalidModules = new String[0];
        }
        catch (RegistryException e) {
            ((NRegistryTypeResolver)this.typeResolver).registryException = new RegistryException(e.getMessage());
            this.invalidModules = new String[]{((NRegistryTypeResolver)this.typeResolver).invalidModuleName};
        }
        Nre.spySysManagers.add("registryManager", new Debug.SummaryPage());
        return rebuilt;
    }

    public final String[] getInvalidModules() {
        return this.invalidModules;
    }

    private void checkNSedona() throws RegistryException {
        try {
            ((NRegistryTypeResolver)this.typeResolver).invalidModuleName = "nsedona";
            for (ModuleInfo nsedona : this.getModules("nsedona")) {
                String err = "nsedona " + nsedona.getVendorVersion() + " not supported: ";
                if (nsedona.getVendorVersion().compareTo(new Version("1.1")) < 0) {
                    throw new RegistryException(err + "baja " + this.getModule("baja", RuntimeProfile.rt).getVendorVersion());
                }
                try {
                    this.getType("nsedona:DaspTunnel");
                }
                catch (TypeNotFoundException e) {
                    throw new RegistryException(err + "[0]");
                }
                try {
                    this.getType("nsedona:SedonaNetwork");
                    throw new RegistryException(err + "[1]");
                }
                catch (TypeNotFoundException typeNotFoundException) {
                }
            }
        }
        catch (ModuleNotFoundException moduleNotFoundException) {
            // empty catch block
        }
        for (TypeInfo type : this.getTypes()) {
            String cname = type.getTypeClassName();
            if (!cname.startsWith("javax.baja.sedona.driver.") && !cname.startsWith("com.tridium.sedona.")) continue;
            ((NRegistryTypeResolver)this.typeResolver).invalidModuleName = type.getModuleName();
            throw new RegistryException(type + ": [2]");
        }
    }

    public File dir() {
        return new File(Nre.niagaraUserHome, "registry");
    }

    public File dbFile() {
        return new File(this.dir(), "registry.db");
    }

    public String dbRemote() {
        return "/registry/registry.db";
    }

    public File chkFile() {
        return new File(this.dir(), "registry.chk");
    }

    public File dummyFile() {
        return new File(this.dir(), "no-rebuild.dummy");
    }

    private static class NRegistryTypeResolver
    extends ValueDocDecoder.BogTypeResolver {
        String invalidModuleName = null;
        RegistryException registryException = null;

        private NRegistryTypeResolver() {
        }

        @Override
        public final BModule loadModule(ValueDocDecoder decoder, BComplex parent, String propName, String moduleStr, String typeStr) {
            if (this.registryException != null && this.invalidModuleName != null) {
                String name;
                try {
                    int equals = moduleStr.indexOf(61);
                    name = moduleStr.substring(equals + 1).trim();
                }
                catch (Exception e) {
                    super.loadModule(decoder, parent, propName, moduleStr, typeStr);
                    throw new XException("Invalid module attribute '" + moduleStr + '\'', ((ValueDocDecoder.BogDecoderPlugin)decoder.getPlugin()).getXmlParser());
                }
                if (name.equals(this.invalidModuleName)) {
                    throw this.registryException;
                }
            }
            return super.loadModule(decoder, parent, propName, moduleStr, typeStr);
        }
    }
}

