/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.sys.registry;

import com.tridium.sys.Nre;
import com.tridium.sys.registry.NAdapterInfo;
import com.tridium.sys.registry.NModuleInfo;
import com.tridium.sys.registry.NRegistry;
import com.tridium.sys.registry.NTypeInfo;
import java.io.StringWriter;
import java.lang.invoke.LambdaMetafactory;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Logger;
import javax.baja.agent.AgentInfo;
import javax.baja.io.HtmlWriter;
import javax.baja.nre.util.Array;
import javax.baja.nre.util.SortUtil;
import javax.baja.registry.ModuleInfo;
import javax.baja.registry.RegistryException;
import javax.baja.registry.TypeInfo;
import javax.baja.spy.Spy;
import javax.baja.spy.SpyDir;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.Sys;

public class Debug {
    public static final Logger log = Logger.getLogger("sys.registry");

    public static class AdaptersPage
    extends Spy {
        @Override
        public void write(SpyWriter out) throws Exception {
            String base = "../";
            NAdapterInfo[] adpaters = AccessController.doPrivileged((PrivilegedAction<NRegistry>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$write$0(), ()Lcom/tridium/sys/registry/NRegistry;)()).db().adapters;
            out.startTable(true);
            out.trTitle("Installed Adapters", 3);
            out.w("<tr>").th("Type").th("From").th("To").w("</tr>\n");
            for (NAdapterInfo a : adpaters) {
                out.tr().td().a(base + "types/" + a.type, a.type).endTd().td().a(base + "types/" + a.from, a.from).endTd().td().a(base + "types/" + a.to, a.to).endTd().endTr();
            }
            out.endTable();
        }

        private static /* synthetic */ NRegistry lambda$write$0() {
            return Nre.getRegistryManager();
        }
    }

    public static class OrdSchemesPage
    extends Spy {
        @Override
        public void write(SpyWriter out) throws Exception {
            String base = "../";
            String[] schemes = Sys.getRegistry().getOrdSchemes();
            out.startTable(true);
            out.trTitle("Installed Ord Schemes", 2);
            for (String scheme : schemes) {
                TypeInfo s = Sys.getRegistry().getOrdScheme(scheme);
                out.tr().td(scheme).td().a(base + "types/" + s, s).endTd().endTr();
            }
            out.endTable();
        }
    }

    public static class FileExtsPage
    extends Spy {
        @Override
        public void write(SpyWriter out) throws Exception {
            String base = "../";
            String[] exts = Sys.getRegistry().getFileExtensions();
            out.startTable(true);
            out.trTitle("Installed File Extensions", 2);
            for (String ext : exts) {
                TypeInfo s = Sys.getRegistry().getFileTypeForExtension(ext);
                out.tr().td(ext).td().a(base + "types/" + s, s).endTd().endTr();
            }
            out.endTable();
        }
    }

    public static class DefsPage
    extends Spy {
        @Override
        public void write(SpyWriter out) throws Exception {
            Object[] names = Sys.getRegistry().getDefs();
            SortUtil.sort((Object[])names, (Object[])names);
            out.startTable(true);
            out.trTitle("Defs [" + names.length + "]", 2);
            for (Object name : names) {
                String value = Sys.getRegistry().getDef((String)name);
                out.tr(name, value);
            }
            out.endTable();
        }
    }

    public static class TypePage
    extends Spy {
        String typeSpec;

        TypePage(String typeSpec) {
            this.typeSpec = typeSpec;
        }

        @Override
        public void write(SpyWriter out) throws Exception {
            NTypeInfo[] on;
            NTypeInfo.NAgentOnInfo[] agents;
            NTypeInfo t = (NTypeInfo)Sys.getRegistry().getType(this.typeSpec);
            String base = "../";
            out.startTable(true);
            StringWriter sw = new StringWriter();
            ModuleInfo module = Sys.getRegistry().getModule(t.getModuleName(), t.getRuntimeProfile());
            new HtmlWriter(sw).w("Type ").a("../../modules/" + module.getModulePartName(), t.getModuleName()).w(":").w(t.getTypeName());
            out.unsafe().trTitle(sw, 2);
            out.tr("isAbstract", t.isAbstract());
            out.tr("isInterface", t.isInterface());
            out.tr().td("superType").td();
            this.writeTypeRef(out, base, t.getSuperType());
            out.endTd().endTr();
            out.tr("runtimeProfile", t.getRuntimeProfile().name());
            TypeInfo[] interfaces = t.getInterfaces();
            if (interfaces.length > 0) {
                out.trTitle("Interfaces", 2);
                for (TypeInfo anInterface : interfaces) {
                    out.w("<tr><td colspan='2'>");
                    this.writeTypeRef(out, base, anInterface);
                    out.w("</td></tr>\n");
                }
            }
            if ((agents = t.agents).length > 0) {
                out.trTitle("Agents", 2);
                for (NTypeInfo.NAgentOnInfo agent : agents) {
                    out.w("<tr><td colspan='2'>");
                    this.writeTypeRef(out, base, agent.on);
                    out.w(" ").safe(agent.match).w("</td></tr>\n");
                }
            }
            if ((on = t.agentOn).length > 0) {
                out.trTitle("Agent On", 2);
                for (NTypeInfo anOn : on) {
                    out.w("<tr><td colspan='2'>");
                    this.writeTypeRef(out, base, anOn);
                    out.w("</td></tr>\n");
                }
            }
            NTypeInfo[] is = t.is;
            out.trTitle("Is Types", 2);
            for (NTypeInfo i1 : is) {
                out.w("<tr><td colspan='2'>");
                this.writeTypeRef(out, base, i1);
                out.w("</td></tr>\n");
            }
            TypeInfo[] st = Sys.getRegistry().getTypes(t);
            Array arr = new Array(TypeInfo.class);
            for (TypeInfo aSt : st) {
                if (t.isInterface()) {
                    if (new Array((Object[])aSt.getInterfaces()).indexOf((Object)t) == -1) continue;
                    arr.add((Object)aSt);
                    continue;
                }
                TypeInfo superType = aSt.getSuperType();
                if (superType == null || !superType.equals(t)) continue;
                arr.add((Object)aSt);
            }
            if (arr.size() > 0) {
                st = (TypeInfo[])arr.trim();
                out.trTitle("Sub Types", 2);
                for (TypeInfo aSt : st) {
                    out.w("<tr><td colspan='2'>");
                    this.writeTypeRef(out, base, aSt);
                    out.w("</td></tr>\n");
                }
            }
            try {
                AgentInfo ai = t.getAgentInfo();
                out.trTitle("AgentInfo", 2);
                out.w("<tr>").td("requiredPermissions").td(ai.getRequiredPermissions()).w("</tr>\n");
                out.w("<tr>").td("appName").td("" + ai.getAppName()).w("</tr>\n");
            }
            catch (RegistryException registryException) {
                // empty catch block
            }
            out.endTable();
        }

        private void writeTypeRef(SpyWriter out, String base, TypeInfo info) {
            if (info == null) {
                out.w("null");
            } else {
                out.a(base + info, info);
            }
        }
    }

    public static class TypesPage
    extends SpyDir {
        @Override
        public Spy find(String name) {
            return new TypePage(name);
        }

        @Override
        public void write(SpyWriter out) throws Exception {
            Object[] types = Sys.getRegistry().getTypes();
            SortUtil.sort((Object[])types);
            out.startTable(true);
            out.trTitle("Installed Types", 1);
            for (Object t : types) {
                out.tr().td().a("../types/" + t, t).endTd().endTr();
            }
            out.endTable();
        }
    }

    public static class ModulePartPage
    extends Spy {
        String modulePartName;

        ModulePartPage(String modulePartName) {
            this.modulePartName = modulePartName;
        }

        @Override
        public void write(SpyWriter out) throws Exception {
            List<TypeInfo> types = Arrays.asList(Sys.getRegistry().moduleForDependency(this.modulePartName).getTypes());
            types.sort((t1, t2) -> t1.toString().compareTo(t2.toString()));
            out.startTable(true);
            out.trTitle("Module \"" + this.modulePartName + "\"", 1);
            for (TypeInfo ti : types) {
                NTypeInfo t = (NTypeInfo)ti;
                out.tr().td().a("../../types/" + t, t).endTd().endTr();
            }
            out.endTable();
        }
    }

    public static class ModulePartsPage
    extends SpyDir {
        @Override
        public Spy find(String name) {
            return new ModulePartPage(name);
        }

        @Override
        public void write(SpyWriter out) throws Exception {
            ModuleInfo[] moduleParts = Sys.getRegistry().getModules();
            out.startTable(true);
            out.trTitle("Installed Modules", 9);
            for (ModuleInfo modulePart : moduleParts) {
                NModuleInfo m = (NModuleInfo)modulePart;
                out.tr().td().a(m.getModulePartName(), m.getModulePartName()).endTd().td(m.getVendor()).td(m.getVendorVersion()).td(m.getDescription()).td(BAbsTime.make(m.getBuildTime())).td(m.hasPalette() ? "palette" : "no palette").td(m.isAutoload() ? "autoload" : "non-autoload").td(m.isReloadable() ? "reloadable" : "non-reloadable").td(m.isWar() ? "WAR" : "non-WAR").endTr();
            }
            out.endTable();
        }
    }

    public static class SummaryPage
    extends SpyDir {
        SummaryPage() {
            this.add("modules", new ModulePartsPage());
            this.add("types", new TypesPage());
            this.add("defs", new DefsPage());
            this.add("fileExts", new FileExtsPage());
            this.add("ordSchemes", new OrdSchemesPage());
            this.add("adapters", new AdaptersPage());
        }

        @Override
        public void write(SpyWriter out) throws Exception {
            out.startTable(true);
            out.trTitle("Registry", 1);
            out.tr().td().a("modules", "Installed Modules").endTd().endTr();
            out.tr().td().a("types", "Installed Types").endTd().endTr();
            out.tr().td().a("defs", "Registry Definitions").endTd().endTr();
            out.tr().td().a("fileExts", "Installed File Extensions").endTd().endTr();
            out.tr().td().a("ordSchemes", "Installed Ord Schemes").endTd().endTr();
            out.tr().td().a("adapters", "Installed Adapters").endTd().endTr();
            out.endTable();
        }
    }
}

