/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.sys.module;

import com.tridium.asm.Buffer;
import com.tridium.sys.module.ModuleClassLoader;
import com.tridium.sys.module.NModule;
import com.tridium.sys.schema.SyntheticCompiler;
import javax.baja.registry.TypeInfo;
import javax.baja.sys.Sys;
import javax.baja.util.BTypeSpec;

public class SyntheticModuleClassLoader
extends ModuleClassLoader {
    public SyntheticModuleClassLoader(NModule module) {
        super(module);
    }

    @Override
    public Class<?> loadAutoClass(String classname, Buffer buffer) throws ClassNotFoundException {
        return super.loadAutoClass(classname, buffer);
    }

    public Class<?> ndefineClass(String name, byte[] bytes, int off, int len) {
        return this.defineClass(name, bytes, off, len, this.codeSource);
    }

    @Override
    protected Class<?> nfind(String name, boolean resolve) {
        if (name.startsWith("auto.")) {
            try {
                return super.nfind(name, resolve);
            }
            catch (NoClassDefFoundError ncdfe) {
                if (this.module.depends != null) {
                    for (int i = 0; i < this.module.depends.length; ++i) {
                        Class<?> cls;
                        NModule d = this.module.depends[i].resolution;
                        if (!d.isSynthetic() || d.isSystemJar || (cls = d.classLoader.nload(name, resolve)) == null) continue;
                        return cls;
                    }
                }
                throw ncdfe;
            }
        }
        try {
            return this.getParent().loadClass(name);
        }
        catch (ClassNotFoundException ncdfe) {
            if (this.module.getTypeClassName(name.substring(name.lastIndexOf(46) + 2)) != null) {
                BTypeSpec typeSpec = BTypeSpec.make(this.module.getModuleName(), name.substring(name.lastIndexOf(46) + 2));
                TypeInfo typeInfo = Sys.getRegistry().getType(typeSpec.toString());
                TypeInfo[] interfaces = typeInfo.getInterfaces();
                boolean isAbstract = typeInfo.isAbstract();
                boolean isFinal = typeInfo.isFinal();
                TypeInfo superType = typeInfo.getSuperType();
                Buffer buffer = SyntheticCompiler.compile(typeSpec, superType, interfaces, isAbstract, isFinal, false);
                SyntheticModuleClassLoader.addClassToSpy(this.module.moduleName, buffer.count);
                Class<?> synthClass = this.defineClass(name, buffer.bytes, 0, buffer.count, this.codeSource);
                try {
                    Class.forName(synthClass.getName(), true, synthClass.getClassLoader());
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
                return synthClass;
            }
            if (this.module.depends != null) {
                for (int i = 0; i < this.module.depends.length; ++i) {
                    Class<?> cls;
                    NModule d = this.module.depends[i].resolution;
                    if (d.isSystemJar || (cls = d.classLoader.nload(name, resolve)) == null) continue;
                    return cls;
                }
            }
            return null;
        }
    }
}

