/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.sys.module;

import javax.baja.nre.platform.RuntimeProfile;
import javax.baja.xml.XElem;

public enum AxModuleContent {
    runtime,
    ui,
    doc;


    public static AxModuleContent forModuleManifest(XElem moduleElem) {
        if (moduleElem.get("name").equals("baja")) {
            return runtime;
        }
        String archiveInstall = moduleElem.get("archiveInstall", null);
        if (archiveInstall != null) {
            return AxModuleContent.valueOf(archiveInstall);
        }
        AxModuleContent highestFromDirs = null;
        boolean allDocContent = true;
        XElem dirs = moduleElem.elem("dirs");
        if (dirs == null || dirs.elems("dir").length == 0) {
            return runtime;
        }
        for (XElem dir : dirs.elems("dir")) {
            AxModuleContent dirContent = AxModuleContent.valueOf(dir.get("install", "ui"));
            if (dirContent == doc) continue;
            allDocContent = false;
            if (highestFromDirs != null && dirContent.compareTo(highestFromDirs) <= 0) continue;
            highestFromDirs = dirContent;
            if (dirContent == ui) break;
        }
        return allDocContent ? doc : highestFromDirs;
    }

    public RuntimeProfile getEquivalentRuntimeProfile() {
        switch (this) {
            case runtime: {
                return RuntimeProfile.rt;
            }
            case ui: {
                return RuntimeProfile.se;
            }
            case doc: {
                return RuntimeProfile.doc;
            }
        }
        throw new IllegalStateException();
    }
}

