/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.sys.module;

import com.tridium.asm.Buffer;
import com.tridium.sys.module.ModuleClassLoader;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.ProtectionDomain;

public class AutoClassLoader {
    public static final SysClassLoader sysClassLoader = new SysClassLoader();

    public static Class<?> load(Class<?> sourceClass, String dotName, Buffer buffer) throws ClassNotFoundException {
        if (!dotName.startsWith("auto.")) {
            throw new IllegalStateException("class name must begin with auto");
        }
        ClassLoader loader = sourceClass.getClassLoader();
        if (loader instanceof ModuleClassLoader) {
            return ((ModuleClassLoader)loader).loadAutoClass(dotName, buffer);
        }
        try {
            return AccessController.doPrivileged(() -> sysClassLoader.loadAutoClass(dotName, buffer, sourceClass.getProtectionDomain()));
        }
        catch (PrivilegedActionException e) {
            Exception innerEx = e.getException();
            if (innerEx instanceof ClassNotFoundException) {
                throw (ClassNotFoundException)innerEx;
            }
            return null;
        }
    }

    static class SysClassLoader
    extends ClassLoader {
        private Buffer buffer;
        private ProtectionDomain domain;

        SysClassLoader() {
            super(SysClassLoader.class.getClassLoader());
        }

        Class<?> loadAutoClass(String name, Buffer buffer, ProtectionDomain domain) throws ClassNotFoundException {
            this.buffer = buffer;
            this.domain = domain;
            return this.loadClass(name);
        }

        @Override
        public Class<?> loadClass(String name, boolean resolveFlag) throws ClassNotFoundException {
            if (!name.startsWith("auto.")) {
                return super.loadClass(name, resolveFlag);
            }
            Class<?> c = this.defineClass(name, this.buffer.bytes, 0, this.buffer.count, this.domain);
            if (resolveFlag) {
                this.resolveClass(c);
            }
            this.buffer = null;
            return c;
        }
    }
}

