/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.sys.license.dom;

import com.tridium.sys.license.LicenseUtil;
import com.tridium.sys.license.dom.Feature;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Objects;
import java.util.Optional;
import javax.baja.file.BIFile;
import javax.baja.nre.util.Array;
import javax.baja.nre.util.TextUtil;
import javax.baja.sys.Clock;
import javax.baja.util.Version;
import javax.baja.xml.XContent;
import javax.baja.xml.XElem;
import javax.baja.xml.XException;
import javax.baja.xml.XParser;
import javax.baja.xml.XText;
import javax.baja.xml.XWriter;

public class VendorLicense {
    private String source = "Unknown";
    private XElem xml;
    private Array<Feature> features = new Array(Feature.class);
    private String signature;
    private String signatureAlgorithm;
    private boolean modified;

    public VendorLicense() {
        this.xml = new XElem("license");
        this.xml.setAttr("generated", LicenseUtil.formatDate(Clock.millis()));
        this.xml.setAttr("expiration", "never");
        this.modified = true;
    }

    public static VendorLicense make(BIFile file) throws Exception {
        VendorLicense result = new VendorLicense();
        result.load(file);
        return result;
    }

    public static VendorLicense make(String source, InputStream in) throws Exception {
        VendorLicense result = new VendorLicense();
        result.load(source, in);
        return result;
    }

    public static VendorLicense make(String source, InputStream in, boolean close) throws Exception {
        VendorLicense result = new VendorLicense();
        result.load(source, in, close);
        return result;
    }

    public static VendorLicense make(String source, XElem xml) throws Exception {
        VendorLicense result = new VendorLicense();
        result.load(source, xml);
        return result;
    }

    public String getSource() {
        return this.source;
    }

    public String getHostId() {
        return this.xml.get("hostId");
    }

    public void setHostId(String hostId) {
        this.modify();
        this.xml.setAttr("hostId", hostId);
    }

    public String getVendor() {
        return this.xml.get("vendor");
    }

    public void setVendor(String vendor) {
        this.modify();
        this.xml.setAttr("vendor", vendor);
    }

    public boolean isExpired() {
        return Clock.millis() > this.getExpiration();
    }

    public long getExpiration() {
        return LicenseUtil.parseDate(this.xml.get("expiration"), false);
    }

    public void setExpiration(long expiration) {
        this.modify();
        this.xml.setAttr("expiration", LicenseUtil.formatDate(expiration));
    }

    public Optional<Long> getMaintenanceExpiration() {
        return LicenseUtil.getDateAttributeValue(this.xml, "maintenanceExpiration", false);
    }

    public void setMaintenanceExpiration(Optional<Long> value) {
        Objects.requireNonNull(value);
        this.modify();
        if (value.isPresent()) {
            this.xml.setAttr("maintenanceExpiration", LicenseUtil.formatDate(value.get()));
        } else {
            this.xml.removeAttr("maintenanceExpiration");
        }
    }

    public Optional<Long> getUnreleasedSwAccessExpiration() {
        return LicenseUtil.getDateAttributeValue(this.xml, "unreleasedSwAccessExpiration", false);
    }

    public void setUnreleasedSwAccessExpiration(Optional<Long> value) {
        Objects.requireNonNull(value);
        this.modify();
        if (value.isPresent()) {
            this.xml.setAttr("unreleasedSwAccessExpiration", LicenseUtil.formatDate(value.get()));
        } else {
            this.xml.removeAttr("unreleasedSwAccessExpiration");
        }
    }

    public long getGenerated() {
        return LicenseUtil.parseDate(this.xml.get("generated"), true);
    }

    public Version getVersion() {
        return new Version(this.xml.get("version"));
    }

    public void setVersion(Version version) {
        this.modify();
        this.xml.setAttr("version", version.toString());
    }

    public String getSignature() {
        return this.signature;
    }

    public void setSignature(String signature) {
        this.modify();
        this.signature = signature;
    }

    public String getSignatureAlgorithm() {
        return this.signatureAlgorithm;
    }

    public void setSignatureAlgorithm(String signatureAlgorithm) {
        this.modified = true;
        this.signatureAlgorithm = signatureAlgorithm;
    }

    public Feature getFeature(String name) {
        for (int i = 0; i < this.features.size(); ++i) {
            Feature f = (Feature)this.features.get(i);
            if (!f.getKey().equals(Feature.toKey(name))) continue;
            return f;
        }
        return null;
    }

    public Feature.Brand getBrandFeature() {
        return (Feature.Brand)this.getFeature("brand");
    }

    public String getBrandId() {
        if ("tridium".equalsIgnoreCase(this.getVendor())) {
            Feature.Brand brandFeature = this.getBrandFeature();
            return brandFeature == null ? null : brandFeature.getBrandId();
        }
        return null;
    }

    public String getLicenseName() {
        if ("tridium".equalsIgnoreCase(this.getVendor())) {
            Feature.Brand brandFeature = this.getBrandFeature();
            return brandFeature == null ? TextUtil.capitalize((String)"tridium") : TextUtil.capitalize((String)brandFeature.getBrandId());
        }
        return TextUtil.capitalize((String)this.getVendor());
    }

    public Feature[] getFeatures() {
        return (Feature[])this.features.trim();
    }

    public String[] getFeatureNames() {
        Feature[] f = this.getFeatures();
        String[] n = new String[f.length];
        for (int i = 0; i < n.length; ++i) {
            n[i] = f[i].getName();
        }
        return n;
    }

    public Feature addFeature(String name) {
        if (this.getFeature(name) != null) {
            throw new RuntimeException("Feature already exists");
        }
        Feature f = Feature.make(this, name);
        this.features.add((Object)f);
        return f;
    }

    public Feature removeFeature(String name) {
        for (int i = 0; i < this.features.size(); ++i) {
            Feature f = (Feature)this.features.get(i);
            if (!f.getKey().equals(Feature.toKey(name))) continue;
            this.features.remove(i);
            return f;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(BIFile file) throws Exception {
        InputStream in = file.getInputStream();
        try {
            this.load(file.toString(), XParser.make((InputStream)in).parse());
        }
        finally {
            try {
                in.close();
            }
            catch (Exception exception) {}
        }
    }

    public void load(String source, InputStream in) throws Exception {
        this.load(source, in, true);
    }

    public void load(String source, InputStream in, boolean close) throws Exception {
        this.load(source, XParser.make((InputStream)in).parse(close));
    }

    public void load(String source, XElem xml) throws Exception {
        this.source = source != null ? source : "Unknown";
        this.parse(xml);
    }

    private void parse(XElem xml) throws Exception {
        if (!"license".equals(xml.qname())) {
            throw new XException("Root element must be <license> element", xml);
        }
        this.modified = false;
        this.xml = new XElem("license");
        for (int i = 0; i < xml.attrSize(); ++i) {
            this.xml.addAttr(xml.attrName(i), xml.attrValue(i));
        }
        if (xml.get("generated", null) == null) {
            this.xml.addAttr("generated", LicenseUtil.formatDate(Clock.millis()));
        }
        XElem[] featureElems = xml.elems("feature");
        this.features = new Array(Feature.class);
        for (XElem fx : featureElems) {
            Feature feature = Feature.make(this, fx.get("name"));
            feature.load(fx);
            this.features.add((Object)feature);
        }
        XElem sigElem = xml.elem("signature");
        if (sigElem != null) {
            this.signature = sigElem.string();
            this.signatureAlgorithm = sigElem.get("algorithm", null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(BIFile file) throws IOException {
        OutputStream out = file.getOutputStream();
        try {
            VendorLicense.format(this.save(), new XWriter(out));
        }
        finally {
            try {
                out.close();
            }
            catch (Exception exception) {}
        }
    }

    public void save(OutputStream outStream) throws IOException {
        this.save(outStream, true);
    }

    public void save(OutputStream outStream, boolean close) throws IOException {
        XWriter out = new XWriter(outStream);
        this.save(out);
        out.flush();
        if (close) {
            out.close();
        }
    }

    public void save(XWriter out) throws IOException {
        VendorLicense.format(this.save(), out);
    }

    public XElem save() {
        if (this.modified) {
            this.xml.setAttr("generated", LicenseUtil.formatDate(Clock.millis()));
            this.modified = false;
        }
        XElem result = this.xml.copy();
        for (int i = 0; i < this.features.size(); ++i) {
            result.addContent((XContent)((Feature)this.features.get(i)).save());
        }
        if (this.signature != null) {
            XElem sigElem = new XElem("signature");
            sigElem.addContent((XContent)new XText(this.signature));
            if (this.signatureAlgorithm != null) {
                sigElem.addAttr("algorithm", this.signatureAlgorithm);
            }
            result.addContent((XContent)sigElem);
        }
        return result;
    }

    public static void format(XElem lic, XWriter out) {
        VendorLicense.formatr(lic, out, "");
        out.flush();
    }

    private static void formatr(XElem xml, XWriter out, String indent) {
        out.w((Object)indent).w('<').w((Object)xml.name());
        int attrSize = xml.attrSize();
        for (int i = 0; i < attrSize; ++i) {
            out.w((Object)" ").attr(xml.attrName(i), xml.attrValue(i));
        }
        if (xml.contentSize() == 0) {
            out.w((Object)"/>").nl();
            return;
        }
        out.w('>');
        XElem[] kids = xml.elems();
        if (kids.length > 0) {
            out.nl();
        }
        for (XElem kid : kids) {
            VendorLicense.formatr(kid, out, indent + " ");
        }
        if (xml.text() != null) {
            xml.text().write(out);
        }
        if (kids.length > 0) {
            out.w((Object)indent);
        }
        out.w((Object)"</").w((Object)xml.name()).w('>').nl();
    }

    protected void modify() {
        this.signature = null;
        this.modified = true;
    }

    public void dump() {
        this.dump(new PrintWriter(System.out));
    }

    public void dump(PrintWriter out) {
        out.println("  VendorLicense");
        out.println("    source:                 " + this.source);
        out.println("    hostId:                 " + this.getHostId());
        out.println("    vendor:                 " + this.getVendor());
        out.println("    version:                " + this.getVersion());
        out.println("    expiration:             " + LicenseUtil.formatDate(this.getExpiration()));
        out.println("    generated:              " + LicenseUtil.formatDate(this.getGenerated()));
        if (this.getMaintenanceExpiration().isPresent()) {
            out.println("    maintenance expiration: " + LicenseUtil.formatDate(this.getMaintenanceExpiration().get()));
        } else {
            out.println("    maintenance expiration: n/a");
        }
        if (this.getUnreleasedSwAccessExpiration().isPresent()) {
            out.println("    unreleased software:    supported until " + LicenseUtil.formatDate(this.getUnreleasedSwAccessExpiration().get()));
        } else {
            out.println("    unreleased software:    unsupported");
        }
        for (Feature feature : this.getFeatures()) {
            feature.dump(out);
        }
        out.flush();
    }
}

