/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.sys.license.dom;

import com.tridium.sys.license.LicenseUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import javax.baja.file.BIFile;
import javax.baja.sys.Clock;
import javax.baja.util.Version;
import javax.baja.xml.XContent;
import javax.baja.xml.XElem;
import javax.baja.xml.XException;
import javax.baja.xml.XParser;
import javax.baja.xml.XText;
import javax.baja.xml.XWriter;

public class VendorCertificate {
    private String source = "Unknown";
    private XElem xml = new XElem("certificate");
    private String signature;
    private String signatureAlgorithm;
    private boolean modified;

    public VendorCertificate() {
        this.xml.setAttr("generated", LicenseUtil.formatDate(Clock.millis()));
        this.modified = true;
    }

    public static VendorCertificate make(BIFile file) throws Exception {
        VendorCertificate result = new VendorCertificate();
        result.load(file);
        return result;
    }

    public static VendorCertificate make(String source, InputStream in) throws Exception {
        VendorCertificate result = new VendorCertificate();
        result.load(source, in);
        return result;
    }

    public static VendorCertificate make(String source, InputStream in, boolean close) throws Exception {
        VendorCertificate result = new VendorCertificate();
        result.load(source, in, close);
        return result;
    }

    public static VendorCertificate make(String source, XElem xml) throws Exception {
        VendorCertificate result = new VendorCertificate();
        result.load(source, xml);
        return result;
    }

    public String getSource() {
        return this.source;
    }

    public String getVendor() {
        return this.xml.get("vendor");
    }

    public void setVendor(String vendor) {
        this.modify();
        this.xml.setAttr("vendor", vendor);
    }

    public boolean isExpired() {
        return Clock.millis() > this.getExpiration();
    }

    public long getExpiration() {
        return LicenseUtil.parseDate(this.xml.get("expiration"), false);
    }

    public void setExpiration(long expiration) {
        this.modify();
        this.xml.setAttr("expiration", LicenseUtil.formatDate(expiration));
    }

    public long getGenerated() {
        return LicenseUtil.parseDate(this.xml.get("generated"), true);
    }

    public Version getVersion() {
        return new Version(this.xml.get("version"));
    }

    public void setVersion(Version version) {
        this.modify();
        this.xml.setAttr("version", version.toString());
    }

    public String getSignature() {
        return this.signature;
    }

    public void setSignature(String signature) {
        this.modify();
        this.signature = signature;
    }

    public String getSignatureAlgorithm() {
        return this.signatureAlgorithm;
    }

    public void setSignatureAlgorithm(String signatureAlgorithm) {
        this.modified = true;
        this.signatureAlgorithm = signatureAlgorithm;
    }

    public String getPublicKey() {
        XElem publicKeyElem = this.xml.elem("publicKey");
        return publicKeyElem == null ? null : publicKeyElem.string();
    }

    public String getPublicKeyAlgorithm() {
        XElem publicKeyElem = this.xml.elem("publicKey");
        if (publicKeyElem == null) {
            return null;
        }
        String algorithm = publicKeyElem.get("algorithm", null);
        if (algorithm == null) {
            algorithm = publicKeyElem.get("algorthm", "DSA");
        }
        return algorithm;
    }

    @Deprecated
    public void setPublicKey(String publicKey) {
        this.setPublicKey(publicKey, "DSA");
    }

    public void setPublicKey(String publicKey, String algorithm) {
        this.modify();
        XElem publicKeyElem = this.xml.elem("publicKey");
        if (publicKeyElem != null) {
            this.xml.removeContent((XContent)publicKeyElem);
        }
        publicKeyElem = new XElem("publicKey");
        publicKeyElem.addContent((XContent)new XText(publicKey));
        publicKeyElem.addAttr("algorthm", algorithm);
        this.xml.addContent((XContent)publicKeyElem);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(BIFile file) throws Exception {
        InputStream in = file.getInputStream();
        try {
            this.load(file.toString(), XParser.make((InputStream)in).parse());
        }
        finally {
            try {
                in.close();
            }
            catch (Exception exception) {}
        }
    }

    public void load(String source, InputStream in) throws Exception {
        this.load(source, in, true);
    }

    public void load(String source, InputStream in, boolean close) throws Exception {
        this.load(source, XParser.make((InputStream)in).parse(close));
    }

    public void load(String source, XElem xml) throws Exception {
        this.source = source == null ? "Unknown" : source;
        this.parse(xml);
    }

    private void parse(XElem xml) throws Exception {
        XElem publicKeyElem;
        XElem sigElem;
        if (!"certificate".equals(xml.qname())) {
            throw new XException("Root element must be <certificate> element", xml);
        }
        this.modified = false;
        this.xml = new XElem("certificate");
        for (int i = 0; i < xml.attrSize(); ++i) {
            this.xml.addAttr(xml.attrName(i), xml.attrValue(i));
        }
        if (xml.get("generated", null) == null) {
            this.xml.addAttr("generated", LicenseUtil.formatDate(Clock.millis()));
        }
        if ((sigElem = xml.elem("signature")) != null) {
            this.signature = sigElem.string();
            this.signatureAlgorithm = sigElem.get("algorithm", null);
        }
        if ((publicKeyElem = xml.elem("publicKey")) != null) {
            this.xml.addContent((XContent)publicKeyElem.copy());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(BIFile file) throws IOException {
        OutputStream out = file.getOutputStream();
        try {
            VendorCertificate.format(this.save(), new XWriter(out));
        }
        finally {
            try {
                out.close();
            }
            catch (Exception exception) {}
        }
    }

    public void save(OutputStream outStream) throws IOException {
        this.save(outStream, true);
    }

    public void save(OutputStream outStream, boolean close) throws IOException {
        XWriter out = new XWriter(outStream);
        this.save(out);
        out.flush();
        if (close) {
            out.close();
        }
    }

    public void save(XWriter out) throws IOException {
        VendorCertificate.format(this.save(), out);
    }

    public XElem save() {
        if (this.modified) {
            this.xml.setAttr("generated", LicenseUtil.formatDate(Clock.millis()));
            this.modified = false;
        }
        XElem result = this.xml.copy();
        if (this.signature != null) {
            XElem sigElem = new XElem("signature");
            sigElem.addContent((XContent)new XText(this.signature));
            if (this.signatureAlgorithm != null) {
                sigElem.addAttr("algorithm", this.signatureAlgorithm);
            }
            result.addContent((XContent)sigElem);
        }
        return result;
    }

    public static void format(XElem cert, XWriter out) {
        VendorCertificate.formatr(cert, out, "");
        out.flush();
    }

    private static void formatr(XElem xml, XWriter out, String indent) {
        out.w((Object)indent).w('<').w((Object)xml.name());
        int attrSize = xml.attrSize();
        for (int i = 0; i < attrSize; ++i) {
            out.w((Object)" ").attr(xml.attrName(i), xml.attrValue(i));
        }
        if (xml.contentSize() == 0) {
            out.w((Object)"/>").nl();
            return;
        }
        out.w('>');
        XElem[] kids = xml.elems();
        if (kids.length > 0) {
            out.nl();
        }
        for (XElem kid : kids) {
            VendorCertificate.formatr(kid, out, indent + " ");
        }
        if (xml.text() != null) {
            xml.text().write(out);
        }
        if (kids.length > 0) {
            out.w((Object)indent);
        }
        out.w((Object)"</").w((Object)xml.name()).w('>').nl();
    }

    protected void modify() {
        this.signature = null;
        this.modified = true;
    }

    public void dump() {
        this.dump(new PrintWriter(System.out));
    }

    public void dump(PrintWriter out) {
        out.println("  VendorCertificate");
        out.println("    source:     " + this.source);
        out.println("    vendor:     " + this.getVendor());
        out.println("    version:    " + this.getVersion());
        out.println("    expiration: " + LicenseUtil.formatDate(this.getExpiration()));
        out.println("    generated:  " + LicenseUtil.formatDate(this.getGenerated()));
        out.flush();
    }
}

