/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.sys.license.dom;

import com.tridium.sys.license.dom.HostLicenseSet;
import com.tridium.sys.license.dom.VendorLicense;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.baja.file.BDirectory;
import javax.baja.file.BIFile;
import javax.baja.nre.util.TextUtil;

public class LicenseSet {
    private List<VendorLicense> list = new ArrayList<VendorLicense>();

    public Iterator<VendorLicense> iterator() throws Exception {
        return this.list.iterator();
    }

    public boolean add(VendorLicense lic) throws Exception {
        this.list.add(lic);
        return false;
    }

    public boolean remove(VendorLicense lic) throws Exception {
        return this.list.remove(lic);
    }

    public void clear() throws Exception {
        this.list.clear();
    }

    public HostLicenseSet toHostLicenseSet(String hostId) throws Exception {
        return this.toHostLicenseSet(hostId, null);
    }

    public HostLicenseSet toHostLicenseSet(String hostId, String brandId) throws Exception {
        HostLicenseSet r = null;
        Iterator<VendorLicense> i = this.iterator();
        while (i.hasNext()) {
            VendorLicense lic = i.next();
            if (!hostId.equals(lic.getHostId()) || brandId != null && lic.getBrandId() != null && !lic.getBrandId().equals(brandId)) continue;
            if (r == null) {
                r = new HostLicenseSet();
            }
            if (r.getVendorLicense(lic.getVendor()) != null) {
                throw new RuntimeException("Duplicate licenses for same hostId and vendor: " + lic.getVendor());
            }
            r.add(lic);
        }
        return r;
    }

    public void load(BDirectory dir) {
        BIFile[] files = dir.listFiles();
        for (int i = 0; files != null && i < files.length; ++i) {
            BIFile f = files[i];
            if (f.isDirectory() || !"license".equals(f.getExtension())) continue;
            try {
                this.add(VendorLicense.make(f));
                continue;
            }
            catch (Exception e) {
                System.out.println("ERROR: Cannot read \"" + f + "\"");
                e.printStackTrace();
            }
        }
    }

    public void dump() throws Exception {
        this.dump(new PrintWriter(System.out));
    }

    public void dump(PrintWriter out) throws Exception {
        out.println(TextUtil.getClassName(this.getClass()));
        Iterator<VendorLicense> i = this.iterator();
        while (i.hasNext()) {
            i.next().dump(out);
        }
    }
}

