/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.sys.license;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.file.FilePath;
import javax.baja.license.Feature;
import javax.baja.license.LicenseException;
import javax.baja.sys.Sys;
import javax.baja.util.PatternFilter;

public class Brand {
    static final Logger log = Logger.getLogger("sys.brand");
    public static final FilePath BRAND_PROPS_PATH = new FilePath("!etc/brand.properties");
    private static boolean init;
    private static String brandId;
    private static AcceptList acceptStationIn;
    private static AcceptList acceptStationOut;
    private static AcceptList acceptWbIn;
    private static AcceptList acceptWbOut;

    public static String getBrandId() {
        Brand.init();
        return brandId;
    }

    public static String getAcceptStationInString() {
        Brand.init();
        return Brand.acceptStationIn.patternString;
    }

    public static String getAcceptStationOutString() {
        Brand.init();
        return Brand.acceptStationOut.patternString;
    }

    public static String getAcceptWbInString() {
        Brand.init();
        return Brand.acceptWbIn.patternString;
    }

    public static String getAcceptWbOutString() {
        Brand.init();
        return Brand.acceptWbOut.patternString;
    }

    public static void checkStationIn(String brandId) {
        Brand.init();
        acceptStationIn.check(brandId);
    }

    public static void checkStationOut(String brandId) {
        Brand.init();
        acceptStationOut.check(brandId);
    }

    public static void checkWbIn(String brandId) {
        Brand.init();
        acceptWbIn.check(brandId);
    }

    public static void checkWbOut(String brandId) {
        Brand.init();
        acceptWbOut.check(brandId);
    }

    private static void init() {
        if (init) {
            return;
        }
        Feature feature = Sys.getLicenseManager().checkFeature("tridium", "brand");
        brandId = feature.get("brandId");
        if (brandId == null) {
            throw new LicenseException("Missing brandId in brand feature");
        }
        acceptStationIn = new AcceptList(feature, "accept.station.in");
        acceptStationOut = new AcceptList(feature, "accept.station.out");
        acceptWbIn = new AcceptList(feature, "accept.wb.in");
        acceptWbOut = new AcceptList(feature, "accept.wb.out");
        init = true;
    }

    public static class AcceptList {
        String id;
        PatternFilter[] patterns;
        String patternString;

        public AcceptList(Feature feature, String id) {
            this.id = id;
            this.patternString = feature.get(id, "*");
            this.patterns = PatternFilter.parseList(this.patternString, ";");
        }

        public AcceptList(String id, String patternString) {
            this.id = id;
            this.patternString = patternString;
            this.patterns = PatternFilter.parseList(patternString, ";");
        }

        public void check(String brandId) {
            if (!this.accept(brandId)) {
                throw new LicenseException("Brand incompatibility [" + this.id + "] " + brandId + " != " + this.patternString);
            }
        }

        public boolean accept(String brandId) {
            if (log.isLoggable(Level.FINE)) {
                log.fine("check " + this.id + ": " + brandId + " against " + this.patternString);
            }
            if (brandId == null) {
                return true;
            }
            for (int i = 0; i < this.patterns.length; ++i) {
                if (!this.patterns[i].accept(brandId)) continue;
                return true;
            }
            return false;
        }

        public String toString() {
            return this.id + "=" + this.patternString;
        }
    }
}

