/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.sys.engine;

import com.tridium.sys.engine.EngineManager;
import com.tridium.sys.engine.NClockTicket;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.Clock;

public class TicketQueue {
    public int minScan;
    public int maxScan;
    int scanCount;
    long totalTicksInsideScan;
    int size;
    int peak;
    NClockTicket head;
    NClockTicket tail;
    long nextScan;
    final Object lock = new Object();

    public TicketQueue(int minScan, int maxScan) {
        this.minScan = minScan;
        this.maxScan = maxScan;
    }

    public void check() {
        long t1 = Clock.ticks();
        if (this.nextScan >= t1) {
            return;
        }
        long sleep = this.scan();
        long t2 = Clock.ticks();
        if (sleep < (long)this.minScan) {
            sleep = this.minScan;
        }
        if (sleep > (long)this.maxScan) {
            sleep = this.maxScan;
        }
        this.nextScan = t1 + sleep;
        this.totalTicksInsideScan += t2 - t1;
        ++this.scanCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enqueue(NClockTicket ticket) {
        Object object = this.lock;
        synchronized (object) {
            if (this.tail == null) {
                this.head = this.tail = ticket;
            } else {
                this.tail.next = ticket;
                this.tail = ticket;
            }
            ++this.size;
            if (this.size > this.peak) {
                this.peak = this.size;
            }
            this.nextScan = 0L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long scan() {
        NClockTicket ticket = null;
        Object object = this.lock;
        synchronized (object) {
            ticket = this.head;
            this.tail = null;
            this.head = null;
            this.size = 0;
        }
        NClockTicket aliveHead = null;
        NClockTicket aliveTail = null;
        long sleep = Long.MAX_VALUE;
        long curTicks = Clock.ticks();
        long curMillis = Clock.millis();
        int size = 0;
        while (ticket != null) {
            NClockTicket next = ticket.next;
            ticket.next = null;
            long ticketSleep = ticket.process(curTicks, curMillis);
            if (ticketSleep != Long.MIN_VALUE) {
                sleep = Math.min(sleep, ticketSleep);
                if (aliveTail == null) {
                    aliveHead = aliveTail = ticket;
                } else {
                    aliveTail.next = ticket;
                    aliveTail = ticket;
                }
                ++size;
            }
            ticket = next;
        }
        Object object2 = this.lock;
        synchronized (object2) {
            if (aliveHead != null) {
                if (this.head == null) {
                    this.head = aliveHead;
                    this.tail = aliveTail;
                } else {
                    aliveTail.next = this.head;
                    this.head = aliveHead;
                }
                this.size += size;
                if (this.size > this.peak) {
                    this.peak = this.size;
                }
            }
        }
        return sleep;
    }

    public void writeSummary(SpyWriter out, String href) throws Exception {
        long ticks = Clock.ticks();
        String nextScanStr = this.nextScan < ticks ? "next cycle" : EngineManager.timeStr(this.nextScan - ticks);
        out.prop((Object)"scanCount", "" + this.scanCount);
        out.prop((Object)"totalTicksInsideScan", EngineManager.timeStr(this.totalTicksInsideScan));
        out.propNameLink(href, "Queue", "" + this.size + " (Peak " + this.peak + ")");
        out.prop((Object)"nextScan", nextScanStr);
        out.prop((Object)"scanBounds", this.minScan + "ms - " + this.maxScan + "ms");
    }
}

