/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.sys.diagnostics;

import com.tridium.nre.diagnostics.DiagnosticStats;
import com.tridium.nre.diagnostics.DiagnosticUtil;
import com.tridium.sys.Nre;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import javax.baja.naming.SlotPath;
import javax.baja.nre.util.TextUtil;
import javax.baja.spy.Spy;
import javax.baja.spy.SpyDir;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BFacets;
import javax.baja.sys.BRelTime;

public class DiagnosticSpy {
    static BFacets SHOW_MILLIS = BFacets.make("showMilliseconds", true);
    static double CONVERT_TO_MILLIS = 1000000.0;

    public static void postInit() {
        DiagnosticSpy.initSpy();
    }

    public static void initSpy() {
        Nre.spySysManagers.add("diagnosticManager", new SummaryPage());
    }

    static List<Map.Entry<String, DiagnosticStats.KeyStat>> entriesForKeyStatSortedByValues(Map<String, DiagnosticStats.KeyStat> map) {
        ArrayList<Map.Entry<String, DiagnosticStats.KeyStat>> sortedEntries = new ArrayList<Map.Entry<String, DiagnosticStats.KeyStat>>(map.entrySet());
        Collections.sort(sortedEntries, new CountCompare());
        return sortedEntries;
    }

    static List<Map.Entry<String, DiagnosticStats>> entriesForDiagStatSortedByValues(Map<String, DiagnosticStats> map) {
        ArrayList<Map.Entry<String, DiagnosticStats>> sortedEntries = new ArrayList<Map.Entry<String, DiagnosticStats>>(map.entrySet());
        Collections.sort(sortedEntries, new TotalTimeCompare());
        return sortedEntries;
    }

    static String toDisplayString(String value) {
        if (value == null) {
            return null;
        }
        if (value.length() > 87) {
            return value.substring(0, 87) + "...";
        }
        return value;
    }

    static String toDisplayString(double value) {
        DecimalFormat format = new DecimalFormat("0.000");
        if (value >= 1.0) {
            format = new DecimalFormat("##.0");
        }
        return format.format(value);
    }

    static String encodeChildPage(String child, String functionName, String key) {
        StringBuilder b = new StringBuilder();
        b.append(child);
        if (functionName != null) {
            b.append(".").append(SlotPath.escape(functionName));
        }
        if (key != null) {
            b.append(".").append(SlotPath.escape(key));
        }
        return b.toString();
    }

    private static class CountCompare
    implements Comparator<Map.Entry<String, DiagnosticStats.KeyStat>> {
        private CountCompare() {
        }

        @Override
        public int compare(Map.Entry<String, DiagnosticStats.KeyStat> o1, Map.Entry<String, DiagnosticStats.KeyStat> o2) {
            DiagnosticStats.KeyStat keyStat1 = o1.getValue();
            DiagnosticStats.KeyStat keyStat2 = o2.getValue();
            return (int)(keyStat2.getTotalTime() - keyStat1.getTotalTime());
        }
    }

    private static class TotalTimeCompare
    implements Comparator<Map.Entry<String, DiagnosticStats>> {
        private TotalTimeCompare() {
        }

        @Override
        public int compare(Map.Entry<String, DiagnosticStats> o1, Map.Entry<String, DiagnosticStats> o2) {
            DiagnosticStats stat1 = o1.getValue();
            DiagnosticStats stat2 = o2.getValue();
            return (int)(stat2.getTotalTime() - stat1.getTotalTime());
        }
    }

    public static class ResetSpy
    extends ActionSpy {
        private boolean ignore;
        private String functionName;
        private DiagnosticStats.KeyStat keyStat;

        public ResetSpy(String title, String functionName, DiagnosticStats.KeyStat keyStat) {
            this(title, functionName, keyStat, false);
        }

        public ResetSpy(String title, String functionName, DiagnosticStats.KeyStat keyStat, boolean ignore) {
            super(title);
            this.keyStat = keyStat;
            this.functionName = functionName;
            this.ignore = ignore;
        }

        @Override
        public void write(SpyWriter out) {
            if (this.keyStat == null && this.functionName == null) {
                DiagnosticUtil.reset();
            } else if (this.keyStat == null) {
                if (this.ignore) {
                    DiagnosticUtil.ignoreFunction((String)this.functionName);
                } else {
                    DiagnosticUtil.resetFunction((String)this.functionName);
                }
            } else if (this.ignore) {
                DiagnosticUtil.ignoreKey((String)this.keyStat.getFunctionName(), (String)this.keyStat.getKey());
            } else {
                DiagnosticUtil.resetKey((String)this.keyStat.getFunctionName(), (String)this.keyStat.getKey());
            }
            super.write(out);
        }
    }

    public static class ActionSpy
    extends SpyDir {
        private String title;

        public ActionSpy(String title) {
            this.title = title;
        }

        @Override
        public void write(SpyWriter out) {
            out.startProps(this.title);
            out.propValueLink("", "..", "Return");
            out.endProps();
        }

        @Override
        public String getTitle() {
            return this.title;
        }
    }

    public static class DetailSpy
    extends SpyDir {
        private DiagnosticStats.KeyStat keyStat;

        public DetailSpy(DiagnosticStats.KeyStat keyStat) {
            this.keyStat = keyStat;
        }

        @Override
        public void write(SpyWriter out) {
            out.startProps();
            int recentStacksCount = 0;
            out.prop((Object)"Function", "" + this.keyStat.getFunctionName());
            out.prop((Object)"Key", "" + this.keyStat.getKey());
            Object[] array = null;
            if (this.keyStat.getStacks() != null) {
                array = this.keyStat.getStacks().values().toArray();
                recentStacksCount = array.length;
            }
            out.prop((Object)"Recent Stack Traces Count", "" + recentStacksCount);
            long duration = DiagnosticUtil.getDiagnosticDuration();
            double averageTimePerCall = (double)this.keyStat.getTotalTime() / CONVERT_TO_MILLIS / (double)this.keyStat.getCallCount();
            long totalReadMs = (long)((double)this.keyStat.getTotalTime() / CONVERT_TO_MILLIS);
            double percentOfDiagnosis = (double)totalReadMs * 100.0 / (double)duration;
            out.prop((Object)"averageTime/call", DiagnosticSpy.toDisplayString(averageTimePerCall) + " ms");
            out.prop((Object)"total calls", "" + this.keyStat.getCallCount());
            out.prop((Object)"total runtime for call", BRelTime.make(totalReadMs));
            out.prop((Object)"Runtime %", DiagnosticSpy.toDisplayString(percentOfDiagnosis) + " %");
            if (recentStacksCount > 1) {
                out.prop((Object)"", () -> out.mutatorButton("../" + DiagnosticSpy.encodeChildPage("reset", this.keyStat.getFunctionName(), this.keyStat.getKey()), "Reset"));
            }
            out.prop((Object)"", () -> out.mutatorButton("../" + DiagnosticSpy.encodeChildPage("ignore", this.keyStat.getFunctionName(), this.keyStat.getKey()), "Ignore"));
            out.endProps();
            out.startProps();
            for (int j = recentStacksCount - 1; j >= 0 && array != null; --j) {
                DiagnosticStats.TimedStackTrace timedStack = (DiagnosticStats.TimedStackTrace)array[j];
                out.prop((Object)"Duration", (double)timedStack.getTimePerCall() / CONVERT_TO_MILLIS + " ms");
                out.prop((Object)"Time", BAbsTime.make(timedStack.getCurrentTimeMillis()).toString(SHOW_MILLIS));
                StringWriter result = new StringWriter();
                PrintWriter printWriter = new PrintWriter(result);
                timedStack.getStack().printStackTrace(printWriter);
                String[] lines = TextUtil.split((String)((Object)result).toString(), (char)'\n');
                for (int i = 4; i < lines.length; ++i) {
                    out.prop((Object)"", lines[i]);
                }
            }
            out.endProps();
        }
    }

    public static class KeySpy
    extends SpyDir {
        private DiagnosticStats stats;

        public KeySpy(DiagnosticStats stats) {
            this.stats = stats;
        }

        @Override
        public void write(SpyWriter out) {
            long keyCount = 0L;
            long duration = DiagnosticUtil.getDiagnosticDuration();
            if (this.stats.getKeyUsage() != null) {
                out.w("<h4>Keys for ").safe(this.stats.getFunctionName()).w("</h4>");
                out.startTable(true);
                out.w("<tr>").thTitle("Key").thTitle("Total Time (ms)").thTitle("avg per call (ms)").thTitle("Count").thTitle("Runtime %").thTitle("").thTitle("").thTitle("").w("</tr>");
                List<Map.Entry<String, DiagnosticStats.KeyStat>> sortedStats = DiagnosticSpy.entriesForKeyStatSortedByValues(this.stats.getKeyUsage());
                for (Map.Entry<String, DiagnosticStats.KeyStat> entry1 : sortedStats) {
                    DiagnosticStats.KeyStat keyStat = entry1.getValue();
                    if (keyStat.getIgnore()) continue;
                    ++keyCount;
                    double averageTimePerCall = (double)keyStat.getTotalTime() / CONVERT_TO_MILLIS / (double)keyStat.getCallCount();
                    double totalReadMs = (double)keyStat.getTotalTime() / CONVERT_TO_MILLIS;
                    double percentOfVMInRead = totalReadMs * 100.0 / (double)duration;
                    out.tr();
                    out.td(DiagnosticSpy.toDisplayString(keyStat.getKey()));
                    out.td(DiagnosticSpy.toDisplayString(totalReadMs));
                    out.td(DiagnosticSpy.toDisplayString(averageTimePerCall));
                    out.td(keyStat.getCallCount());
                    out.td(DiagnosticSpy.toDisplayString(percentOfVMInRead));
                    out.td().a("../" + DiagnosticSpy.encodeChildPage("details", keyStat.getFunctionName(), keyStat.getKey()), "Details").endTd();
                    out.td().mutatorButton("../" + DiagnosticSpy.encodeChildPage("reset", keyStat.getFunctionName(), keyStat.getKey()), "Reset").endTd();
                    out.td().mutatorButton("../" + DiagnosticSpy.encodeChildPage("ignore", keyStat.getFunctionName(), keyStat.getKey()), "Ignore").endTd();
                    out.endTr();
                }
                out.endTable();
            } else {
                out.w("<h4>Details for ").safe(this.stats.getFunctionName()).w("</h4>");
            }
            double averageTimePerCall = this.stats.getTotalTime() / CONVERT_TO_MILLIS / (double)this.stats.getFunctionCalls();
            long totalReadMs = (long)(this.stats.getTotalTime() / CONVERT_TO_MILLIS);
            double percentOfDiagnosis = (double)totalReadMs * 100.0 / (double)duration;
            out.startProps();
            out.prop((Object)"Function", this.stats.getFunctionName());
            out.prop((Object)"Total Time", BRelTime.make(totalReadMs));
            out.prop((Object)"avg per call (ms)", DiagnosticSpy.toDisplayString(averageTimePerCall));
            out.prop((Object)"Runtime %", DiagnosticSpy.toDisplayString(percentOfDiagnosis));
            if (this.stats.getKeyUsage() != null) {
                out.prop((Object)"Unique Keys", "" + keyCount);
            }
            out.prop((Object)"", () -> out.mutatorButton("../" + DiagnosticSpy.encodeChildPage("reset", this.stats.getFunctionName(), null), "Reset All"));
            out.prop((Object)"", () -> out.mutatorButton("../" + DiagnosticSpy.encodeChildPage("ignore", this.stats.getFunctionName(), null), "Ignore All"));
            out.endProps();
        }

        @Override
        public String getTitle() {
            return "Keys";
        }
    }

    public static class SummaryPage
    extends SpyDir {
        public SummaryPage() {
            this.add("pause", new ActionSpy("Pause Diagnostics"){

                @Override
                public void write(SpyWriter out) {
                    super.write(out);
                    DiagnosticUtil.pause();
                }
            });
        }

        @Override
        public Spy find(String name) {
            String spyPage = null;
            String functionName = null;
            String key = null;
            String[] split = TextUtil.split((String)SpyWriter.getRequestedName(name), (char)'.');
            if (split.length > 0) {
                spyPage = split[0];
            }
            if (split.length > 1) {
                functionName = SlotPath.unescape(split[1]);
            }
            if (split.length > 2) {
                key = SlotPath.unescape(split[2]);
            }
            if (spyPage != null && SpyWriter.verifyNameAndCsrfToken(name, "resetAll")) {
                return new ResetSpy("Reset All", null, null);
            }
            DiagnosticStats stats = (DiagnosticStats)DiagnosticUtil.getAllStats().get(functionName);
            if (spyPage != null && spyPage.equals("keys") && stats != null) {
                return new KeySpy(stats);
            }
            DiagnosticStats.KeyStat keyStat = null;
            if (stats != null) {
                if (stats.getKeyUsage() != null && key != null) {
                    keyStat = (DiagnosticStats.KeyStat)stats.getKeyUsage().get(key);
                }
                if (spyPage != null && spyPage.equals("details") && keyStat != null) {
                    return new DetailSpy(keyStat);
                }
                if ("reset".equals(spyPage) || "ignore".equals(spyPage)) {
                    String resetOrIgnore;
                    boolean ignore = "ignore".equals(spyPage);
                    String string = resetOrIgnore = ignore ? "ignore" : "reset";
                    if (SpyWriter.verifyNameAndCsrfToken(name, DiagnosticSpy.encodeChildPage(spyPage, functionName, key))) {
                        return new ResetSpy(resetOrIgnore + " " + functionName + " " + key, functionName, keyStat, ignore);
                    }
                }
            }
            if (SpyWriter.verifyNameAndCsrfToken(name, "pause")) {
                return super.find("pause");
            }
            return super.find(name);
        }

        @Override
        public void write(SpyWriter out) throws Exception {
            boolean inUse;
            long duration = DiagnosticUtil.getDiagnosticDuration();
            long accumulatedDuration = 0L;
            Map allStats = DiagnosticUtil.getAllStats();
            boolean bl = inUse = allStats.size() != 0;
            if (!inUse) {
                out.w("<b>No Diagnostic Information Collected</b>");
            } else {
                out.startTable(true);
                out.w("<tr>").thTitle("Function").thTitle("Total Time").thTitle("avg per call (ms)").thTitle("Runtime %").thTitle("Count");
                if (DiagnosticStats.MAX_KEY_USAGES > 0) {
                    out.thTitle("Highest Key Count").thTitle("Highest Key");
                }
                out.w("</tr>");
                for (Map.Entry<String, DiagnosticStats> anAllStatsEntry : DiagnosticSpy.entriesForDiagStatSortedByValues(allStats)) {
                    long highestCount = 0L;
                    String highestKey = null;
                    String key = anAllStatsEntry.getKey();
                    DiagnosticStats stats = (DiagnosticStats)allStats.get(key);
                    if (stats.getKeyUsage() != null) {
                        Object[] values;
                        for (Object value : values = stats.getKeyUsage().values().toArray()) {
                            long count;
                            DiagnosticStats.KeyStat keyStat = (DiagnosticStats.KeyStat)value;
                            if (keyStat.getIgnore() || (count = keyStat.getCallCount()) <= highestCount) continue;
                            highestCount = count;
                            highestKey = keyStat.getKey();
                        }
                    }
                    double averageTimePerCall = stats.getTotalTime() / CONVERT_TO_MILLIS / (double)stats.getFunctionCalls();
                    long totalReadMs = (long)(stats.getTotalTime() / CONVERT_TO_MILLIS);
                    double percentOfDiagnosis = (double)totalReadMs * 100.0 / (double)duration;
                    accumulatedDuration += totalReadMs;
                    String highestKeyDisplay = "none";
                    if (highestKey != null && highestKey.length() > 0) {
                        highestKeyDisplay = highestKey;
                    }
                    out.tr();
                    out.td(key);
                    out.td(BRelTime.make(totalReadMs));
                    out.td(DiagnosticSpy.toDisplayString(averageTimePerCall));
                    out.td(DiagnosticSpy.toDisplayString(percentOfDiagnosis));
                    out.td().a(DiagnosticSpy.encodeChildPage("keys", stats.getFunctionName(), null), stats.getFunctionCalls()).endTd();
                    if (stats.getKeyUsage() != null && DiagnosticStats.MAX_KEY_USAGES > 0) {
                        if (highestCount > 0L) {
                            out.td().a(DiagnosticSpy.encodeChildPage("details", stats.getFunctionName(), highestKey), highestCount).endTd();
                        } else {
                            out.td(highestCount);
                        }
                        out.td(highestKeyDisplay);
                    }
                    out.endTr();
                }
                out.endTable();
            }
            double accumulatedPercentOfDiagnosis = (double)accumulatedDuration * 100.0 / (double)duration;
            String state = "Running";
            if (DiagnosticUtil.getDiagnosticStop() != 0L) {
                state = "Paused";
            } else if (!inUse) {
                state = "Available";
            }
            out.startProps("Diagnostics Summary");
            out.prop((Object)"State", state);
            out.prop((Object)"Start Time", BAbsTime.make(DiagnosticUtil.getDiagnosticStart()).toString(SHOW_MILLIS));
            if (DiagnosticUtil.getDiagnosticStop() != 0L) {
                out.prop((Object)"Stop Time", BAbsTime.make(DiagnosticUtil.getDiagnosticStop()).toString(SHOW_MILLIS));
            }
            out.prop((Object)"Runtime Duration", BRelTime.make(duration));
            out.prop((Object)"Runtime %", DiagnosticSpy.toDisplayString(accumulatedPercentOfDiagnosis));
            out.prop((Object)"Keys   Limit", DiagnosticStats.MAX_KEY_USAGES);
            out.prop((Object)"Stacks Limit", DiagnosticStats.MAX_TIMED_STACKS);
            String mode = "runnable";
            if (DiagnosticStats.INCLUDE_WAIT_TIME) {
                mode = "runnable and wait time";
            }
            out.prop((Object)"Mode", mode);
            out.prop((Object)"", () -> out.mutatorButton("resetAll", "Reset Diagnostics"));
            if (DiagnosticUtil.getDiagnosticStop() == 0L) {
                out.prop((Object)"", () -> out.mutatorButton("pause", "Pause Diagnostics"));
            }
            out.endProps();
        }
    }
}

