/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.session;

import java.util.Objects;
import javax.baja.security.AuditEvent;
import javax.baja.user.BUser;

public interface AuditInfo {
    public String getAuditSlotName();

    public String getAuditTarget();

    default public String getAuditOldValue(String operation) {
        return "";
    }

    default public String getAuditValue(String operation, BUser user) {
        Objects.requireNonNull(operation);
        switch (operation) {
            case "Logout": 
            case "Logout (Timeout)": {
                return "";
            }
            case "Login": {
                return "true";
            }
            case "Login Failure": {
                return "false";
            }
        }
        throw new IllegalArgumentException("Unsupported operation: " + operation);
    }

    default public AuditEvent makeAuditEvent(String operation, BUser user) {
        Objects.requireNonNull(operation);
        Objects.requireNonNull(user);
        return new AuditEvent(operation, this.getAuditTarget(), this.getAuditSlotName(), this.getAuditOldValue(operation), this.getAuditValue(operation, user), user.getUsername());
    }
}

