/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.security;

import java.security.AccessController;
import java.util.Arrays;
import java.util.Collection;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class UrlWhitelist
implements Predicate<String> {
    private static final String REGEX_PREFIX = "regex:";
    private final Collection<Predicate<String>> urlMatchers;
    public static final UrlWhitelist ALLOW_ALL = new UrlWhitelist("regex:.*");

    public UrlWhitelist(String ... patterns) {
        this.urlMatchers = Arrays.stream(patterns).filter(s -> s != null && !s.isEmpty()).map(s -> UrlWhitelist.makeUrlMatcher(s.trim())).collect(Collectors.toList());
    }

    public boolean isEnabled() {
        return !this.urlMatchers.isEmpty();
    }

    @Override
    public boolean test(String url) {
        if (url == null) {
            return false;
        }
        for (Predicate<String> matcher : this.urlMatchers) {
            if (!matcher.test(url)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return this.urlMatchers.toString();
    }

    public static UrlWhitelist getDefaultInstance(String ... urls) {
        return new UrlWhitelist((String[])Stream.of(UrlWhitelist.getConfiguredWhitelist().split(","), urls).flatMap(Stream::of).toArray(String[]::new));
    }

    public static String getConfiguredWhitelist() {
        return AccessController.doPrivileged(() -> System.getProperty("niagara.webbrowser.urlWhitelist", "tridium.com,niagara-community.com,honeywellcloud.com,niagaramodules.com,niagara-cloud.com"));
    }

    private static Predicate<String> makeUrlMatcher(String str) {
        if (str.startsWith(REGEX_PREFIX)) {
            return new RegexMatcher(str.substring(REGEX_PREFIX.length()));
        }
        return new UrlMatcher(str);
    }

    private static class OriginMatcher {
        private final String protocol;
        private final String host;
        private final Integer port;

        private OriginMatcher(String protocol, String host, String port) {
            this.protocol = protocol;
            this.host = host;
            this.port = port == null ? null : Integer.valueOf(port);
        }

        private boolean matches(OriginMatcher origin) {
            Integer portToCheck;
            if (this.protocol != null && !this.protocol.equalsIgnoreCase(origin.protocol)) {
                return false;
            }
            if (this.host != null && origin.host != null && !OriginMatcher.hostsMatch(origin.host, this.host)) {
                return false;
            }
            Integer n = portToCheck = origin.port == null ? OriginMatcher.defaultPortForProtocol(origin.protocol) : origin.port;
            return this.port == null || this.port.equals(portToCheck);
        }

        private static Integer defaultPortForProtocol(String protocol) {
            switch (String.valueOf(protocol).toLowerCase()) {
                case "http": {
                    return 80;
                }
                case "https": {
                    return 443;
                }
            }
            return null;
        }

        private static boolean hostsMatch(String toCheck, String toCheckAgainst) {
            String[] partsToCheckAgainst;
            String[] partsToCheck = toCheck.split("\\.");
            if (partsToCheck.length < (partsToCheckAgainst = toCheckAgainst.split("\\.")).length) {
                return false;
            }
            for (int i = 0; i < partsToCheckAgainst.length; ++i) {
                if (partsToCheckAgainst[partsToCheckAgainst.length - 1 - i].equalsIgnoreCase(partsToCheck[partsToCheck.length - 1 - i])) continue;
                return false;
            }
            return true;
        }
    }

    public static class UrlMatcher
    implements Predicate<String> {
        private final String pattern;
        private final OriginMatcher originMatcher;
        private final String path;
        private static final Pattern URL_PATTERN = Pattern.compile("((\\w+)(://))?([\\w-.]+)?(:(\\d+))?(.*)?");

        private UrlMatcher(String pattern) {
            this.pattern = pattern;
            Matcher m = URL_PATTERN.matcher(pattern);
            if (!m.matches()) {
                throw new IllegalArgumentException("Invalid URL " + pattern);
            }
            String protocol = m.group(2);
            String hostname = m.group(4);
            String port = m.group(6);
            String path = m.group(7);
            this.originMatcher = new OriginMatcher(protocol, hostname, port);
            this.path = path;
        }

        @Override
        public boolean test(String url) {
            UrlMatcher matcher = new UrlMatcher(url);
            if (!this.originMatcher.matches(matcher.originMatcher)) {
                return false;
            }
            if (this.path != null && matcher.path != null) {
                return matcher.path.startsWith(this.path);
            }
            return true;
        }

        public String toString() {
            return this.pattern;
        }
    }

    public static class RegexMatcher
    implements Predicate<String> {
        private final Pattern pattern;

        private RegexMatcher(String pattern) {
            this.pattern = Pattern.compile(".*" + pattern + ".*");
        }

        @Override
        public boolean test(String url) {
            return this.pattern.matcher(url).matches();
        }

        public String toString() {
            return this.pattern.toString();
        }
    }
}

