/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.security;

import com.tridium.nre.security.policy.NiagaraPermissionGroup;
import com.tridium.security.BasePermissionGroup;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.security.Permission;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class UIPermissionGroup
extends BasePermissionGroup {
    protected static final UIPermissionGroup DUMMY = new UIPermissionGroup();
    public static final String TYPE = "UI";
    private static final String RISK_KEY = "permissions.ui.riskDescription";
    private static Set<Permission> permissions = null;

    private UIPermissionGroup() {
        super(NiagaraPermissionGroup.RiskLevel.MILD, EnumSet.noneOf(NiagaraPermissionGroup.Flags.class), RISK_KEY);
        permissions = new HashSet<Permission>();
    }

    protected UIPermissionGroup(String purposeKey, EnumSet<NiagaraPermissionGroup.Flags> flags) {
        super(NiagaraPermissionGroup.RiskLevel.MILD, flags, purposeKey, null, RISK_KEY);
        if (permissions == null) {
            try {
                permissions = new HashSet<Permission>();
                Class<?> awtPermissionClass = Class.forName("java.awt.AWTPermission");
                Constructor<?> awtPermissionConstructor = awtPermissionClass.getConstructor(String.class);
                permissions.add((Permission)awtPermissionConstructor.newInstance("accessClipboard"));
                permissions.add((Permission)awtPermissionConstructor.newInstance("accessSystemTray"));
                permissions.add((Permission)awtPermissionConstructor.newInstance("fullScreenExclusive"));
                permissions.add((Permission)awtPermissionConstructor.newInstance("setWindowAlwaysOnTop"));
                permissions.add((Permission)awtPermissionConstructor.newInstance("showWindowWithoutWarningBanner"));
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                Logger log = Logger.getLogger("security.niagaraPolicy");
                log.warning("Could not instantiate UIPermissionGroup: " + e.getLocalizedMessage());
                log.log(Level.FINE, e, () -> "Error was");
            }
        }
    }

    public String getType() {
        return TYPE;
    }

    public Set<Permission> getImpliedPermissions() {
        return permissions;
    }

    protected NiagaraPermissionGroup copy() {
        return new UIPermissionGroup(this.requestingModuleName + ":" + this.purposeKey, this.getFlags());
    }

    @Override
    public List<BasePermissionGroup.ParameterInfo> getParameterInfo() {
        return null;
    }
}

