/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.security;

import com.tridium.nre.security.SigningPasswordPermission;
import com.tridium.nre.security.policy.NiagaraPermissionGroup;
import com.tridium.nre.security.policy.ParsingException;
import com.tridium.security.BasePermissionGroup;
import java.security.Permission;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class SigningPermissionGroup
extends BasePermissionGroup {
    public static final String TYPE = "SIGNING";
    static final SigningPermissionGroup DUMMY = new SigningPermissionGroup();
    private static final String RISK_KEY = "permissions.signing.riskDescription";
    private static final String MODULE_NAME_XML = "moduleName";
    private static final String MODULE_NAME_KEY = "permissions.signing.moduleName";
    private static final List<BasePermissionGroup.ParameterInfo> parameterInfoList = new ArrayList<BasePermissionGroup.ParameterInfo>();
    private final Set<Permission> permissions = new HashSet<Permission>();

    public SigningPermissionGroup() {
        super(NiagaraPermissionGroup.RiskLevel.MODERATE, EnumSet.noneOf(NiagaraPermissionGroup.Flags.class), RISK_KEY);
    }

    SigningPermissionGroup(String purposeKey, EnumSet<NiagaraPermissionGroup.Flags> flags, Map<String, String> parameters) throws ParsingException {
        super(NiagaraPermissionGroup.RiskLevel.MODERATE, flags, purposeKey, parameters, RISK_KEY);
        String moduleName = parameters.get(MODULE_NAME_XML);
        if (moduleName == null || moduleName.isEmpty()) {
            throw new ParsingException("Missing parameter <moduleName> for <SIGNING> permission group");
        }
        if ("*".equals(moduleName)) {
            throw new ParsingException("Parameter value '*' cannot be requested for parameter <moduleName> for <SIGNING> permission group");
        }
        this.permissions.add((Permission)new SigningPasswordPermission(moduleName));
    }

    public String getType() {
        return TYPE;
    }

    public Set<Permission> getImpliedPermissions() {
        return Collections.unmodifiableSet(this.permissions);
    }

    protected NiagaraPermissionGroup copy() {
        try {
            return new SigningPermissionGroup(this.requestingModuleName + ':' + this.purposeKey, (EnumSet<NiagaraPermissionGroup.Flags>)this.getFlags(), this.parameters);
        }
        catch (ParsingException parsingException) {
            return null;
        }
    }

    @Override
    public List<BasePermissionGroup.ParameterInfo> getParameterInfo() {
        return Collections.unmodifiableList(parameterInfoList);
    }

    static {
        parameterInfoList.add(new BasePermissionGroup.ParameterInfo(MODULE_NAME_XML, MODULE_NAME_KEY, "Module Name"));
    }
}

