/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.security;

import com.tridium.nre.security.NiagaraSocketPermission;
import com.tridium.nre.security.SecurityInitializer;
import com.tridium.nre.security.policy.NiagaraPermissionGroup;
import com.tridium.nre.security.policy.ParsingException;
import com.tridium.security.BasePermissionGroup;
import java.net.NetPermission;
import java.net.URLPermission;
import java.security.Permission;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.bouncycastle.crypto.CryptoServicesPermission;

public final class NetworkCommunicationPermissionGroup
extends BasePermissionGroup {
    protected static final NetworkCommunicationPermissionGroup DUMMY = new NetworkCommunicationPermissionGroup();
    public static final String TYPE = "NETWORK_COMMUNICATION";
    private static final String HOSTS_XML = "hosts";
    private static final String PORTS_XML = "ports";
    private static final String TYPE_XML = "type";
    private static final String PROXY_XML = "proxySelector";
    private static final String NETWORK_INFORMATION_XML = "getNetworkInformation";
    private static final String SSLSOCKETS_XML = "SSLSockets";
    private static final String HOST_KEY = "permissions.networkCommunication.host";
    private static final String PORTS_KEY = "permissions.networkCommunication.ports";
    private static final String TYPE_KEY = "permissions.networkCommunication.type";
    private static final String PROXY_KEY = "permissions.networkCommunication.proxy";
    private static final String SSLSOCKETS_KEY = "permissions.networkCommunication.sslsockets";
    private static final String RISK_KEY = "permissions.networkCommunication.riskDescription";
    private static final String NETWORK_INFORMATION_KEY = "permissions.networkCommunication.getNetworkInformation";
    private static final List<BasePermissionGroup.ParameterInfo> parameterInfoList = new ArrayList<BasePermissionGroup.ParameterInfo>();
    private final Set<Permission> permissions;
    private static Logger logger;

    private NetworkCommunicationPermissionGroup() {
        super(NiagaraPermissionGroup.RiskLevel.MODERATE, EnumSet.noneOf(NiagaraPermissionGroup.Flags.class), RISK_KEY);
        this.permissions = new HashSet<Permission>();
    }

    protected NetworkCommunicationPermissionGroup(String purposeKey, EnumSet<NiagaraPermissionGroup.Flags> flags, Map<String, String> parameters) throws ParsingException {
        String netInfo;
        block20: {
            String sslsockets;
            String actions;
            super(NiagaraPermissionGroup.RiskLevel.MODERATE, flags, purposeKey, parameters, RISK_KEY);
            String hosts = parameters.get(HOSTS_XML);
            if (hosts == null) {
                throw new ParsingException("Missing parameter <hosts> for <NETWORK_COMMUNICATION> permission group");
            }
            HashSet hostList = new HashSet();
            Collections.addAll(hostList, hosts.split(","));
            String ports = parameters.get(PORTS_XML);
            if (ports == null) {
                throw new ParsingException("Missing parameter <ports> for <NETWORK_COMMUNICATION> permission group");
            }
            HashSet portList = new HashSet();
            Collections.addAll(portList, ports.split(","));
            String actionType = parameters.get(TYPE_XML);
            if (actionType == null) {
                actionType = "all";
                this.parameters.put(TYPE_XML, "all");
            }
            switch (actionType.toLowerCase()) {
                case "all": {
                    actions = "accept, connect, listen, resolve";
                    break;
                }
                case "client": {
                    actions = "connect, listen";
                    break;
                }
                case "server": {
                    actions = "accept, listen";
                    break;
                }
                default: {
                    throw new ParsingException("Invalid value for NetworkCommunication parameter 'type'. Accepted value are 'client', 'server', or 'all'");
                }
            }
            this.permissions = new HashSet<Permission>();
            for (String host : hostList) {
                for (String port : portList) {
                    String hostAndPort = host + ":" + port.trim();
                    this.permissions.add((Permission)new NiagaraSocketPermission(hostAndPort, actions));
                    String httpUrl = "http://" + hostAndPort;
                    this.permissions.add(new URLPermission(httpUrl, "*:*"));
                    String httpsUrl = "https://" + hostAndPort;
                    this.permissions.add(new URLPermission(httpsUrl, "*:*"));
                    String hostAndPortAndResources = hostAndPort + "/-";
                    String httpUrlAndResoures = "http://" + hostAndPortAndResources;
                    this.permissions.add(new URLPermission(httpUrlAndResoures, "*:*"));
                    String httpsUrlAndResources = "https://" + hostAndPortAndResources;
                    this.permissions.add(new URLPermission(httpsUrlAndResources, "*:*"));
                }
            }
            String proxy = parameters.get(PROXY_XML);
            if (proxy != null && proxy.equals("get")) {
                this.permissions.add(new NetPermission("getProxySelector"));
            }
            if ((sslsockets = parameters.get(SSLSOCKETS_XML)) != null && sslsockets.equals("true")) {
                try {
                    this.permissions.add((Permission)new CryptoServicesPermission("exportPrivateKey"));
                }
                catch (Throwable t) {
                    if (!SecurityInitializer.getInstance().isFips()) break block20;
                    logger.warning("Could not initialize CryptoServicesPermission.");
                }
            }
        }
        if ((netInfo = parameters.get(NETWORK_INFORMATION_XML)) != null && netInfo.equalsIgnoreCase("true")) {
            this.permissions.add(new NetPermission(NETWORK_INFORMATION_XML));
        }
    }

    public String getType() {
        return TYPE;
    }

    public Set<Permission> getImpliedPermissions() {
        return this.permissions;
    }

    protected NiagaraPermissionGroup copy() {
        try {
            return new NetworkCommunicationPermissionGroup(this.requestingModuleName + ":" + this.purposeKey, (EnumSet<NiagaraPermissionGroup.Flags>)this.getFlags(), this.parameters);
        }
        catch (ParsingException parsingException) {
            return null;
        }
    }

    @Override
    public List<BasePermissionGroup.ParameterInfo> getParameterInfo() {
        return parameterInfoList;
    }

    static {
        parameterInfoList.add(new BasePermissionGroup.ParameterInfo(HOSTS_XML, HOST_KEY, "Host"));
        parameterInfoList.add(new BasePermissionGroup.ParameterInfo(PORTS_XML, PORTS_KEY, "Ports"));
        parameterInfoList.add(new BasePermissionGroup.ParameterInfo(TYPE_XML, TYPE_KEY, "Type"));
        parameterInfoList.add(new BasePermissionGroup.ParameterInfo(PROXY_XML, PROXY_KEY, "Proxy Selector"));
        parameterInfoList.add(new BasePermissionGroup.ParameterInfo(NETWORK_INFORMATION_XML, NETWORK_INFORMATION_KEY, "Get Network Information"));
        parameterInfoList.add(new BasePermissionGroup.ParameterInfo(SSLSOCKETS_XML, SSLSOCKETS_KEY, "SSL Sockets"));
        logger = Logger.getLogger("security.niagaraPolicy.permissions");
    }
}

