/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.security;

import com.tridium.nre.security.KeyStorePermission;
import com.tridium.nre.security.policy.NiagaraPermissionGroup;
import com.tridium.nre.security.policy.ParsingException;
import com.tridium.security.BasePermissionGroup;
import java.security.Permission;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;

public final class KeyStorePermissionGroup
extends BasePermissionGroup {
    protected static final KeyStorePermissionGroup DUMMY = new KeyStorePermissionGroup();
    public static final String TYPE = "KEY_STORE";
    private static final String KEYSTORES_XML = "keystores";
    private static final String ACTIONS_XML = "actions";
    private static final String KEYSTORES_KEY = "permissions.keyStore.keystores";
    private static final String ACTIONS_KEY = "permissions.keyStore.actions";
    private static final String RISK_KEY = "permissions.keyStore.riskDescription";
    private static final List<BasePermissionGroup.ParameterInfo> parameterInfoList = new ArrayList<BasePermissionGroup.ParameterInfo>();
    private final Set<Permission> permissions;

    private KeyStorePermissionGroup() {
        super(NiagaraPermissionGroup.RiskLevel.MODERATE, EnumSet.noneOf(NiagaraPermissionGroup.Flags.class), RISK_KEY);
        this.permissions = new HashSet<Permission>();
    }

    protected KeyStorePermissionGroup(String purposeKey, EnumSet<NiagaraPermissionGroup.Flags> flags, Map<String, String> parameters) throws ParsingException {
        super(NiagaraPermissionGroup.RiskLevel.MODERATE, flags, purposeKey, parameters, RISK_KEY);
        String keyStores = parameters.get(KEYSTORES_XML);
        if (keyStores == null) {
            throw new ParsingException("Missing parameter <keystores> for <KEY_STORE> permission group");
        }
        String actions = parameters.get(ACTIONS_XML);
        if (actions == null) {
            throw new ParsingException("Missing parameter <actions> for <KEY_STORE> permission group");
        }
        this.permissions = new HashSet<Permission>();
        StringTokenizer tokenizer = new StringTokenizer(keyStores, ",");
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            this.permissions.add((Permission)new KeyStorePermission(token, actions));
        }
    }

    @Override
    public List<BasePermissionGroup.ParameterInfo> getParameterInfo() {
        return Collections.unmodifiableList(parameterInfoList);
    }

    public String getType() {
        return TYPE;
    }

    public Set<Permission> getImpliedPermissions() {
        return Collections.unmodifiableSet(this.permissions);
    }

    protected NiagaraPermissionGroup copy() {
        try {
            return new KeyStorePermissionGroup(this.requestingModuleName + ':' + this.purposeKey, (EnumSet<NiagaraPermissionGroup.Flags>)this.getFlags(), this.parameters);
        }
        catch (ParsingException parsingException) {
            return null;
        }
    }

    static {
        parameterInfoList.add(new BasePermissionGroup.ParameterInfo(KEYSTORES_XML, KEYSTORES_KEY, "Keystores"));
        parameterInfoList.add(new BasePermissionGroup.ParameterInfo(ACTIONS_XML, ACTIONS_KEY, "Actions"));
    }
}

