/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.security;

import com.tridium.nre.security.policy.NiagaraPermission;
import com.tridium.nre.security.policy.NiagaraPolicyUtil;
import java.io.File;
import java.io.FilePermission;
import java.security.AccessController;
import java.security.Permission;
import java.security.PermissionCollection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;

public final class JavaLibraryPathFilePermission
extends NiagaraPermission {
    private static final Set<Class<? extends Permission>> classSet = Collections.singleton(FilePermission.class);
    private final String regexPattern;

    public JavaLibraryPathFilePermission(String name) {
        super(name, "read");
        this.regexPattern = NiagaraPolicyUtil.createRegexPatternFromName((String)name);
    }

    public Set<Class<? extends Permission>> getSupportedClasses() {
        return classSet;
    }

    public boolean implies(Permission permission) {
        String[] javaLibraryPaths;
        String concatenatedLibraryPaths = AccessController.doPrivileged(() -> System.getProperty("java.library.path"));
        if (concatenatedLibraryPaths == null) {
            return false;
        }
        int lastSeparatorIdx = permission.getName().lastIndexOf(File.separator);
        String fileName = lastSeparatorIdx >= 0 ? permission.getName().substring(lastSeparatorIdx + 1) : permission.getName();
        if (!fileName.matches(this.regexPattern)) {
            return false;
        }
        for (String javaLibraryPath : javaLibraryPaths = concatenatedLibraryPaths.split(File.pathSeparator)) {
            String libraryPermissionPath = javaLibraryPath.endsWith(File.separator) ? javaLibraryPath + '-' : javaLibraryPath + File.separator + '-';
            FilePermission libraryPermission = new FilePermission(libraryPermissionPath, "read");
            if (!libraryPermission.implies(permission)) continue;
            return true;
        }
        return false;
    }

    public PermissionCollection newPermissionCollection() {
        return new JavaLibraryPathFilePermissionCollection();
    }

    private static final class JavaLibraryPathFilePermissionCollection
    extends PermissionCollection {
        private final Set<Permission> permissions = new HashSet<Permission>();

        private JavaLibraryPathFilePermissionCollection() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void add(Permission permission) {
            if (!permission.getClass().equals(JavaLibraryPathFilePermission.class)) {
                throw new IllegalArgumentException(String.format("Class %s is not %s", permission.getClass(), JavaLibraryPathFilePermission.class));
            }
            if (this.isReadOnly()) {
                throw new SecurityException("Attempt to modify a read-only PermissionCollection");
            }
            JavaLibraryPathFilePermissionCollection javaLibraryPathFilePermissionCollection = this;
            synchronized (javaLibraryPathFilePermissionCollection) {
                this.permissions.add(permission);
            }
        }

        @Override
        public synchronized boolean implies(Permission permission) {
            return this.permissions.stream().anyMatch(p -> p.implies(permission));
        }

        @Override
        public synchronized Enumeration<Permission> elements() {
            return Collections.enumeration(this.permissions);
        }
    }
}

