/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.security;

import com.tridium.nre.security.policy.NiagaraPermissionGroup;
import com.tridium.nre.security.policy.ParsingException;
import com.tridium.security.BasePermissionGroup;
import java.security.Permission;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class EnvironmentVariablePermissionGroup
extends BasePermissionGroup {
    protected static final EnvironmentVariablePermissionGroup DUMMY = new EnvironmentVariablePermissionGroup();
    public static final String TYPE = "GET_ENVIRONMENT_VARIABLES";
    private static final String VAR_NAME_XML = "variables";
    private static final String VAR_NAME_KEY = "permissions.environmentVariables.variables";
    private static final String RISK_KEY = "permissions.environmentVariables.riskDescription";
    private static final List<BasePermissionGroup.ParameterInfo> parameterInfoList = new ArrayList<BasePermissionGroup.ParameterInfo>();
    private final Set<Permission> permissions;

    private EnvironmentVariablePermissionGroup() {
        super(NiagaraPermissionGroup.RiskLevel.MILD, EnumSet.noneOf(NiagaraPermissionGroup.Flags.class), RISK_KEY);
        this.permissions = new HashSet<Permission>();
    }

    protected EnvironmentVariablePermissionGroup(String purposeKey, EnumSet<NiagaraPermissionGroup.Flags> flags, Map<String, String> parameters) throws ParsingException {
        super(NiagaraPermissionGroup.RiskLevel.MILD, flags, purposeKey, parameters, RISK_KEY);
        String variablesString = parameters.get(VAR_NAME_XML);
        if (variablesString == null) {
            throw new ParsingException("Missing parameter <variables> for <GET_ENVIRONMENT_VARIABLES> permission group");
        }
        String[] variables = variablesString.split(",");
        this.permissions = new HashSet<Permission>();
        for (String variable : variables) {
            this.permissions.add(new RuntimePermission("getenv." + variable.trim()));
        }
    }

    public String getType() {
        return TYPE;
    }

    public Set<Permission> getImpliedPermissions() {
        return this.permissions;
    }

    protected NiagaraPermissionGroup copy() {
        try {
            return new EnvironmentVariablePermissionGroup(this.requestingModuleName + ":" + this.purposeKey, (EnumSet<NiagaraPermissionGroup.Flags>)this.getFlags(), this.parameters);
        }
        catch (ParsingException parsingException) {
            return null;
        }
    }

    @Override
    public List<BasePermissionGroup.ParameterInfo> getParameterInfo() {
        return parameterInfoList;
    }

    static {
        parameterInfoList.add(new BasePermissionGroup.ParameterInfo(VAR_NAME_XML, VAR_NAME_KEY, "Variables"));
    }
}

