/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.security;

import com.tridium.nre.security.policy.NiagaraPermissionGroup;
import com.tridium.nre.security.policy.ParsingException;
import com.tridium.security.BasePermissionGroup;
import java.security.Permission;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class AccessClassPermissionGroup
extends BasePermissionGroup {
    protected static final AccessClassPermissionGroup DUMMY = new AccessClassPermissionGroup();
    public static final String TYPE = "ACCESS_CLASS";
    private static final String PACKAGES_XML = "packages";
    private static final String PACKAGES_KEY = "permissions.accessClass.packages";
    private static final String RISK_KEY = "permissions.accessClass.riskDescription";
    private static final List<BasePermissionGroup.ParameterInfo> parameterInfoList = new ArrayList<BasePermissionGroup.ParameterInfo>();
    private final Set<Permission> permissions;

    private AccessClassPermissionGroup() {
        super(NiagaraPermissionGroup.RiskLevel.SEVERE, EnumSet.noneOf(NiagaraPermissionGroup.Flags.class), RISK_KEY);
        this.permissions = new HashSet<Permission>();
    }

    protected AccessClassPermissionGroup(String purposeKey, EnumSet<NiagaraPermissionGroup.Flags> flags, Map<String, String> parameters) throws ParsingException {
        super(NiagaraPermissionGroup.RiskLevel.SEVERE, flags, purposeKey, parameters, RISK_KEY);
        String packagesString = parameters.get(PACKAGES_XML);
        if (packagesString == null) {
            throw new ParsingException("Missing parameter <packages> for <ACCESS_CLASS> permission group");
        }
        String[] packages = packagesString.split(",");
        this.permissions = new HashSet<Permission>();
        for (String pkg : packages) {
            this.permissions.add(new RuntimePermission("accessClassInPackage." + pkg.trim()));
        }
    }

    public String getType() {
        return TYPE;
    }

    public Set<Permission> getImpliedPermissions() {
        return this.permissions;
    }

    protected NiagaraPermissionGroup copy() {
        try {
            return new AccessClassPermissionGroup(this.requestingModuleName + ':' + this.purposeKey, (EnumSet<NiagaraPermissionGroup.Flags>)this.getFlags(), this.parameters);
        }
        catch (ParsingException parsingException) {
            return null;
        }
    }

    public boolean requiresSignature() {
        return true;
    }

    @Override
    public List<BasePermissionGroup.ParameterInfo> getParameterInfo() {
        return parameterInfoList;
    }

    static {
        parameterInfoList.add(new BasePermissionGroup.ParameterInfo(PACKAGES_XML, PACKAGES_KEY, "Packages"));
    }
}

