/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.logging;

import com.tridium.logging.BILoggingService;
import com.tridium.logging.LogSettings;
import com.tridium.util.PxUtil;
import java.lang.management.ManagementFactory;
import java.lang.management.PlatformLoggingMXBean;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringJoiner;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.baja.agent.AgentList;
import javax.baja.log.Log;
import javax.baja.naming.BOrd;
import javax.baja.naming.SlotPath;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.security.BPermissions;
import javax.baja.security.PermissionException;
import javax.baja.security.dashboard.BISecurityDashboardProvider;
import javax.baja.security.dashboard.LexiconFormatInfo;
import javax.baja.security.dashboard.SecurityDashboardItem;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIService;
import javax.baja.sys.BIcon;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BFormat;
import javax.baja.util.BIRestrictedComponent;
import javax.baja.util.BNameList;
import javax.baja.util.BNameMap;

@NiagaraType
@NiagaraProperty(name="enableRemoteLogging", type="boolean", defaultValue="false")
@NiagaraActions(value={@NiagaraAction(name="readSettings", returnType="BNameMap", flags=4), @NiagaraAction(name="reloadSettings", parameterType="BNameMap", defaultValue="BNameMap.DEFAULT", flags=4), @NiagaraAction(name="loadKnownLogs", returnType="BNameList", flags=4)})
public final class BLoggingService
extends BComponent
implements BILoggingService,
BIService,
BIRestrictedComponent,
BISecurityDashboardProvider {
    @Generated
    public static final Property enableRemoteLogging = BLoggingService.newProperty(0, false, null);
    @Generated
    public static final Action readSettings = BLoggingService.newAction(4, null);
    @Generated
    public static final Action reloadSettings = BLoggingService.newAction(4, BNameMap.DEFAULT, null);
    @Generated
    public static final Action loadKnownLogs = BLoggingService.newAction(4, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BLoggingService.class);
    private static final BIcon Icon = BIcon.std("log.png");
    private static final Set<String> RISKY_LEVELS = BLoggingService.createRiskLevelSet();
    private static final Set<String> BLACK_LIST = BLoggingService.createBlackList();
    private static final Pattern LOG_LEVEL_PATTERN = Pattern.compile("(.*)\\.level$");

    @Generated
    public boolean getEnableRemoteLogging() {
        return this.getBoolean(enableRemoteLogging);
    }

    @Generated
    public void setEnableRemoteLogging(boolean v) {
        this.setBoolean(enableRemoteLogging, v, null);
    }

    @Generated
    public BNameMap readSettings() {
        return (BNameMap)this.invoke(readSettings, null, null);
    }

    @Generated
    public void reloadSettings(BNameMap parameter) {
        this.invoke(reloadSettings, parameter, null);
    }

    @Generated
    public BNameList loadKnownLogs() {
        return (BNameList)this.invoke(loadKnownLogs, null, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    @Override
    public Properties readLogSettings() {
        return BLoggingService.toProperties(this.readSettings());
    }

    public BNameMap doReadSettings(Context cx) throws Exception {
        if (!LogSettings.getPermissions(cx).hasAdminRead()) {
            throw new PermissionException();
        }
        Properties raw = new LogSettings().getRawProperties();
        return BLoggingService.toMap(raw);
    }

    @Override
    public void reload(Properties settings) throws Exception {
        this.reloadSettings(BLoggingService.toMap(settings));
    }

    public void doReloadSettings(BNameMap map, Context cx) throws Exception {
        if (!LogSettings.getPermissions(cx).hasAdminWrite()) {
            throw new PermissionException();
        }
        LogSettings.reload(BLoggingService.toProperties(map));
    }

    @Override
    public BPermissions getPermissions(Context cx) {
        return cx != null && cx.getUser() != null && !cx.getUser().getPermissions().isSuperUser() ? BPermissions.DEFAULT : super.getPermissions(cx);
    }

    private static BNameMap toMap(Properties raw) {
        HashMap<String, BFormat> map = new HashMap<String, BFormat>();
        for (String key : raw.stringPropertyNames()) {
            map.put(key, BFormat.make(raw.getProperty(key)));
        }
        return BNameMap.make(map);
    }

    private static Properties toProperties(BNameMap map) {
        Properties raw = new Properties();
        for (String key : map.list()) {
            raw.setProperty(key, map.get(key).getFormat());
        }
        return raw;
    }

    @Override
    public List<String> getRegisteredLoggers() {
        ArrayList<String> logs = new ArrayList<String>(32);
        for (String log : this.loadKnownLogs().getNames()) {
            logs.add(SlotPath.unescape(log));
        }
        return logs;
    }

    public BNameList doLoadKnownLogs() {
        ArrayList<String> logs = new ArrayList<String>();
        for (String log : ManagementFactory.getPlatformMXBean(PlatformLoggingMXBean.class).getLoggerNames()) {
            if (log != null && log.isEmpty()) continue;
            logs.add(SlotPath.escape(log));
        }
        return BNameList.make(logs.toArray(new String[0]));
    }

    public Map<String, String> getLevels(Context cx) {
        Properties props = this.readLogSettings();
        HashMap<String, String> levels = new HashMap<String, String>();
        for (String prop : props.stringPropertyNames()) {
            Matcher m = LOG_LEVEL_PATTERN.matcher(prop);
            if (!m.find()) continue;
            levels.put(m.group(1), props.getProperty(prop));
        }
        return levels;
    }

    @Override
    public Type[] getServiceTypes() {
        return new Type[]{TYPE, BILoggingService.TYPE};
    }

    @Override
    public void serviceStarted() {
    }

    @Override
    public void serviceStopped() {
    }

    @Override
    public AgentList getAgents(Context cx) {
        AgentList agents = super.getAgents(cx);
        agents.toTop("workbench:LoggerConfiguration");
        return PxUtil.movePxViewsToTop(agents);
    }

    @Override
    public void spy(SpyWriter out) throws Exception {
        super.spy(out);
        out.startProps();
        out.trTitle("RegisteredLoggers", 2);
        List<String> registeredLoggers = this.getRegisteredLoggers();
        registeredLoggers.sort(String.CASE_INSENSITIVE_ORDER);
        for (String s : registeredLoggers) {
            boolean isLog = Log.isLog(s);
            String maxSeverity = "";
            Logger thisLogger = Logger.getLogger(s);
            if (isLog) {
                maxSeverity = Log.getLog(s).getSeverityString();
            }
            Level level = thisLogger.getLevel();
            boolean inherited = false;
            while (level == null && thisLogger != null) {
                inherited = true;
                thisLogger = thisLogger.getParent();
                level = thisLogger.getLevel();
            }
            String thisLoggerName = thisLogger.getName();
            if (thisLoggerName.isEmpty()) {
                thisLoggerName = "default";
            }
            StringBuilder value = new StringBuilder();
            value.append(inherited ? ' ' + thisLoggerName + '.' : " ").append("level=").append(level);
            if (isLog) {
                value.append(", (Log) ").append(maxSeverity);
            }
            out.prop((Object)s, value);
        }
        out.endProps();
    }

    @Override
    public LexiconFormatInfo getSecurityDashboardSectionHeader(Context cx) {
        return LexiconFormatInfo.make(TYPE, "securityDashboard.loggingService.sectionHeader");
    }

    @Override
    public BOrd getSecurityDashboardSectionHyperlinkOrd() {
        return this.getNavOrd().relativizeToSession();
    }

    @Override
    public int getSecurityDashboardItemsVersion() {
        return 1;
    }

    @Override
    public List<SecurityDashboardItem> getSecurityDashboardItems(Context cx) {
        Map<String, String> levels = this.getLevels(null);
        StringJoiner riskyLogs = new StringJoiner(", ");
        for (Map.Entry<String, String> entry : levels.entrySet()) {
            if (!RISKY_LEVELS.contains(entry.getValue()) || BLACK_LIST.contains(entry.getKey())) continue;
            riskyLogs.add(entry.getKey());
        }
        if (riskyLogs.length() == 0) {
            return Collections.singletonList(SecurityDashboardItem.makeOk(TYPE, "securityDashboard.logLevel.allOk.summary", "securityDashboard.logLevel.description"));
        }
        return Collections.singletonList(SecurityDashboardItem.makeWarning(TYPE, LexiconFormatInfo.make(TYPE, "securityDashboard.logLevel.warning.summary", riskyLogs.toString()), "securityDashboard.logLevel.description"));
    }

    @Override
    public BIcon getIcon() {
        return Icon;
    }

    private static Set<String> createRiskLevelSet() {
        HashSet<String> riskSet = new HashSet<String>();
        riskSet.add("FINE");
        riskSet.add("FINER");
        riskSet.add("FINEST");
        riskSet.add("ALL");
        return Collections.unmodifiableSet(riskSet);
    }

    private static Set<String> createBlackList() {
        HashSet<String> blackList = new HashSet<String>();
        blackList.add("java.util.logging.ConsoleHandler");
        return Collections.unmodifiableSet(blackList);
    }
}

