/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.firewall;

import com.tridium.nre.firewall.FirewallRule;
import com.tridium.nre.firewall.RedirectRule;
import javax.baja.firewall.BServerPort;
import javax.baja.spy.SpyDir;
import javax.baja.spy.SpyWriter;

public class FirewallRulesPage
extends SpyDir {
    @Override
    public void write(SpyWriter out) throws Exception {
        try {
            out.w("<b>").safe(BServerPort.getFirewallName()).w("</b><br><br>").nl();
            out.w("<p>").safe(BServerPort.getFirewallDescription()).w("</p><br>").nl();
            FirewallRule[] rules = BServerPort.getRuleList();
            if (rules.length <= 0) {
                out.println("<i>no rules currently defined</i><br>");
            } else {
                out.w("<b>Redirect Rules</b><br><br>").nl();
                out.startTable(true);
                out.w("<tr>").nl();
                out.thTitle("publicServerPort").nl();
                out.thTitle("localServerPort").nl();
                out.thTitle("ipProtocol").nl();
                out.thTitle("adapter").nl();
                out.w("</tr>").nl();
                for (FirewallRule rule : rules) {
                    switch (rule.getRuleType()) {
                        case REDIRECT_RULE: {
                            RedirectRule rdrRule = (RedirectRule)rule;
                            out.tr(rdrRule.getPublicServerPort(), rdrRule.getLocalServerPort(), rdrRule.getIpProtocol().toString(), rdrRule.getAdapter());
                        }
                    }
                }
                out.endTable();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

