/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.authn;

import com.tridium.authn.AbstractNiagaraLoginModule;
import com.tridium.authn.NiagaraFailedLoginException;
import java.util.logging.Level;
import javax.baja.authn.AuthenticationUtil;
import javax.baja.security.BPasswordCache;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.FailedLoginException;
import javax.security.auth.login.LoginException;

public class UsernamePasswordLoginModule
extends AbstractNiagaraLoginModule {
    /*
     * WARNING - void declaration
     */
    @Override
    public boolean doLogin() throws LoginException {
        void var4_10;
        char[] password;
        String username;
        if (this.callbackHandler == null) {
            throw new LoginException("CallbackHandler cannot be null for username and password login");
        }
        Callback[] callbacks = new Callback[]{new NameCallback("name"), new PasswordCallback("password", false)};
        try {
            this.callbackHandler.handle(callbacks);
            username = ((NameCallback)callbacks[0]).getName();
            if (username.isEmpty()) {
                return false;
            }
            char[] cArray = ((PasswordCallback)callbacks[1]).getPassword();
            password = new char[cArray.length];
            System.arraycopy(cArray, 0, password, 0, cArray.length);
            ((PasswordCallback)callbacks[1]).clearPassword();
        }
        catch (UnsupportedCallbackException unsupportedCallbackException) {
            String msg = "Provided callback handler could not handle: " + unsupportedCallbackException.getCallback().toString();
            AuthenticationUtil.debug(Level.SEVERE, msg, unsupportedCallbackException);
            throw new LoginException(msg);
        }
        catch (Exception exception) {
            String msg = "Error handling callbacks:" + exception.toString();
            AuthenticationUtil.debug(Level.SEVERE, msg, exception);
            throw new LoginException(msg);
        }
        this.user = this.getUserService().getUser(username);
        if (this.user != null && this.user.getAuthenticator() instanceof BPasswordCache && ((BPasswordCache)this.user.getAuthenticator()).validate(new String(password))) {
            this.succeeded = true;
            return true;
        }
        for (char c : password) {
            c = '\u0000';
        }
        password = null;
        this.succeeded = false;
        if (this.user != null && this.user.getAuthenticator() instanceof BPasswordCache) {
            NiagaraFailedLoginException niagaraFailedLoginException = new NiagaraFailedLoginException(this.user.getName(), "Login failed: Invalid username or password.");
            this.user = null;
        } else if (this.user != null) {
            NiagaraFailedLoginException niagaraFailedLoginException = new NiagaraFailedLoginException(this.user.getName(), "Login failed: expected a username and password.");
            this.user = null;
        } else {
            FailedLoginException failedLoginException = new FailedLoginException("Login failed: Invalid username or password.");
        }
        throw var4_10;
    }
}

