/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.asm;

import com.tridium.asm.OpCodes;

public final class Jvm
implements OpCodes {
    public static final int MAGIC = -889275714;
    public static final int MINOR_VERSION = 3;
    public static final int MAJOR_VERSION = 45;
    public static final int ACC_PUBLIC = 1;
    public static final int ACC_PRIVATE = 2;
    public static final int ACC_PROTECTED = 4;
    public static final int ACC_STATIC = 8;
    public static final int ACC_FINAL = 16;
    public static final int ACC_SUPER = 32;
    public static final int ACC_SYNCHRONIZED = 32;
    public static final int ACC_VOLATILE = 64;
    public static final int ACC_TRANSIENT = 128;
    public static final int ACC_NATIVE = 256;
    public static final int ACC_INTERFACE = 512;
    public static final int ACC_ABSTRACT = 1024;
    public static final int CONSTANT_Utf8 = 1;
    public static final int CONSTANT_Integer = 3;
    public static final int CONSTANT_Float = 4;
    public static final int CONSTANT_Long = 5;
    public static final int CONSTANT_Double = 6;
    public static final int CONSTANT_Class = 7;
    public static final int CONSTANT_String = 8;
    public static final int CONSTANT_Fieldref = 9;
    public static final int CONSTANT_Methodref = 10;
    public static final int CONSTANT_InterfaceMethodref = 11;
    public static final int CONSTANT_NameAndType = 12;
    public static final int CONSTANT_MethodHandle = 15;
    public static final int CONSTANT_MethodType = 16;
    public static final int CONSTANT_InvokeDynamic = 18;
    public static final String ATTR_SOURCE_FILE = "SourceFile";
    public static final String ATTR_CONSTANT_VALUE = "ConstantValue";
    public static final String ATTR_CODE = "Code";
    public static final String ATTR_EXCEPTIONS = "Exceptions";
    public static final String ATTR_LINE_NUMBER_TABLE = "LineNumberTable";
    public static final String ATTR_DEPRECATED = "Deprecated";
    public static final String ATTR_INNER_CLASSES = "InnerClasses";
    public static final String ATTR_SYNTHETIC = "Synthetic";
    public static final String ATTR_LOCAL_VARIABLE_TABLE = "LocalVariableTable";
    public static final String ATTR_ENCLOSING_METHOD = "EnclosingMethod";
    public static final String ATTR_SIGNATURE = "Signature";
    public static final String ATTR_RUNTIME_VISIBLE_ANNOTATIONS = "RuntimeVisibleAnnotations";
    public static final int T_BOOLEAN = 4;
    public static final int T_CHAR = 5;
    public static final int T_FLOAT = 6;
    public static final int T_DOUBLE = 7;
    public static final int T_BYTE = 8;
    public static final int T_SHORT = 9;
    public static final int T_INT = 10;
    public static final int T_LONG = 11;
    public static final byte NONE = 0;
    public static final byte U1 = 1;
    public static final byte U2 = 2;
    public static final byte B2 = 3;
    public static final byte B4 = 4;
    public static final byte SPECIAL = 5;
    public static final byte[] OPCODE_ARGS = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 5, 5, 1, 2, 2, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 1, 5, 5, 0, 0, 0, 0, 0, 0, 2, 2, 2, 2, 2, 2, 2, 5, 0, 2, 1, 2, 0, 0, 2, 2, 0, 0, 5, 5, 3, 3, 4, 4};
    public static final String[] OPCODE_STRINGS = new String[]{"NOP", "ACONST_NULL", "ICONST_M1", "ICONST_0", "ICONST_1", "ICONST_2", "ICONST_3", "ICONST_4", "ICONST_5", "LCONST_0", "LCONST_1", "FCONST_0", "FCONST_1", "FCONST_2", "DCONST_0", "DCONST_1", "BIPUSH", "SIPUSH", "LDC", "LDC_W", "LDC2_W", "ILOAD", "LLOAD", "FLOAD", "DLOAD", "ALOAD", "ILOAD_0", "ILOAD_1", "ILOAD_2", "ILOAD_3", "LLOAD_0", "LLOAD_1", "LLOAD_2", "LLOAD_3", "FLOAD_0", "FLOAD_1", "FLOAD_2", "FLOAD_3", "DLOAD_0", "DLOAD_1", "DLOAD_2", "DLOAD_3", "ALOAD_0", "ALOAD_1", "ALOAD_2", "ALOAD_3", "IALOAD", "LALOAD", "FALOAD", "DALOAD", "AALOAD", "BALOAD", "CALOAD", "SALOAD", "ISTORE", "LSTORE", "FSTORE", "DSTORE", "ASTORE", "ISTORE_0", "ISTORE_1", "ISTORE_2", "ISTORE_3", "LSTORE_0", "LSTORE_1", "LSTORE_2", "LSTORE_3", "FSTORE_0", "FSTORE_1", "FSTORE_2", "FSTORE_3", "DSTORE_0", "DSTORE_1", "DSTORE_2", "DSTORE_3", "ASTORE_0", "ASTORE_1", "ASTORE_2", "ASTORE_3", "IASTORE", "LASTORE", "FASTORE", "DASTORE", "AASTORE", "BASTORE", "CASTORE", "SASTORE", "POP", "POP2", "DUP", "DUP_X1", "DUP_X2", "DUP2", "DUP2_X1", "DUP2_X2", "SWAP", "IADD", "LADD", "FADD", "DADD", "ISUB", "LSUB", "FSUB", "DSUB", "IMUL", "LMUL", "FMUL", "DMUL", "IDIV", "LDIV", "FDIV", "DDIV", "IREM", "LREM", "FREM", "DREM", "INEG", "LNEG", "FNEG", "DNEG", "ISHL", "LSHL", "ISHR", "LSHR", "IUSHR", "LUSHR", "IAND", "LAND", "IOR", "LOR", "IXOR", "LXOR", "IINC", "I2L", "I2F", "I2D", "L2I", "L2F", "L2D", "F2I", "F2L", "F2D", "D2I", "D2L", "D2F", "I2B", "I2C", "I2S", "LCMP", "FCMPL", "FCMPG", "DCMPL", "DCMPG", "IFEQ", "IFNE", "IFLT", "IFGE", "IFGT", "IFLE", "IF_ICMPEQ", "IF_ICMPNE", "IF_ICMPLT", "IF_ICMPGE", "IF_ICMPGT", "IF_ICMPLE", "IF_ACMPEQ", "IF_ACMPNU", "GOTO", "JSR", "RET", "TABLESWITCH", "LOOKUPSWITCH", "IRETURN", "LRETURN", "FRETURN", "DRETURN", "ARETURN", "RETURN", "GETSTATIC", "PUTSTATIC", "GETFIELD", "PUTFIELD", "INVOKEVIRTUAL", "INVOKESPECIAL", "INVOKESTATIC", "INVOKEINTERFACE=", "XXX_UNUSED_XXX", "NEW", "NEWARRAY", "ANEWARRAY", "ARRAYLENGTH", "ATHROW", "CHECKCAST", "INSTANCEOF", "MONITORENTER", "MONITOREXIT", "WIDE", "MULTIANEWARRAY", "IFNULL", "IFNONNULL", "GOTO_W", "JSR_W"};

    private Jvm() {
    }

    public static String fieldDescriptor(Class<?> cls) {
        if (cls.isPrimitive()) {
            if (cls.equals(Byte.TYPE)) {
                return "B";
            }
            if (cls.equals(Character.TYPE)) {
                return "C";
            }
            if (cls.equals(Double.TYPE)) {
                return "D";
            }
            if (cls.equals(Float.TYPE)) {
                return "F";
            }
            if (cls.equals(Integer.TYPE)) {
                return "I";
            }
            if (cls.equals(Long.TYPE)) {
                return "J";
            }
            if (cls.equals(Short.TYPE)) {
                return "S";
            }
            if (cls.equals(Boolean.TYPE)) {
                return "Z";
            }
            if (cls.equals(Void.TYPE)) {
                return "V";
            }
            throw new IllegalStateException();
        }
        if (cls.isArray()) {
            return '[' + Jvm.fieldDescriptor(cls.getComponentType());
        }
        return 'L' + cls.getName().replace('.', '/') + ';';
    }

    public static String methodDescriptor(Class<?>[] paramTypes, Class<?> returnType) {
        StringBuilder s = new StringBuilder("(");
        if (paramTypes != null) {
            for (int i = 0; i < paramTypes.length; ++i) {
                s.append(Jvm.fieldDescriptor(paramTypes[i]));
            }
        }
        s.append(')').append(Jvm.fieldDescriptor(returnType));
        return s.toString();
    }
}

