/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.asm;

import com.tridium.asm.Assembler;
import com.tridium.asm.Buffer;

public class AttributeInfo {
    private static final byte[] EMPTY = new byte[0];
    public final Assembler asm;
    public final int name;
    public byte[] info = EMPTY;

    public AttributeInfo(Assembler asm, int name, byte[] info) {
        this.asm = asm;
        this.name = name;
        this.info = info;
    }

    public AttributeInfo(Assembler asm, String name, byte[] info) {
        this.asm = asm;
        this.name = asm.cp.utf(name);
        this.info = info;
    }

    public AttributeInfo(Assembler asm, String name, String value) {
        this.asm = asm;
        this.name = asm.cp.utf(name);
        int v = asm.cp.utf(value);
        this.info = new byte[2];
        this.info[0] = (byte)(v >>> 8 & 0xFF);
        this.info[1] = (byte)(v >>> 0 & 0xFF);
    }

    public AttributeInfo(Assembler asm, int name) {
        this.asm = asm;
        this.name = name;
    }

    public AttributeInfo(Assembler asm, String name) {
        this.asm = asm;
        this.name = asm.cp.utf(name);
    }

    void compile(Buffer buf) {
        buf.u2(this.name);
        buf.u4(this.info.length);
        buf.append(this.info);
    }
}

