/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.asm;

import com.tridium.asm.AttributeInfo;
import com.tridium.asm.Buffer;
import com.tridium.asm.ConstantPool;
import com.tridium.asm.FieldInfo;
import com.tridium.asm.MethodInfo;
import java.util.ArrayList;
import java.util.List;

public class Assembler {
    public final int thisClass;
    public final int superClass;
    public final int[] interfaces;
    public final int accessFlags;
    public final ConstantPool cp = new ConstantPool();
    private List<FieldInfo> fields = new ArrayList<FieldInfo>();
    private List<MethodInfo> methods = new ArrayList<MethodInfo>();
    private List<AttributeInfo> attributes = new ArrayList<AttributeInfo>();

    public Assembler(String thisClass, String superClass, int accessFlags, String[] interfaces) {
        this.thisClass = this.cp.cls(thisClass);
        this.superClass = superClass == null ? 0 : this.cp.cls(superClass);
        this.accessFlags = accessFlags;
        this.interfaces = new int[interfaces == null ? 0 : interfaces.length];
        for (int i = 0; i < this.interfaces.length; ++i) {
            this.interfaces[i] = this.cp.cls(interfaces[i]);
        }
    }

    public void addField(FieldInfo f) {
        this.fields.add(f);
    }

    public void addMethod(MethodInfo m) {
        this.methods.add(m);
    }

    public void addAttribute(AttributeInfo a) {
        this.attributes.add(a);
    }

    public Buffer compile() {
        int i;
        Buffer buf = new Buffer();
        buf.u4(-889275714);
        buf.u2(3);
        buf.u2(45);
        buf.u2(this.cp.count + 1);
        buf.append(this.cp.buf);
        buf.u2(this.accessFlags);
        buf.u2(this.thisClass);
        buf.u2(this.superClass);
        buf.u2(this.interfaces.length);
        for (i = 0; i < this.interfaces.length; ++i) {
            buf.u2(this.interfaces[i]);
        }
        buf.u2(this.fields.size());
        for (i = 0; i < this.fields.size(); ++i) {
            this.fields.get(i).compile(buf);
        }
        buf.u2(this.methods.size());
        for (i = 0; i < this.methods.size(); ++i) {
            this.methods.get(i).compile(buf);
        }
        buf.u2(this.attributes.size());
        for (i = 0; i < this.attributes.size(); ++i) {
            this.attributes.get(i).compile(buf);
        }
        return buf;
    }
}

